/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class IPCtrlDeleteCommand
extends RedfishCommand {
    int index;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                this.index = Integer.parseInt(this.parameters[0]);
            }
            catch (Exception e) {
                MOut.G(this).print("Rule number error");
                this.printUsage();
                return false;
            }
            return true;
        }
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/";
        int result = bc.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode ServiceEnabled = node.path("ServiceEnabled");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                url = "https://" + ip + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "IPAccessControl/" + "FilterRules" + "/" + this.index;
                int result2 = bc.send_https_delete(url);
                if (result2 >= 200 && result2 <= 210) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else {
                    this.printFailMessage(result2, bc.getResponseString());
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("IP Access Control is disabled");
                this.statusCode = 149;
            }
        } else {
            this.printFailMessage(result, bc.getResponseString());
            this.statusCode = 149;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish ipctrl delete <rule no>");
    }
}

