/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.SystemLockdownCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;

public abstract class RedfishCommand
extends Command {
    protected ISessionController sessionController = null;

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;

    @Override
    public void execute() throws Exception {
        if (!this.preValidate()) {
            this.statusCode = 147;
            return;
        }
        try {
            this.runCommand();
        }
        catch (Exception e) {
            MOut.G(this).println("Cannot connect to " + RedfishHttpUtils.getUrlIP(this.config.getIp()));
            this.statusCode = 145;
        }
        if (this.sessionController != null) {
            this.sessionController.closeSession();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printFailMessage(int result, String responseString) {
        if (result >= 400 && result < 500) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = mapper.readTree(responseString);
                JsonNode error = node.path("error");
                JsonNode extendInfo = error.path("@Message.ExtendedInfo");
                if (!extendInfo.isArray()) return;
                for (JsonNode l : extendInfo) {
                    JsonNode messageArgs = l.path("MessageArgs");
                    JsonNode message = l.findPath("Message");
                    MOut.G(this).println("Error: " + message.asText());
                    if (!messageArgs.isArray()) continue;
                    for (JsonNode m : messageArgs) {
                        MOut.G(this).println("Error  Argument: " + m.asText());
                    }
                }
                return;
            }
            catch (Exception e) {
                MOut.G(this).println("...Failed to execute command, completion code " + result);
                return;
            }
        } else {
            MOut.G(this).println("...Failed to execute command, completion code " + result);
        }
    }

    public boolean checkIfSystemLockdown() {
        SystemLockdownCommand systemLockdownCommand = new SystemLockdownCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, systemLockdownCommand);
        }
        catch (IPMIException ex) {
            return false;
        }
        if (systemLockdownCommand.isSystemLocked()) {
            MOut.G(this).println("System is in lock down mode. This action is forbidden.");
            this.sessionController.closeSession();
            this.statusCode = 156;
            return true;
        }
        this.sessionController.closeSession();
        return false;
    }

    public int statusCodeHandler(HTTP_CALLBACK callback, int httpStatusCode, String responseStr) throws Exception {
        if (httpStatusCode >= 200 && httpStatusCode <= 210) {
            callback.action();
            return 0;
        }
        if (httpStatusCode == 404) {
            MOut.G(this).println("404 not found");
            return 153;
        }
        this.printFailMessage(httpStatusCode, responseStr);
        MOut.G(this).println("Failed");
        return 149;
    }

    public static interface HTTP_CALLBACK {
        public void action() throws Exception;
    }
}

