/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLUtils {
    public String pictureLink;
    public String ipmiFirmwareLink;
    public String biosLink;
    public String[][] idToBoardSpec = new String[][]{{"X7DB8", "80", "80"}, {"X7DA8", "81", "80"}, {"PDSMI-LN4", "82", "80"}, {"X7DBP-X", "83", "80"}, {"X7DBR-8+", "84", "80"}, {"H8DCR-3", "11", "11"}, {"PDSML", "85", "80"}, {"H8DC8", "12", "11"}, {"X7DVL", "86", "80"}, {"PDSBA", "87", "80"}, {"X7DBX", "88", "80"}, {"X7DBP-8", "89", "80"}, {"X7DB8-X", "90", "80"}, {"PDSME+", "91", "80"}, {"X7DBR-3", "92", "80"}, {"PDSLM", "93", "80"}, {"X7DAL-E", "94", "80"}, {"H8QM8-2", "13", "11"}, {"H8DA8-2", "14", "11"}, {"H8DMR-82", "15", "11"}, {"H8DM8-2", "16", "11"}, {"H8SMI-2", "17", "11"}, {"X6QT8", "95", "80"}, {"X7DBN", "96", "80"}, {"X7DBU", "97", "80"}, {"X7DVL-3", "A0", "80"}, {"PDSMU+", "98", "80"}, {"X7DBT", "99", "80"}, {"B7DBE", "B0", "80"}, {"H8SSL-I2", "18", "11"}, {"H8DM3-2", "A0", "11"}, {"X7DBI+", "B1", "80"}, {"H8DMU", "19", "11"}, {"H8DA3-2", "A1", "11"}, {"H8SMU", "20", "11"}, {"X7DVL-L", "B2", "80"}, {"X7DWN", "B3", "80"}, {"AOC-UG-i4", "B4", "80"}, {"X7DW3+", "A2", "80"}, {"PDSBM-LN2", "B5", "80"}, {"X7DGT-ATOKAP", "B6", "80"}, {"AOC-USAS-L8I", "A5", "80"}, {"C2SBA", "B7", "80"}, {"X7SBi", "D1", "80"}, {"X7QC3", "A3", "80"}, {"H8QM3-2", "A2", "11"}, {"X7DCL-3", "A4", "80"}, {"X7DCA-3/i", "D6", "80"}, {"C2SBX", "BA", "80"}, {"X7SB4/E", "D2", "80"}, {"M8QME", "21", "11"}, {"X7SBA", "D3", "80"}, {"X7DWT/-INF", "BC", "80"}, {"C2SBM", "BD", "80"}, {"C2SBC", "BE", "80"}, {"AOC-USAS-H4i", "C0", "80"}, {"AOC-USAS-H8i", "C1", "80"}, {"X7SBL-LN1/LN2", "AA", "80"}, {"C2SBC", "BE", "80"}, {"C2SBi", "BF", "80"}, {"C2SBM-Q", "AB", "80"}, {"X7SBi-LN4", "D4", "80"}, {"BHQME", "AD", "11"}, {"X7SBF", "D5", "80"}, {"AOC-UTG-I2", "AF", "80"}, {"PDSMP-JN001", "AE", "80"}, {"B7DW3", "C2", "80"}, {"X7DWU", "AC", "80"}, {"X7DWP", "D0", "80"}, {"C2SBM-Q", "DA", "80"}, {"X7DCU", "DB", "80"}, {"X7DCA-L", "DC", "80"}, {"X7SBX", "DD", "80"}, {"X7DCA-3/i", "A6", "80"}, {"X7DCT-10G", "DE", "80"}, {"X7DWT-C-SG007", "AA", "80"}, {"X7DWE", "DF", "80"}, {"B7DCE", "BB", "80"}, {"H8DMT", "22", "11"}, {"B7DC3", "A7", "80"}, {"X7SBT", "F0", "80"}, {"X7SBU", "F1", "80"}, {"C2SEA", "B8", "80"}, {"AOC-USASLP-H8iR", "C3", "80"}, {"X7DWT-CD-SG007", "B7", "80"}, {"X8DTN+", "F2", "80", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTN_.cfm?IPMI=O"}, {"X8DA3/i", "A8", "80"}, {"BHDME", "23", "11"}, {"X7SB3", "A9", "80"}, {"X7DCX", "F4", "80"}, {"H8DMT-IBX", "24", "11"}, {"H8QM3-EX", "A3", "11"}, {"Winbond IPMI (AMI)", "B9", "80"}, {"X8DT3/i/-LN4", "00", "01", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT3-F.cfm"}, {"X8SAX", "F3", "80"}, {"X8ST3", "F5", "80", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8ST3-F.cfm"}, {"C2SLM-OC012", "00", "02"}, {"X8DTW-3/i/-LN4", "00", "03"}, {"X8DTL-3/i", "00", "06", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-3F.cfm"}, {"X8DTT-IBX", "00", "07", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTT-IBXF.cfm"}, {"X8DTT-B-SG", "00", "08"}, {"H8DME-2-LS006", "25", "11"}, {"X8DAH+", "01", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DAH_.cfm"}, {"X7SLM-L", "ba", "80"}, {"H8DI3+", "A5", "11"}, {"X8STi-3/-LN4", "00", "09", "http://www.supermicro.com/products/motherboard/Xeon3000/X58/X8STi-3F.cfm"}, {"X8DTH-RC014", "04", "01"}, {"B8DT3", "00", "0A"}, {"X8DTU", "06", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU.cfm"}, {"x8DAL-3/i", "06", "01"}, {"X8DTH-6/i", "04", "00", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTH-6F.cfm"}, {"X7SLA", "06", "02"}, {"C2SEM-Q", "06", "03"}, {"winbond IPMI (Aten)", "06", "04"}, {"X8SIL", "06", "05", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIL.cfm?IPMI=Y"}, {"X8DTG-4", "06", "06"}, {"C2G41", "06", "07"}, {"H8DA6+", "04", "08"}, {"H8QI6/E(+)(-F)", "04", "09"}, {"X8DA6/i-X", "04", "03"}, {"X8DTL-6/L", "04", "10", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTL-6.cfm"}, {"X8DTW-6+/i+", "04", "0B"}, {"X8DTG-DF", "06", "08", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-DF.cfm"}, {"X8DTS", "06", "09"}, {"B8DTL", "01", "01"}, {"X8DT6/E", "04", "04", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DT6-F.cfm?IPMI=N&SAS=Y"}, {"X8SII/X8SI6", "04", "0D", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIE.cfm?IPMI=Y&TYP=SAS"}, {"BHQIE", "A6", "11"}, {"H8SGL", "A7", "11"}, {"X7SPA", "06", "0A"}, {"H8DGU", "A8", "11"}, {"X8SIA", "06", "0B", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIA.cfm?IPMI=Y"}, {"X8DTU+", "06", "0C"}, {"X8SIT", "06", "0E", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIT.cfm?IPMI=Y"}, {"X8DTN+-F", "06", "0F"}, {"X8QB6/E", "06", "10", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6.cfm?SAS=Y"}, {"AOC-STGN-I2S", "06", "11"}, {"B8DTT", "06", "12"}, {"X8DTT-C-SG007", "06", "13"}, {"X8DTU-F-AI034", "06", "14", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU-F.cfm"}, {"H8DGU", "A8", "11"}, {"H8DGG-QF", "A9", "11"}, {"H8DGT", "AA", "11"}, {"X8DTU-LN4F+", "06", "0C", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm"}, {"X8DTU-6TF+", "06", "0D", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTU_.cfm?TYP=SAS&LAN=10"}, {"X8SIU", "06", "1A", "http://www.supermicro.com/products/motherboard/Xeon3000/3400/X8SIU.cfm?IPMI=Y"}, {"X8DTT-HA", "06", "1B"}, {"H8QG6", "AB", "11"}, {"H8DGU-LN4", "AC", "11"}, {"H8DGT-HIBQF-AI034", "AD", "11"}, {"H8QGI-F-AI034", "AE", "11"}, {"H8DGU-LN4F+-AI034", "AF", "11"}, {"B8DT6-AI034", "06", "1C"}, {"B8DTT-AI034", "06", "1E"}, {"H8SCM-F", "BA", "11"}, {"BHDGT", "BB", "11"}, {"C7SIA", "06", "1D"}, {"H8DG6/i(-F)", "BC", "11"}, {"H8DCT-IBQF", "BD", "11"}, {"X9SCL", "06", "1E"}, {"B8DTP", "06", "1F"}, {"B8DTG", "06", "20"}, {"BHQG6/E", "BC", "11"}, {"H8DGT-C", "BD", "11"}, {"H8DCT", "BE", "11"}, {"X8OBN", "06", "21", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8OBN-F.cfm"}, {"C7P67", "06", "22"}, {"C7Q67", "06", "23"}, {"H8DME-EX-LS006", "BF", "11"}, {"X9SCM", "06", "24", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCM-F.cfm"}, {"B9DRi", "06", "25"}, {"X9DR3-LN4F+", "06", "26", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-LN4F_.cfm"}, {"X7SPT-DF-D525", "06", "27"}, {"H8QGL", "CA", "11"}, {"X9DR3/i-F", "06", "28", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DR3-F.cfm"}, {"X9SRT-F", "06", "29"}, {"X9SRA", "06", "2A", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRA.cfm"}, {"X9SRi", "06", "2B", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRi-F.cfm"}, {"X9DAi", "06", "2C", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DAi.cfm"}, {"H8DGT-CM", "CB", "11"}, {"X8SIL-SIOM-FI005", "06", "2D"}, {"X8STE-DS018", "06", "2E"}, {"H8DCL-6F", "CD", "11"}, {"X9DRT-HF", "06", "2F", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HF.cfm"}, {"X9DRW-3TF+", "06", "30", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3TF_.cfm"}, {"X9SCA/X9SCI", "06", "31", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCA-F.cfm"}, {"X8DTG-QF+", "06", "32", "http://www.supermicro.com/products/motherboard/QPI/5500/X8DTG-QF_.cfm"}, {"X9SCV-Q", "06", "33"}, {"X9SCD", "06", "34", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCD-F.cfm"}, {"H8DCT-HLN4F", "CE", "11"}, {"X9DAL-6/i", "06", "35"}, {"X9DRW-3F", "06", "36", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRW-3F.cfm"}, {"X9DBU-3F", "06", "37"}, {"X8QB6-LF", "06", "38", "http://www.supermicro.com/products/motherboard/Xeon7000/7500/X8QB6-LF.cfm"}, {"X9DRD-3/iF", "06", "60", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRD-iF.cfm"}, {"2208", "06", "90"}, {"2308", "06", "91"}, {"X9SRG", "06", "61", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRG-F.cfm"}, {"X9DRG-QF+", "06", "62"}, {"X9SRW", "06", "63", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRW-F.cfm"}, {"X9DRH-7F", "06", "64", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRH-7F.cfm"}, {"X9SCL/SCM-II", "06", "40", "http://www.supermicro.com/products/motherboard/Xeon/C202_C204/X9SCL-F.cfm"}, {"X9SCV-LN4F+", "06", "41"}, {"X9DRG-QF", "06", "65", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-QF.cfm"}, {"X9DRT-D-SG007", "06", "66"}, {"X9DRL-3/iF", "06", "67", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRL-3F.cfm"}, {"X9SRD", "06", "68"}, {"X9DRX+-F", "06", "69", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRX_-F.cfm"}, {"B9DRT", "06", "6A"}, {"C7Q67-H", "06", "42"}, {"X9SRL-F", "06", "6b"}, {"B9DRG", "06", "6C"}, {"X9DR6+-F-AI034", "06", "6d"}, {"X9DR6-LN4F+-AI034", "06", "6e"}, {"X9DRW-LN4F+-AI034", "06", "6f"}, {"X9DRT-HF-AI034", "07", "00"}, {"X9DRT-HIBQF-AI034", "07", "01", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRT-HIBQF.cfm"}, {"X9DBL-6F", "07", "03"}, {"X9DR7/E-TF+", "07", "04"}, {"X9DR7/E-LN4F", "07", "05"}, {"X9DRT-HF+", "07", "06"}, {"X9SPU", "07", "43"}, {"X9QR7-TF+", "07", "07"}, {"X9DRT-F", "07", "08"}, {"X9DA7/E", "07", "09"}, {"X9DRF-F", "07", "0A"}, {"X9SRL-CF", "07", "0B"}, {"X9SRD-CD", "07", "0C"}, {"x9SAE", "06", "44"}, {"B9DR7", "07", "0D"}, {"X9DAX-7", "07", "0E"}, {"X9QR7-TF", "07", "0F"}, {"X9SRE", "07", "10", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9SRE-F.cfm"}, {"X9DRG-HTF+", "07", "11", "http://www.supermicro.com/products/motherboard/Xeon/C600/X9DRG-HTF.cfm"}};

    public static String extractPicLink(String url) throws IOException {
        String pictureLink = null;
        Document doc = Jsoup.connect(url).get();
        Elements media = doc.select("[src]");
        for (Element src : media) {
            String picLink = src.attr("abs:src");
            if (picLink.indexOf("products") == -1 || picLink.indexOf(".jpg") == -1) continue;
            pictureLink = picLink;
            break;
        }
        return pictureLink;
    }

    public static List<String> extractLinks(String url) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Document doc = Jsoup.connect(url).get();
        Elements links = doc.select("a[href]");
        Elements media = doc.select("[src]");
        Elements imports = doc.select("link[href]");
        Elements forms = doc.select("form[name=biosForm]");
        for (Element link : links) {
            result.add(link.attr("abs:href"));
        }
        for (Element src : media) {
            String picLink = src.attr("abs:src");
            result.add(src.attr("abs:src"));
        }
        for (Element link : imports) {
            result.add(link.attr("abs:href"));
        }
        String biosLink = forms.first().attr("action");
        Elements productIDEle = forms.first().getElementsContainingText("ProductID");
        String productID = productIDEle.first().attr("value");
        System.out.println("biosLink =" + biosLink);
        System.out.println("productID =" + productID);
        for (Element form : forms) {
            Elements e = form.getElementsByAttribute("value");
            System.out.println("1:" + form.toString());
            System.out.println("2:" + form.text());
            System.out.println("3:" + e.first().attr("value"));
            System.out.println("4:" + form.attr("value"));
            result.add(form.attr("abs:action"));
        }
        return result;
    }

    public static final void main(String[] args) throws Exception {
        String[] mbLink = new String[]{"http://www.supermicro.com/products/motherboard/QPI/5500/X8DAL-3.cfm"};
        for (int i = 0; i < mbLink.length; ++i) {
            List<String> links = HTMLUtils.extractLinks(mbLink[i]);
            for (String link : links) {
                System.out.println(link);
            }
        }
    }
}

