/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.text.nm.suspendperiod.AbstractSuspenPeriodCommand;
import com.supermicro.ipmi.text.nm.suspendperiod.SuspendPeriodRaw;
import java.text.ParseException;

public class AddPeriod
extends AbstractSuspenPeriodCommand {
    private int domainId;
    private int policyId;
    private int startTimeInMinute;
    private int stopTimeInMinute;
    private int[] days;

    public AddPeriod(String[] parameters) {
        super(parameters);
        try {
            this.validate(parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid value: " + e.getMessage());
        }
    }

    protected void validate(String[] parameters) throws ParseException {
        if (parameters == null || parameters.length != 5) {
            this.help();
            throw new IllegalArgumentException();
        }
        this.domainId = Integer.parseInt(parameters[0]);
        this.policyId = Integer.parseInt(parameters[1]);
        if (this.domainId < 0 || this.policyId < 0 || this.policyId > 255) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.startTimeInMinute = this.getTimeInMinute(parameters[2]);
        this.stopTimeInMinute = this.getTimeInMinute(parameters[3]);
        this.days = this.getDays(parameters[4]);
    }

    @Override
    public byte[] getNewPeriod(byte[] currentPeriod) {
        SuspendPeriodRaw period = new SuspendPeriodRaw(currentPeriod);
        return period.add((byte)(this.startTimeInMinute / 6), (byte)(this.stopTimeInMinute / 6), this.getRecurrencePattern(this.days));
    }

    @Override
    public int getDomainId() {
        return this.domainId;
    }

    @Override
    public int getPolicyId() {
        return this.policyId;
    }

    @Override
    public void help() {
        System.out.println("add <domainId> <policyId> <startTime> <stopTime> <days>");
        System.out.println("domainId :");
        System.out.println("\t0 \u00a1V Entire platform");
        System.out.println("\t1 \u00a1V CPU subsystem");
        System.out.println("\t2 \u00a1V Memory subsystem");
        System.out.println("\t3 \u00a1V HW Protection (NM3.0)");
        System.out.println("\t4 \u00a1V High Power I/O subsystem");
        System.out.println("policyId : 0~255");
        System.out.println("startTime: Policy suspend start time (HHmm) [0000~2359]");
        System.out.println("stopTime : Policy suspend stop time (HHmm) [0006~2400]");
        System.out.println("\t* If there is a need to specify an end-time that is beyond midnight, use two suspend periods.");
        System.out.println("days     : Suspend period recurrence");
        System.out.println("\t1 \u00a1V Monday, 2 \u00a1V Tuesday, 3 \u00a1V Wednesday, 4 \u00a1V Thursday, 5 \u00a1V Friday, 6 - Saturday, 7 - Sunday");
        System.out.println("\tex: every Monday, Wednesday, Sunday => 137");
    }
}

