/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.regex.Pattern;

public class WSISOMount
extends SuperBladeCommand {
    byte deviceID;
    String hostIP;
    String path;
    String username;
    String password;

    @Override
    public boolean preValidate() {
        this.deviceID = 0;
        this.hostIP = "";
        this.path = "";
        this.username = "";
        this.password = "";
        String usage = "Usage: wsiso mount <IP> <path> [username] [password]\nIP: IP or domain name of share host\npath: path to iso file\nusername: username of share host (optional)\npassword: password of share host (optional)\n \nEx 1: mount linux.iso\n wsiso mount 192.168.1.100 /iso/linux.iso\nEx 2: mount linux.iso with username and password\n wsiso mount 192.168.1.100 /iso/linux.iso admin admin\n\n* Use one ISO file at a time. Make sure umount existing ISO before mount new ISO file \n* This command is available for X9 and X10 platform with SFT-OOB-LIC node product key \n";
        if (this.parameters == null || this.parameters.length < 2 || this.parameters.length > 4) {
            MOut.G(this).println(usage);
            return false;
        }
        this.hostIP = this.parameters[0];
        this.path = this.parameters[1];
        if (this.parameters.length > 2) {
            this.username = this.parameters[2];
        }
        if (this.parameters.length > 3) {
            this.password = this.parameters[3];
        }
        if (!this.validateHost(this.hostIP)) {
            MOut.G(this).println("The special characters are not allowed ! ,; &\"<>\\=$#*!@~`%^");
            return false;
        }
        if (!this.validateImagePath(this.path)) {
            MOut.G(this).println("The path does not meet the expected pattern. (It is not an iso file or contains \\:*?\"<>|)");
            return false;
        }
        if (!"".equals(this.username) && !this.validateAccount(this.username)) {
            MOut.G(this).println("Username only accept a-z, A-Z, 0-9 and ^");
            return false;
        }
        if (!"".equals(this.password) && !this.validateAccount(this.password)) {
            MOut.G(this).println("Password only accept a-z, A-Z, 0-9 and ^");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            ipmiOEMWebSettingCommand.setVMParameter((byte)0, this.hostIP);
        }
        catch (IPMIException e) {
            if (e.getIPMIMessage().completionCode == -43) {
                MOut.G(this).println("Please activate SFT-OOB-LIC node product key for this command");
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println("This device doesn't support WSISO commands");
            this.statusCode = 153;
            return;
        }
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        this.deviceID = IPMIMessagingCommand.isATENGUID(guid) ? (byte)2 : (byte)0;
        try {
            ipmiOEMWebSettingCommand.setVMParameter((byte)1, this.path);
        }
        catch (IPMIException e) {
            this.statusCode = 149;
            MOut.G(this).println("Set path failed");
            return;
        }
        if (this.username != null && this.username.length() > 0) {
            try {
                ipmiOEMWebSettingCommand.setVMParameter((byte)2, this.username);
            }
            catch (IPMIException e) {
                this.statusCode = 149;
                MOut.G(this).println("Set username failed");
                return;
            }
        }
        if (this.password != null && this.password.length() > 0) {
            try {
                ipmiOEMWebSettingCommand.setVMParameter((byte)3, this.password);
            }
            catch (IPMIException e) {
                this.statusCode = 149;
                MOut.G(this).println("Set password failed");
                return;
            }
        }
        try {
            ipmiOEMWebSettingCommand.mountISO(this.deviceID);
            MOut.G(this).println("mounting ISO file ...");
            boolean result = false;
            String resultString = null;
            for (int i = 0; i < 12; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                byte[] vmDevices = ipmiOEMWebSettingCommand.getVMDeviceStatus();
                switch (this.deviceID) {
                    case 0: {
                        if (vmDevices[0] != 4 && vmDevices[1] != 4 && vmDevices[2] != 4) break;
                        result = true;
                        break;
                    }
                    case 2: {
                        if (vmDevices[0] != 4 && vmDevices[1] != 4) break;
                        result = true;
                    }
                }
                if (result) break;
            }
            if (!result) {
                try {
                    byte smbResult = ipmiOEMWebSettingCommand.getSMBStatus();
                    switch (smbResult) {
                        case 0: {
                            resultString = "umounted";
                            break;
                        }
                        case 1: {
                            resultString = "in progress";
                            this.statusCode = 1;
                            break;
                        }
                        case 2: {
                            resultString = "success";
                            this.statusCode = 2;
                            break;
                        }
                        case 3: {
                            resultString = "connection failure";
                            this.statusCode = 3;
                            break;
                        }
                        case 4: {
                            resultString = "logon failure";
                            this.statusCode = 4;
                            break;
                        }
                        case 5: {
                            resultString = "iso not exist";
                            this.statusCode = 5;
                            break;
                        }
                        case 6: {
                            resultString = "vm internal error";
                            this.statusCode = 6;
                        }
                    }
                }
                catch (IPMIException iPMIException) {
                    // empty catch block
                }
            }
            if (result) {
                this.statusCode = 0;
                MOut.G(this).println("Mount ISO successfully");
            } else if (resultString != null) {
                MOut.G(this).println(resultString);
            } else {
                MOut.G(this).println("Mount ISO failed. Please check parameters");
            }
        }
        catch (IPMIException e) {
            this.statusCode = e.getIPMIMessage().completionCode;
            if (e.getIPMIMessage().completionCode == -52) {
                MOut.G(this).println("An ISO file already mounted. Please umount ISO first");
            } else {
                MOut.G(this).println("mount ISO failed");
            }
            return;
        }
    }

    public boolean validateHost(String host) {
        String urlREGEX = "^http(s?)\\:(\\/\\/|)[0-9a-zA-Z\\-\\.\\:]*";
        Pattern urlPattern = Pattern.compile(urlREGEX);
        Pattern hostPattern = Pattern.compile("[a-zA-Z0-9\\-\\.\\:]+");
        if (host.startsWith("http")) {
            return urlPattern.matcher(host).matches();
        }
        return hostPattern.matcher(host).matches();
    }

    public boolean validateImagePath(String path) {
        Pattern rule1 = Pattern.compile("^(\\/|\\\\)[a-zA-Z0-9@\\^\\.\\-\\_\\/\\\\]*\\.(i|I)(s|S)(o|O)");
        Pattern twoMoreSlash = Pattern.compile("[\\/\\\\]{2}");
        if (rule1.matcher(path).matches()) {
            return !twoMoreSlash.matcher(path).find();
        }
        return false;
    }

    public boolean validateAccount(String str) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9^]+");
        return pattern.matcher(str).matches();
    }
}

