/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MDRRegionReadCommand;
import com.supermicro.ipmi.MDRRegionStatusCommand;
import com.supermicro.ipmi.smbios.BaseboardInfo;
import com.supermicro.ipmi.smbios.BiosInfo;
import com.supermicro.ipmi.smbios.EntryPoint;
import com.supermicro.ipmi.smbios.MemoryDevice;
import com.supermicro.ipmi.smbios.NicInfo;
import com.supermicro.ipmi.smbios.PcieInfo;
import com.supermicro.ipmi.smbios.ProcessorInfo;
import com.supermicro.ipmi.smbios.SmbiosEnum;
import com.supermicro.ipmi.smbios.SpeedSelectConfig;
import com.supermicro.ipmi.smbios.StorageDevice;
import com.supermicro.ipmi.smbios.SystemInfo;
import com.supermicro.ipmi.smbios.SystemSlots;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SmbiosSummaryCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.DecimalFormat;
import java.util.Arrays;

public class SmbiosCommand
extends SuperBladeCommand {
    SmbiosSummaryCommand mdrSummary = new SmbiosSummaryCommand();
    String command;
    boolean debug;
    boolean isNotUsed = true;

    public SmbiosCommand(String command) {
        this.command = command;
    }

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if ("--debug".equalsIgnoreCase(this.parameters[0])) {
                this.debug = true;
            }
        } else {
            this.debug = false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        MDRRegionStatusCommand mdrStatus = new MDRRegionStatusCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte completionCode = (mdrStatus = mdrStatus.getMDRRegionStatus()).getCompletionCode();
        if (completionCode != 0) {
            MOut.G(this).println("Not supported (0x" + ByteUtility.byteToHex(completionCode) + ")");
            this.statusCode = 0;
            return;
        }
        byte valid = mdrStatus.getValid();
        if (valid != 1) {
            MOut.G(this).println("Invalid data (0x" + ByteUtility.byteToHex(valid) + ")");
            this.statusCode = 0;
            return;
        }
        byte[] dataByte = this.getData(mdrStatus);
        EntryPoint entry = new EntryPoint(dataByte);
        dataByte = entry.remainBytes();
        while (dataByte.length > 6) {
            dataByte = this.getType(dataByte);
        }
        if (this.isNotUsed && (this.command.equals(SmbiosEnum.NIC_INFO.toString()) || this.command.equals(SmbiosEnum.STORAGE_DEVICE.toString()) || this.command.equals(SmbiosEnum.SPEED_SELECT_CONFIG.toString()))) {
            MOut.G().print("None \n");
        }
        if (this.command.equalsIgnoreCase("summary")) {
            this.mdrSummary.printSummary();
            this.mdrSummary.reset();
        }
        this.statusCode = 0;
    }

    byte[] MDRRegionRead(int dataLength, byte[] offset) {
        MDRRegionReadCommand mdrRead = new MDRRegionReadCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        mdrRead = mdrRead.getMDRRegionRead(dataLength, offset);
        return mdrRead.getDataByte();
    }

    public byte[] getData(MDRRegionStatusCommand mdrStatus) {
        byte[] fullData = new byte[]{};
        byte[] offset = new byte[2];
        int divide = mdrStatus.getUsedRegionSize() / 255;
        int remainder = Integer.parseInt(Integer.toHexString(mdrStatus.getUsedRegionSize() % 255), 16) & 0xFF;
        int count = 0;
        for (int i = 0; i < mdrStatus.getUsedRegionSize(); i += 255) {
            byte[] destination;
            byte[] postByte;
            if (count == divide) {
                ByteUtility.intTo2Bytes(offset, 0, i);
                postByte = this.MDRRegionRead(remainder, offset);
                destination = new byte[fullData.length + remainder];
                System.arraycopy(fullData, 0, destination, 0, fullData.length);
                System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
                fullData = destination;
                break;
            }
            ByteUtility.intTo2Bytes(offset, 0, i);
            postByte = this.MDRRegionRead(-1, offset);
            destination = new byte[fullData.length + 255];
            System.arraycopy(fullData, 0, destination, 0, fullData.length);
            System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
            fullData = destination;
            ++count;
        }
        return fullData;
    }

    byte[] getType(byte[] dataByte) {
        int type = dataByte[0] & 0xFF;
        int length = dataByte[1] & 0xFF;
        if (type == SmbiosEnum.BIOS_INFO.getType()) {
            BiosInfo biosInfo = new BiosInfo(dataByte);
            biosInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.BIOS_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                biosInfo.setDebug(this.debug);
                MOut.G().print(biosInfo.toFormatedHeader());
                MOut.G().print(biosInfo.toFormatedString());
            }
            if (this.command.equalsIgnoreCase("summary")) {
                this.mdrSummary.setBios(biosInfo.getBIOSVersion());
                this.mdrSummary.setBios(biosInfo.getBiosReleaseDate());
            }
            dataByte = biosInfo.remainBytes();
        } else if (type == SmbiosEnum.SYSTEM_INFO.getType()) {
            SystemInfo systemInfo = new SystemInfo(dataByte);
            systemInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.SYSTEM_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                systemInfo.setDebug(this.debug);
                MOut.G().print(systemInfo.toFormatedHeader());
                MOut.G().print(systemInfo.toFormatedString());
            }
            dataByte = systemInfo.remainBytes();
        } else if (type == SmbiosEnum.BASEBOARD_INFO.getType()) {
            BaseboardInfo baseboardInfo = new BaseboardInfo(dataByte);
            baseboardInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.BASEBOARD_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                baseboardInfo.setDebug(this.debug);
                MOut.G().print(baseboardInfo.toFormatedHeader());
                MOut.G().print(baseboardInfo.toFormatedString());
            }
            if (this.command.equalsIgnoreCase("summary")) {
                this.mdrSummary.setBaseboard(new String[]{baseboardInfo.getBaseboardManufacturer(), baseboardInfo.getBaseboardProduct(), baseboardInfo.getBaseboardVersion()});
            }
            dataByte = baseboardInfo.remainBytes();
        } else if (type == SmbiosEnum.PROCESSOR_INFO.getType()) {
            ProcessorInfo processorInfo = new ProcessorInfo(dataByte);
            processorInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.PROCESSOR_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                processorInfo.setDebug(this.debug);
                MOut.G().print(processorInfo.toFormatedHeader());
                MOut.G().print(processorInfo.toFormatedString());
            }
            if (this.command.equalsIgnoreCase("summary")) {
                this.mdrSummary.addTotalProcessor();
                if (processorInfo.getProcessorCoreCount() != 0) {
                    this.mdrSummary.addAvailableProcessor();
                    this.mdrSummary.setProcessor(new String[]{processorInfo.getProcessorSocketDesign() + ": ", processorInfo.getProcessorVersion()});
                    DecimalFormat df = new DecimalFormat("0.00");
                    this.mdrSummary.setProcessor(new String[]{"", "Max Speed: " + df.format(processorInfo.getProcessorMaxSpeed()) + " GHz / Core(" + processorInfo.getProcessorCoreCount() + ")"});
                }
            }
            dataByte = processorInfo.remainBytes();
        } else if (type == SmbiosEnum.SYSTEM_SLOTS.getType()) {
            SystemSlots sysSlot = new SystemSlots(dataByte);
            sysSlot.stringFieldParser();
            if (this.command.equals(SmbiosEnum.SYSTEM_SLOTS.toString()) || this.command.equalsIgnoreCase("all")) {
                sysSlot.setDebug(this.debug);
                MOut.G().print(sysSlot.toFormatedHeader());
                MOut.G().print(sysSlot.toFormatedString());
            }
            dataByte = sysSlot.remainBytes();
        } else if (type == SmbiosEnum.MEMORY_DEVICE.getType()) {
            MemoryDevice memoryDevice = new MemoryDevice(dataByte);
            memoryDevice.stringFieldParser();
            if (this.command.equals(SmbiosEnum.MEMORY_DEVICE.toString()) || this.command.equalsIgnoreCase("all")) {
                memoryDevice.setDebug(this.debug);
                MOut.G().print(memoryDevice.toFormatedHeader());
                MOut.G().print(memoryDevice.toFormatedString());
            }
            if (this.command.equalsIgnoreCase("summary")) {
                this.mdrSummary.addTotalMemory();
                if (memoryDevice.getMemorySize() != 0) {
                    this.mdrSummary.addAvailableMemory();
                    this.mdrSummary.setMemoryDevice(new String[]{memoryDevice.getMemoryDeviceLocator(), memoryDevice.getMemorySize() + " MB " + memoryDevice.getMemorySpeed()});
                }
            }
            dataByte = memoryDevice.remainBytes();
        } else if (type == SmbiosEnum.NIC_INFO.getType()) {
            NicInfo nicInfo = new NicInfo(dataByte);
            nicInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.NIC_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                this.isNotUsed = false;
                nicInfo.setDebug(this.debug);
                MOut.G().print(nicInfo.toFormatedHeader());
                MOut.G().print(nicInfo.toFormatedString());
            }
            dataByte = nicInfo.remainBytes();
        } else if (type == SmbiosEnum.PCIE_INFO.getType()) {
            PcieInfo pcieInfo = new PcieInfo(dataByte);
            pcieInfo.stringFieldParser();
            if (this.command.equals(SmbiosEnum.PCIE_INFO.toString()) || this.command.equalsIgnoreCase("all")) {
                pcieInfo.setDebug(this.debug);
                MOut.G().print(pcieInfo.toFormatedHeader());
                MOut.G().print(pcieInfo.toFormatedString());
            }
            dataByte = pcieInfo.remainBytes();
        } else if (type == SmbiosEnum.STORAGE_DEVICE.getType()) {
            StorageDevice storageDevice = new StorageDevice(dataByte);
            storageDevice.stringFieldParser();
            if (this.command.equals(SmbiosEnum.STORAGE_DEVICE.toString()) || this.command.equalsIgnoreCase("all")) {
                this.isNotUsed = false;
                storageDevice.setDebug(this.debug);
                MOut.G().print(storageDevice.toFormatedHeader());
                MOut.G().print(storageDevice.toFormatedString());
            }
            if (this.command.equalsIgnoreCase("summary")) {
                if (storageDevice.getStorageDeviceRPM() != 0) {
                    this.mdrSummary.setStorage(new String[]{storageDevice.getStorageConnectorType() + " / " + storageDevice.getStorageDeviceProtocol(), storageDevice.getStorageDeviceCapacity() + " GB / " + storageDevice.getStorageDeviceRPM() + " RPM"});
                } else {
                    this.mdrSummary.setStorage(new String[]{storageDevice.getStorageConnectorType() + " / " + storageDevice.getStorageDeviceProtocol(), storageDevice.getStorageDeviceCapacity() + " GB"});
                }
            }
            dataByte = storageDevice.remainBytes();
        } else if (type == SmbiosEnum.SPEED_SELECT_CONFIG.getType()) {
            SpeedSelectConfig iss = new SpeedSelectConfig(dataByte);
            iss.stringFieldParser();
            if (this.command.equals(SmbiosEnum.SPEED_SELECT_CONFIG.toString()) || this.command.equalsIgnoreCase("all")) {
                this.isNotUsed = false;
                iss.setDebug(this.debug);
                MOut.G().print(iss.toFormatedHeader());
                MOut.G().print(iss.toFormatedString());
            }
            dataByte = iss.remainBytes();
        } else {
            try {
                dataByte = Arrays.copyOfRange(dataByte, length, dataByte.length);
            }
            catch (Exception ex) {
                if (this.debug) {
                    ex.printStackTrace();
                }
                return new byte[]{0};
            }
            int zeroCount = 0;
            length = 0;
            for (byte singleByte : dataByte) {
                zeroCount = singleByte == 0 ? ++zeroCount : 0;
                ++length;
                if (zeroCount == 2) break;
            }
            dataByte = Arrays.copyOfRange(dataByte, length, dataByte.length);
        }
        return dataByte;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.136.160.82");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        MDRRegionStatusCommand mdrStatus = new MDRRegionStatusCommand(rmcp);
        mdrStatus = mdrStatus.getMDRRegionStatus();
        MOut.G().print(mdrStatus.toFormatedHeader());
        MOut.G().print(mdrStatus.toFormatedString());
        MOut.G().println();
        byte[] fullData = new byte[]{};
        byte[] offset = new byte[2];
        int divide = mdrStatus.getUsedRegionSize() / 255;
        int remainder = Integer.parseInt(Integer.toHexString(mdrStatus.getUsedRegionSize() % 255), 16) & 0xFF;
        int count = 0;
        for (int i = 0; i < mdrStatus.getUsedRegionSize(); i += 255) {
            byte[] destination;
            byte[] postByte;
            MDRRegionReadCommand mdrRead;
            if (count == divide) {
                ByteUtility.intTo2Bytes(offset, 0, i);
                mdrRead = new MDRRegionReadCommand(rmcp);
                mdrRead = mdrRead.getMDRRegionRead(remainder, offset);
                postByte = mdrRead.getDataByte();
                destination = new byte[fullData.length + remainder];
                System.arraycopy(fullData, 0, destination, 0, fullData.length);
                System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
                fullData = destination;
                break;
            }
            ByteUtility.intTo2Bytes(offset, 0, i);
            mdrRead = new MDRRegionReadCommand(rmcp);
            mdrRead = mdrRead.getMDRRegionRead(remainder, offset);
            postByte = mdrRead.getDataByte();
            destination = new byte[fullData.length + 255];
            System.arraycopy(fullData, 0, destination, 0, fullData.length);
            System.arraycopy(postByte, 0, destination, fullData.length, postByte.length);
            fullData = destination;
            ++count;
        }
        EntryPoint entry = new EntryPoint(fullData);
        MOut.G().print(entry.toFormatedHeader());
        MOut.G().print(entry.toFormatedString());
        fullData = entry.remainBytes();
        MOut.G().println("fullData.length: " + fullData.length);
        while (fullData.length > 6) {
            fullData = SmbiosCommand.getTypes(fullData);
        }
    }

    static byte[] getTypes(byte[] dataByte) {
        int type = dataByte[0] & 0xFF;
        int length = dataByte[1] & 0xFF;
        if (type == SmbiosEnum.BASEBOARD_INFO.getType()) {
            BaseboardInfo baseInfo = new BaseboardInfo(dataByte);
            baseInfo.stringFieldParser();
            MOut.G().print(baseInfo.toFormatedHeader());
            MOut.G().print(baseInfo.toFormatedString());
            dataByte = baseInfo.remainBytes();
        } else if (type == SmbiosEnum.STORAGE_DEVICE.getType()) {
            StorageDevice storageDevice = new StorageDevice(dataByte);
            storageDevice.stringFieldParser();
            MOut.G().print(storageDevice.toFormatedHeader());
            MOut.G().print(storageDevice.toFormatedString());
            dataByte = storageDevice.remainBytes();
        } else {
            try {
                dataByte = Arrays.copyOfRange(dataByte, length, dataByte.length);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return new byte[]{0};
            }
            int zeroCount = 0;
            length = 0;
            for (byte singleByte : dataByte) {
                zeroCount = singleByte == 0 ? ++zeroCount : 0;
                ++length;
                if (zeroCount == 2) break;
            }
            dataByte = Arrays.copyOfRange(dataByte, length, dataByte.length);
        }
        return dataByte;
    }
}

