/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.vstorage.VirtualStorage;

public class RemoteScreenCaptureIKVMCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        boolean isForceStunnelVer11 = false;
        if (this.checkIfSystemLockdown()) {
            return;
        }
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        String jarDir = RemoteScreenCaptureIKVMCommand.getJarPath(this.getClass()) + File.separator;
        File f = new File(jarDir + "sc.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find sc.jar");
            this.statusCode = 149;
            return;
        }
        String params = "";
        if (this.getParameters() != null) {
            for (int i = 0; i < this.getParameters().length; ++i) {
                if ("ssl".equalsIgnoreCase(this.getParameters()[i])) {
                    isForceStunnelVer11 = true;
                }
                if (this.getParameters()[i].endsWith("png") || this.getParameters()[i].endsWith("jpg") || this.getParameters()[i].endsWith("PNG") || this.getParameters()[i].endsWith("JPG")) {
                    params = "--filename-" + this.getParameters()[i];
                    continue;
                }
                String fileName = this.getParameters()[i];
                if (this.validateFileExtensionName(fileName)) {
                    fileName = fileName.substring(0, fileName.length() - 3) + fileName.substring(fileName.length() - 3).toLowerCase();
                    params = "--filename-" + fileName;
                }
                params = params + " " + fileName;
            }
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean isStunnelSupport = ipmiOEMPortServiceCommand.checkStunnelSupport();
        String ip = this.config.getIp();
        if (isStunnelSupport) {
            int stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
            if (isForceStunnelVer11) {
                stunnelVer = 11;
            } else if (stunnelVer == 13) {
                stunnelVer = 11;
            }
            MOut.G(this).println("This device support stunnel.");
            StunnelParameters parameters = null;
            try {
                parameters = StunnelParameterBuilder.runByFunction(stunnelVer, ip, this.config.getUserName(), this.config.getPassword(), ipmiOEMPortServiceCommand, null, "sc");
                if (parameters == null) {
                    this.statusCode = 149;
                    return;
                }
            }
            catch (Exception e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 149;
                return;
            }
            try {
                if (stunnelVer == 5) {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    InfoRepository infoRepository = InfoRepository.createInfoRepository(parameters.getStunnelIP(), this.config.getUserName(), this.config.getPassword(), parameters.getSturnnlPortList().get(0), 623);
                    if (!VirtualStorage.loadLibraryAndValidateUser(stunnelVer, infoRepository)) {
                        StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                        stunnelVer = 11;
                        parameters = StunnelParameterBuilder.runByFunction(stunnelVer, ip, this.config.getUserName(), this.config.getPassword(), ipmiOEMPortServiceCommand, null, "sc");
                        StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    }
                } else {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                }
                String userName = this.config.getUserName();
                String password = this.config.getPassword();
                if (parameters.getUser() != null) {
                    userName = parameters.getUser().getUsername();
                    password = parameters.getUser().getPassword();
                }
                this.startRemoteScreenCapture(jarDir, parameters.getStunnelIP(), parameters.getSturnnlPort(), userName, password, params, parameters.getStunnelFolder(), parameters.getBMCIP(), stunnelVer);
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail");
            }
        } else {
            int port = 5900;
            try {
                port = ipmiOEMPortServiceCommand.getPort((byte)2);
            }
            catch (IPMIException e) {
                port = 5900;
            }
            this.startRemoteScreenCapture(jarDir, ip, this.config.getUserName(), this.config.getPassword(), params, port);
        }
    }

    public void startRemoteScreenCapture(String jarDir, String ip, String id, String pw, String params) {
        this.startRemoteScreenCapture(jarDir, ip, id, pw, params, 5900);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRemoteScreenCapture(String jarDir, String ip, String port, String id, String pw, String params, String stunnleFolder, String BMCIP, int stunnelVer) {
        String line;
        Process process;
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "./jre/bin/java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer) : "java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer;
        BufferedReader bufferedReader = null;
        BufferedReader errorbufferedReader = null;
        try {
            LinkedList<String> exec = new LinkedList<String>(Arrays.asList(execString.split(" ")));
            for (int i = 0; i < exec.size(); ++i) {
                if (!"".equals(((String)exec.get(i)).trim())) continue;
                exec.remove(i);
            }
            ProcessBuilder builder = new ProcessBuilder(exec);
            builder.redirectErrorStream(true);
            process = builder.start();
            InputStream inputStream = process.getInputStream();
            InputStream errorInputStream = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            errorbufferedReader = new BufferedReader(new InputStreamReader(errorInputStream));
            process.waitFor(60L, TimeUnit.SECONDS);
            try {
                this.waitForTimeout(bufferedReader, process);
            }
            catch (Exception e) {
                MOut.G(this).println(e.getMessage());
                process.destroy();
                this.statusCode = 149;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (errorbufferedReader == null) return;
                    errorbufferedReader.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (line.indexOf("Buf") != -1 || line.indexOf("singal") != -1) continue;
                if (line.indexOf("XOpenDisplay") != -1) {
                    MOut.G(this).println("If you are running rsc command via ssh, please have following setting");
                    MOut.G(this).println("export DISPLAY=:0.0");
                    this.statusCode = 149;
                    return;
                }
                if (line.indexOf("A fatal error has been detected") > -1 || line.indexOf("Failed to write core dump") > -1) {
                    MOut.G(this).println("iKVM No Signal");
                    break;
                }
                if (line.indexOf("#") > -1) continue;
                if (line.indexOf("runImage") != -1 || line.indexOf("Error") != -1) {
                    this.statusCode = 149;
                    MOut.G(this).println("Get remote screenshot fail");
                    return;
                }
                MOut.G(this).println(line);
            }
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
        while ((line = errorbufferedReader.readLine()) != null) {
            if (line.indexOf("XOpenDisplay") != -1) {
                MOut.G(this).println("If you are running rsc command via ssh, please have following setting");
                MOut.G(this).println("export DISPLAY=:0.0");
                this.statusCode = 149;
                return;
            }
            if (line.indexOf("Administrator") > -1) {
                MOut.G(this).println(line);
                this.statusCode = 149;
                return;
            }
            if (line.indexOf("runImage") != -1 || line.indexOf("Error") != -1) {
                this.statusCode = 149;
                MOut.G(this).println("Get remote screenshot fail.");
                return;
            }
            MOut.G(this).println(line);
        }
        this.statusCode = process.exitValue();
        return;
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (errorbufferedReader != null) {
                    errorbufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void waitForTimeout(BufferedReader input, Process process) throws InterruptedException, Exception {
        int timeout = 60;
        while (timeout > 0 && !input.ready()) {
            Thread.sleep(1000L);
            if (--timeout != 0 || input.ready()) continue;
            throw new Exception("Timeout ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRemoteScreenCapture(String jarDir, String ip, String id, String pw, String params, int port) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port : "./jre/bin/java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port) : "java -Djava.library.path=. -jar sc.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port;
        InputStream stdin = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        InputStream stderr = null;
        InputStreamReader isrerr = null;
        BufferedReader brerr = null;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            stdin = p.getInputStream();
            isr = new InputStreamReader(stdin);
            br = new BufferedReader(isr);
            stderr = p.getErrorStream();
            isrerr = new InputStreamReader(stderr);
            brerr = new BufferedReader(isrerr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("Buf") != -1 || line.indexOf("singal") != -1) continue;
                MOut.G(this).println(line);
            }
            while ((line = brerr.readLine()) != null) {
                if (line.indexOf("XOpenDisplay") == -1) continue;
                MOut.G(this).println("If you are running rsc command via ssh, please have following setting");
                MOut.G(this).println("export DISPLAY=:0.0");
                this.statusCode = 149;
                return;
            }
            p.waitFor();
            this.statusCode = p.exitValue();
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (stderr != null) {
                    stderr.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = true;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid)) {
            result = false;
        }
        return result;
    }

    public static String getT(String ip) {
        byte[] result = null;
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        String dateShortString = f.format(date);
        byte[] key = dateShortString.getBytes();
        byte[] plainText = ip.getBytes();
        try {
            Mac hmacMD5 = Mac.getInstance("HmacMD5");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacMD5");
            hmacMD5.init(sks);
            result = hmacMD5.doFinal(plainText);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return ByteUtility.bytesToHexNoSpace(result);
    }

    public boolean validateFileExtensionName(String filename) {
        Pattern rule1 = Pattern.compile("\\.(p|P)(n|N)(g|G)\\z");
        Pattern rule2 = Pattern.compile("\\.(j|J)(p|P)(g|G)\\z");
        if (!rule1.matcher(filename).find()) {
            return rule2.matcher(filename).find();
        }
        return true;
    }
}

