/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMAlertCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters != null && this.parameters.length == 1) {
            byte seq = 0;
            String para1 = this.parameters[0];
            try {
                seq = (byte)Integer.parseInt(para1);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            IPMIDCMOEMCommand.NodeManagerAlertDestination alert = ipmiDCMOEMCommand.getNodeManagerAlertDestination();
            alert.channelNumber = 1;
            alert.destinationSelector = seq;
            alert.alertStringSelector = 0;
            try {
                ipmiDCMOEMCommand.setNodeManagerAlertDestination(alert);
            }
            catch (Exception ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 148;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
            return;
        }
        IPMIDCMOEMCommand.NodeManagerAlertDestination alert = null;
        try {
            alert = ipmiDCMOEMCommand.getNodeManagerAlertDestination();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (alert == null) {
            MOut.G(this).println("Call getNodeManagerStatistics failed");
        }
        if ((byte)(alert.channelNumber & 0x80) == -128) {
            MOut.G(this).println("Destination receiver not registered");
        } else {
            MOut.G(this).println("Destination selector = " + alert.destinationSelector);
        }
        this.statusCode = 0;
    }
}

