/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.GetTurboSynchronizationRatio;
import com.supermicro.ipmi.nm.SetTurboSynchronizationRatio;
import com.supermicro.ipmi.nm.TurboRatio;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM40AbstractCommand;

public class NM40SetTurboSyncRatioCommand
extends NM40AbstractCommand {
    private static final int core = 255;
    private int socket;
    private int limit;
    private IPMINM20Command ipmiNM20Command;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 2) {
            this.help();
            return false;
        }
        try {
            this.socket = Integer.parseInt(this.parameters[0]);
            this.limit = Integer.parseInt(this.parameters[1]);
            if (this.socket < 0 || this.socket > 255 || this.limit < 0 || this.limit > 255) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM40Command() throws Exception {
        try {
            this.ipmiNM20Command = new IPMINM20Command(this.getNMInterface());
            if (this.limit != 0) {
                this.checkLimitRange();
            }
            SetTurboSynchronizationRatio command = new SetTurboSynchronizationRatio(this.ipmiNM20Command, (byte)this.socket, -1, (byte)this.limit);
            command.execute();
            MOut.G(this).println("Done.");
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = ex.getMessage().contains("Used to indicate an unrecognized or unsupported command") ? 153 : 148;
        }
    }

    private void checkLimitRange() throws IPMIException {
        GetTurboSynchronizationRatio command = new GetTurboSynchronizationRatio(this.ipmiNM20Command, (byte)this.socket, -1);
        TurboRatio tr = command.execute();
        if (this.limit > tr.maxTurboRatioLimit || this.limit < tr.minTurboRatioLimit) {
            throw new IPMIException("Turbo Ration limit exceeds vaild range (" + tr.minTurboRatioLimit + "-" + tr.maxTurboRatioLimit + ").\n");
        }
    }

    private void help() {
        MOut.G(this).println("setTurboSyncRatio <socket> <limit>");
        MOut.G(this).println("socket: CPU socket number");
        MOut.G(this).println("\t0~7       \u00a1V CPU socket number that configuration should be applied to");
        MOut.G(this).println("\t            (Supported value depends on system configuration)");
        MOut.G(this).println("\t255 (FFh) \u00a1V Apply configuration to all present sockets");
        MOut.G(this).println("limit: Turbo Ratio Limit");
        MOut.G(this).println("\t0         \u00a1V Restore default settings");
        MOut.G(this).println("\tOthers    \u00a1V Turbo Ratio Limit to set");
    }
}

