/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.LinkedList;

public class IPMIOEMSummary
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        int number;
        byte numberFrom3021;
        int i;
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIInterface ipmiInterface = this.ipmiCMMOEMCommand.getIPMIInterface();
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (!IPMIMessagingCommand.isSupportedIPMISummary(guid)) {
            MOut.G(this).println("Not supported device for this command");
            this.statusCode = 153;
            return;
        }
        ipmiOEMCommand.setIPMIInterface(ipmiInterface);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiInterface);
        ipmiLanCommand.setIPMIInterface(ipmiInterface);
        IPMII2CPMBusCommand ipmii2cPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmii2cPMBusCommand.setIPMIInterface(ipmiInterface);
        byte ipmode = 0;
        try {
            ipmode = ipmiLanCommand.getIPProtocol();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        MOut.G(this).println("Summary");
        MOut.G(this).println("-------------------------------------------");
        if (ipmode == 0 || ipmode == 2) {
            MOut.G(this).println("IPv4                   : " + ipmiLanCommand.getIP());
        }
        MOut.G(this).println("BMC MAC Address        : " + ipmiLanCommand.getMAC());
        if (deviceInfo.usingAuxiliaryFWVesion) {
            MOut.G(this).println("Firmware Revision      : " + String.format("%02d", deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]));
        } else {
            MOut.G(this).println("Firmware Revision      : " + String.format("%02d", deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
        }
        byte[] bytes = ipmiOEMCommand.getFirmwareBuild();
        String s = new String(bytes);
        char c = s.toCharArray()[0];
        if (bytes != null && c != '\u0000') {
            MOut.G(this).println("Firmware Build Time    : " + ByteUtility.transferDateFormat(s));
        }
        if (!(IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid))) {
            bytes = ipmiOEMCommand.getBiosVer();
            if (bytes != null) {
                s = new String(bytes);
                c = s.toCharArray()[0];
            }
            if (bytes != null && c != '\u0000') {
                s = s.trim();
                MOut.G(this).println("BIOS Version           : " + s);
            }
            if ((bytes = ipmiOEMCommand.getBiosDate()) != null) {
                s = new String(bytes);
                c = s.toCharArray()[0];
            }
            if (bytes != null && c != '\u0000') {
                MOut.G(this).println("BIOS Build Time        : " + ByteUtility.transferDateFormatFromBiosFormat(s));
            }
        }
        String cpld = null;
        cpld = IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isJBOF2500GUID(guid) || IPMIMessagingCommand.isJBOD2500GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) ? ipmii2cPMBusCommand.getPLLDversion2500() : (IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isX13EGSGUID(guid) || IPMIMessagingCommand.isX13EGSHW1GUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) ? ipmiOEMCommand.getRotCPLDversion() : (IPMIMessagingCommand.isX12AST2600NonRoT(guid) ? ipmii2cPMBusCommand.getTatlowCPLDVersion() : (IPMIMessagingCommand.isHGIMEZZGUID(guid) ? ipmii2cPMBusCommand.getHGICarrierBoardCPLDVersion() : ipmii2cPMBusCommand.getCPLDversion())));
        if (cpld != null) {
            MOut.G(this).println("CPLD Version           : " + cpld);
        }
        if (ipmode == 2 || ipmode == 1) {
            LinkedList<String> ipv6List = ipmiOEMCommand.getIPv6Address();
            for (i = 0; i < ipv6List.size(); ++i) {
                MOut.G(this).println("IPv6                   : " + ipv6List.get(i));
            }
        }
        if ((numberFrom3021 = ipmiOEMCommand.getNumberOfMacBy3021()) != 0) {
            bytes = ipmiOEMCommand.getSystemMACAddress();
            if (bytes != null) {
                MOut.G(this).println("System LAN1 MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex(bytes[5]));
            }
            if (numberFrom3021 > 1 && numberFrom3021 <= 4) {
                for (i = 0; i < numberFrom3021 - 1; ++i) {
                    MOut.G(this).println("System LAN" + (i + 2) + " MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex((byte)(bytes[5] + i + 1)));
                }
                this.statusCode = 0;
                return;
            }
        }
        if ((number = ipmiOEMCommand.getOtherSystemMacNumber()) > 0) {
            bytes = ipmiOEMCommand.getOtherSystemMacAddress();
        }
        for (int i2 = 0; i2 < number; ++i2) {
            MOut.G(this).println("System LAN" + (numberFrom3021 + 1) + " MAC Address: " + ByteUtility.byteToHex(bytes[i2 * 6 + 0]) + ":" + ByteUtility.byteToHex(bytes[i2 * 6 + 1]) + ":" + ByteUtility.byteToHex(bytes[i2 * 6 + 2]) + ":" + ByteUtility.byteToHex(bytes[i2 * 6 + 3]) + ":" + ByteUtility.byteToHex(bytes[i2 * 6 + 4]) + ":" + ByteUtility.byteToHex(bytes[i2 * 6 + 5]));
        }
        this.statusCode = 0;
    }

    public String parseIPv6IP(byte[] data) {
        if ((data[2] & 0xFFFFFF80) != -128) {
            return "Disabled";
        }
        String ip = "";
        ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        return ip;
    }

    public String parseIPv6Dynamic(byte[] data) {
        if (data[20] != 0) {
            return "Disabled";
        }
        String ip = "";
        ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        return ip;
    }

    public int parsePrefix(byte[] data) {
        return data[19] & 0xFF;
    }
}

