/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;

public class IPMIOEMADDeleteCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte groupID;

    @Override
    public boolean preValidate() {
        String usage = "delete <group id>";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.groupID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("group id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.groupID < 1 || this.groupID > 5) {
            MOut.G(this).println("group id should be 1-5");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("AD command is not supported on this device, you may try redfish accountService ad command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ByteBuffer target = ByteBuffer.allocate(1);
        this.groupID = (byte)(this.groupID - 1);
        target.put(this.groupID);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)6, target.array())) {
            MOut.G(this).println("Delete group failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

