/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanProtocolCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            return true;
        }
        if (this.parameters.length == 1) {
            try {
                if (Integer.parseInt(this.parameters[0]) >= 0 && Integer.parseInt(this.parameters[0]) <= 2) {
                    return true;
                }
                this.printUsage();
                return false;
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("stauts should be number");
                this.printUsage();
                return false;
            }
        }
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            byte protocol = (byte)Integer.parseInt(this.parameters[0]);
            ipmiLanCommand.setIPProtocol(protocol);
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            byte protocol = ipmiLanCommand.getIPProtocol();
            if (protocol == 0) {
                MOut.G(this).println("Current status: IPv4 Only");
            } else if (protocol == 1) {
                MOut.G(this).println("Current status: IPv6 Only");
            } else if (protocol == 2) {
                MOut.G(this).println("Current status: Dual");
            } else {
                MOut.G(this).println("Current status: Unknown");
            }
            this.printUsage();
            this.statusCode = 0;
        }
    }

    public void printUsage() {
        MOut.G(this).println("\nSet protocol parameters");
        MOut.G(this).println("IPv4 only : 0");
        MOut.G(this).println("IPv6 only : 1");
        MOut.G(this).println("Dual      : 2");
    }
}

