/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6ClearCommand
extends SuperBladeCommand {
    int index;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 1) {
            this.printUsage();
            return false;
        }
        try {
            this.index = Integer.parseInt(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("Invalid id");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        int max = ipmiLanCommand.getMaxStaticIPv6Number();
        if (this.index >= max) {
            MOut.G(this).println("ID must < " + (max - 1));
            this.statusCode = 147;
            return;
        }
        if (ipmiLanCommand.removeIPv6Address((byte)this.index)) {
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            this.statusCode = 148;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi lan ipv6 clear <id>");
    }
}

