/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.HDDStatus;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class HDDDiskCommand
extends SuperBladeCommand {
    int index;
    int devID = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean preValidate() {
        this.index = -1;
        this.devID = 0;
        if (this.parameters != null) {
            try {
                this.index = Integer.parseInt(this.parameters[0]);
                if (this.parameters.length <= 1) return true;
                this.devID = Integer.parseInt(this.parameters[1]);
                return true;
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid Index");
                return false;
            }
        } else {
            MOut.G(this).println("Usage: hdd disk <index> [device id]");
            return false;
        }
    }

    @Override
    public void runCommand() throws Exception {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            IPMIHDDOEMCommand.HDDMap map = ipmiHDDOEMCommand.getHDDMap(this.devID);
            if (map == null) {
                MOut.G(this).println("This device does not support HDD interface");
                this.statusCode = 153;
                return;
            }
            if (!map.isExist(this.index)) {
                MOut.G(this).println("This HDD is not present");
                return;
            }
            HDDStatus.deviceId = this.devID;
            HDDStatus status = ipmiHDDOEMCommand.getHDDInfoStructure((byte)this.index, (byte)this.devID);
            MOut.G(this).print(status.toString());
        }
        catch (IPMIException ex) {
            MOut.G(this).println("This device does not support HDD interface");
            this.statusCode = 153;
        }
        this.statusCode = 0;
    }
}

