/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbpbi.payload;

import java.nio.ByteBuffer;

public class PayloadSMC {
    public static final byte SMC_GET_INFO = -63;
    public static final byte SMC_GET_LOC_SLOT = -62;
    public static final int PAYLOAD_SIZE = 3;
    public static final int TYPE_GPU = 0;
    public static final int TYPE_FPGA = 1;
    public static final int TYPE_COUNT = 2;
    public static final int BEGIN_CORE = 0;
    public static final int BEGIN_INDEX = 1;
    public static final int CORE_INDEX_COUNT = 4;
    public static final int GPU_INDEX_COUNT = 16;
    public static final int FPGA_INDEX_COUNT = 2;
    public static final int BASE_BOARD_TOP = 1;
    public static final int BASE_BOARD_BOTTOM = 2;
    public static final int BASE_BOARD_COUNT = 3;
    private byte data1;
    private byte data2;
    private byte data3;

    public PayloadSMC() {
        this.data1 = 0;
        this.data2 = 1;
        this.data3 = 0;
    }

    public PayloadSMC(byte d1, byte d2, byte d3) {
        this.data1 = d1;
        this.data2 = d2;
        this.data3 = d3;
    }

    public int getGPUCore() {
        return this.data1 >> 4 & 3;
    }

    public byte getGPUIndex() {
        return this.data2;
    }

    public byte getData1() {
        return this.data1;
    }

    public byte getData2() {
        return this.data2;
    }

    public byte getData3() {
        return this.data3;
    }

    public boolean setType(int type) {
        if (0 <= type && type < 2) {
            this.data1 = (byte)(this.data1 | type);
            return true;
        }
        return false;
    }

    public boolean setGPUCore(int core) {
        if (0 <= core && core < 4) {
            this.data1 = (byte)(this.data1 | core << 4);
            return true;
        }
        return false;
    }

    public boolean setBaseBoardNumber(int number) {
        if (number == 1 || number == 2 || number == 0) {
            this.data1 = (byte)(this.data1 | number << 6);
            return true;
        }
        return false;
    }

    public boolean setIndexNumber(int index, int type) {
        if (type == 0 && 0 < index && index <= 16 || type == 1 && 0 < index && index <= 2) {
            this.data2 = (byte)index;
            return true;
        }
        return false;
    }

    public boolean setReadCount(int count) {
        this.data3 = (byte)count;
        return true;
    }

    public ByteBuffer getHeaderByteBuffer() {
        byte[] barry = new byte[]{this.data1, this.data2, this.data3};
        ByteBuffer buffer = ByteBuffer.wrap(barry);
        return buffer;
    }
}

