/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbpbi;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.smbpbi.pattern.OnHandleDisplayEventListenser;
import com.supermicro.ipmi.smbpbi.pattern.command.SMBPBIInfoCommand;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUBoardPartNumber;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUBuildDate;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUFirmwareVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUGPUGUID;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUGPUPartNumber;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUGetPower;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUInfoROMVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUMarketingName;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUMemoryPartNumber;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUMemoryVendor;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.GPUSerialNumber;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.OEMGPUCardDetect;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.OEMGPULocationSlot;
import com.supermicro.ipmi.smbpbi.pattern.invoker.SMBPBIInfoInvoker;
import com.supermicro.ipmi.smbpbi.pattern.receiver.SMBPBIInfoReceiver;
import java.util.Vector;

public class GPUInfoCommand {
    private boolean execResult;
    private SMBPBIInfoReceiver receiver;
    private SMBPBIInfoInvoker invoker;
    private SMBPBIInfoCommand oemGPUCardDetectCommand;
    private SMBPBIInfoCommand oemGPULocationSlotCommand;
    private SMBPBIInfoCommand gpuGetPowerCommand;
    private SMBPBIInfoCommand gpuBoardPartNumberCommand;
    private SMBPBIInfoCommand gpuSerialNumberCommand;
    private SMBPBIInfoCommand gpuMarketingNameCommand;
    private SMBPBIInfoCommand gpuGPUPartNumberCommand;
    private SMBPBIInfoCommand gpuMemoryVendorCommand;
    private SMBPBIInfoCommand gpuMemoryPartNumberCommand;
    private SMBPBIInfoCommand gpuBuildDateCommand;
    private SMBPBIInfoCommand gpuFirmwareVerionCommand;
    private SMBPBIInfoCommand gpuGPUGUIDCommand;
    private SMBPBIInfoCommand gpuInfoROMVersionCommand;
    private final OnHandleDisplayEventListenser listenser = new OnHandleDisplayEventListenser(){

        @Override
        public boolean onDisplayHandleEvent(Vector<String> resultVec, Vector<Integer> args) {
            if (resultVec.size() > 0) {
                String formatTemplate = " %-25s | %45s \n";
                StringBuffer content = new StringBuffer();
                content.append(String.format(" %-25s | %45s \n", "Item", "Value"));
                content.append(String.format(" %-25s | %45s \n", "----", "-----"));
                content.append(String.format(" %-25s | %45s \n", "Location:", resultVec.get(0)));
                content.append(String.format(" %-25s | %45s \n", "Slot:", resultVec.get(1)));
                content.append(String.format(" %-25s | %45s \n", "Power(mW):", resultVec.get(2)));
                content.append(String.format(" %-25s | %45s \n", "Board part number:", resultVec.get(3)));
                content.append(String.format(" %-25s | %45s \n", "Serial number:", resultVec.get(4)));
                content.append(String.format(" %-25s | %45s \n", "Marketing name:", resultVec.get(5)));
                content.append(String.format(" %-25s | %45s \n", "GPU part number:", resultVec.get(6)));
                content.append(String.format(" %-25s | %45s \n", "Memory vendor:", resultVec.get(7)));
                content.append(String.format(" %-25s | %45s \n", "Memory part number:", resultVec.get(8)));
                content.append(String.format(" %-25s | %45s \n", "Build date:", resultVec.get(9)));
                content.append(String.format(" %-25s | %45s \n", "Firmware version:", resultVec.get(10)));
                content.append(String.format(" %-25s | %45s \n", "GPU GUID:", resultVec.get(11)));
                content.append(String.format(" %-25s | %45s \n", "InfoROM version:", resultVec.get(12)));
                System.out.println("");
                System.out.println("GPU " + args.get(0) + " Core " + args.get(1));
                System.out.println(content.toString());
                return true;
            }
            return false;
        }
    };

    public GPUInfoCommand(IPMIMessagingCommand mCommand) {
        this.receiver = new SMBPBIInfoReceiver(mCommand);
        this.invoker = new SMBPBIInfoInvoker();
        this.oemGPUCardDetectCommand = new OEMGPUCardDetect(this.receiver);
        this.oemGPULocationSlotCommand = new OEMGPULocationSlot(this.receiver);
        this.gpuGetPowerCommand = new GPUGetPower(this.receiver);
        this.gpuBoardPartNumberCommand = new GPUBoardPartNumber(this.receiver);
        this.gpuSerialNumberCommand = new GPUSerialNumber(this.receiver);
        this.gpuMarketingNameCommand = new GPUMarketingName(this.receiver);
        this.gpuGPUPartNumberCommand = new GPUGPUPartNumber(this.receiver);
        this.gpuMemoryVendorCommand = new GPUMemoryVendor(this.receiver);
        this.gpuMemoryPartNumberCommand = new GPUMemoryPartNumber(this.receiver);
        this.gpuBuildDateCommand = new GPUBuildDate(this.receiver);
        this.gpuFirmwareVerionCommand = new GPUFirmwareVersion(this.receiver);
        this.gpuGPUGUIDCommand = new GPUGPUGUID(this.receiver);
        this.gpuInfoROMVersionCommand = new GPUInfoROMVersion(this.receiver);
        this.invoker.addCommand(this.oemGPUCardDetectCommand);
        this.invoker.addCommand(this.oemGPULocationSlotCommand);
        this.invoker.addCommand(this.gpuGetPowerCommand);
        this.invoker.addCommand(this.gpuBoardPartNumberCommand);
        this.invoker.addCommand(this.gpuSerialNumberCommand);
        this.invoker.addCommand(this.gpuMarketingNameCommand);
        this.invoker.addCommand(this.gpuGPUPartNumberCommand);
        this.invoker.addCommand(this.gpuMemoryVendorCommand);
        this.invoker.addCommand(this.gpuMemoryPartNumberCommand);
        this.invoker.addCommand(this.gpuBuildDateCommand);
        this.invoker.addCommand(this.gpuFirmwareVerionCommand);
        this.invoker.addCommand(this.gpuGPUGUIDCommand);
        this.invoker.addCommand(this.gpuInfoROMVersionCommand);
    }

    public void exec() {
        Vector<Integer> args = new Vector<Integer>();
        int startGpuIdx = 1;
        int endGpuIdx = 16;
        int startCoreIdx = 0;
        int endCoreIx = 4;
        for (int gIdx = startGpuIdx; gIdx <= endGpuIdx; ++gIdx) {
            for (int cIdx = startCoreIdx; cIdx < endCoreIx; ++cIdx) {
                args.clear();
                args.add(gIdx);
                args.add(cIdx);
                this.receiver.setGPUCore(cIdx);
                this.receiver.setIndexNumber(gIdx, 0);
                this.invoker.sendCommand();
                this.invoker.display(this.listenser, args);
            }
        }
        if (this.invoker.getDisplayCount() == 0) {
            System.out.println("No GPU card with SMBus Post-Box Interface (SMBPBI) detected");
            this.execResult = false;
        } else {
            this.execResult = true;
        }
    }

    public void setDebugMode(boolean inDebug) {
        this.receiver.setDebugMode(inDebug);
    }

    public boolean getExecResult() {
        return this.execResult;
    }
}

