/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.ArrayList;

public class SpeedSelectConfig
extends TypeStruct {
    byte[] socketNumber;
    byte[] structureVersion;
    byte[] numberOfConfigurations;
    byte[] currentActiveConfiguration;
    ArrayList<Configuration> configs = new ArrayList();
    byte[] reserve1;

    public SpeedSelectConfig(byte[] dataByte) {
        super(dataByte);
        this.socketNumber = this.getTypeLength(this.BYTE);
        this.structureVersion = this.getTypeLength(this.BYTE);
        this.numberOfConfigurations = this.getTypeLength(this.BYTE);
        this.currentActiveConfiguration = this.getTypeLength(this.BYTE);
        this.reserve1 = this.getTypeLength(8);
        for (int i = 0; i < this.numberOfConfigurations[0]; ++i) {
            byte[] raw = this.getTypeLength(32);
            Configuration c = new Configuration();
            c.fromRaw(raw);
            this.configs.add(c);
        }
    }

    int getSocketNumber() {
        return this.socketNumber[0];
    }

    int getStructureVersion() {
        return this.structureVersion[0];
    }

    int getNumberOfConfigurations() {
        return this.numberOfConfigurations[0];
    }

    int getCurrentActiveConfiguration() {
        return this.currentActiveConfiguration[0];
    }

    @Override
    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %40s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format("\n", new Object[0]));
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "------------------------------------"));
        return header.toString();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %40s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "SocketNumber", this.getSocketNumber()));
        fStr.append(String.format(format, "numberOfConfigurations", this.getNumberOfConfigurations()));
        fStr.append(String.format(format, "currentActiveConfiguration", this.getCurrentActiveConfiguration()));
        for (int i = 0; i < this.getNumberOfConfigurations(); ++i) {
            fStr.append(String.format("\n", new Object[0]));
            fStr.append("--------------------------------------------------------------------------\n");
            fStr.append("Configuration " + i + "\n");
            fStr.append("--------------------------------------------------------------------------\n");
            Configuration c = this.configs.get(i);
            fStr.append(String.format(format, "Control Value", c.getConfigControl()));
            fStr.append(String.format(format, "High Priority Core Count", c.getHighPriorityCoreCount()));
            fStr.append(String.format(format, "High Priority Base Frequency", c.getHighPriorityCoreCount()));
            fStr.append(String.format(format, "Low Priority Core Count", c.getLowPriorityCoreCount()));
            fStr.append(String.format(format, "Low Priority Base Frequency", c.getLowPriorityCoreCount()));
            fStr.append(String.format(format, "TDP", c.getTdp()));
            fStr.append(String.format(format, "Max Junction Temp", c.getMaxJunctionTemp()));
        }
        return fStr.toString();
    }

    public class Configuration {
        public byte configControl;
        public byte highPriorityCoreCount;
        public byte highPriorityFrequency;
        public byte lowPriorityCoreCount;
        public byte lowPriorityFrequency;
        public int tdp;
        public byte maxJunctionTemp;
        public byte highPrioriyAPICIDIndex;

        public void fromRaw(byte[] raw) {
            this.configControl = raw[0];
            this.highPriorityCoreCount = raw[4];
            this.highPriorityFrequency = raw[5];
            this.lowPriorityCoreCount = raw[6];
            this.lowPriorityFrequency = raw[7];
            byte[] temp = new byte[2];
            System.arraycopy(raw, 8, temp, 0, 2);
            this.tdp = ByteUtility.twoBytesToInt(temp);
            this.maxJunctionTemp = raw[10];
            this.highPrioriyAPICIDIndex = raw[11];
        }

        public byte getConfigControl() {
            return this.configControl;
        }

        public byte getHighPriorityCoreCount() {
            return this.highPriorityCoreCount;
        }

        public byte getHighPriorityFrequency() {
            return this.highPriorityFrequency;
        }

        public byte getLowPriorityCoreCount() {
            return this.lowPriorityCoreCount;
        }

        public byte getLowPriorityFrequency() {
            return this.lowPriorityFrequency;
        }

        public int getTdp() {
            return this.tdp;
        }

        public byte getMaxJunctionTemp() {
            return this.maxJunctionTemp;
        }
    }
}

