/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;

public class TurboRatio {
    private static final int DATA_LENGTH = 7;
    private static final int CURRENT_TURBO_RATIO_LIMIT = 3;
    private static final int DEFAULT_TURBO_RATIO_LIMIT = 4;
    private static final int MAX_TURBO_RATIO_LIMIT = 5;
    private static final int MIN_TURBO_RATIO_LIMIT = 6;
    private byte[] raw;
    public final int curTurboRatioLimit;
    public final int defTurboRatioLimit;
    public final int maxTurboRatioLimit;
    public final int minTurboRatioLimit;

    public TurboRatio(byte[] raw) throws IPMIException {
        if (raw.length != 7) {
            throw new IPMIException("Invalid Length");
        }
        this.raw = raw;
        this.curTurboRatioLimit = raw[3] & 0xFF;
        this.defTurboRatioLimit = raw[4] & 0xFF;
        this.maxTurboRatioLimit = raw[5] & 0xFF;
        this.minTurboRatioLimit = raw[6] & 0xFF;
    }

    public String toString() {
        return "TurboRatio [curTurboRatioLimit=" + this.curTurboRatioLimit + ", defTurboRatioLimit=" + this.defTurboRatioLimit + ", maxTurboRatioLimit=" + this.maxTurboRatioLimit + ", minTurboRatioLimit=" + this.minTurboRatioLimit + "]";
    }
}

