/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.PolicyAlertThresholds;
import java.util.HashMap;
import java.util.Map;

public class GetNodeManagerPolicyAlertThresholds {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte domainId;
    private byte policyId;

    public GetNodeManagerPolicyAlertThresholds(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
    }

    public PolicyAlertThresholds execute(byte domainId, byte policyId) throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.getNodeManagerAlertThresholdsCommand(domainId, policyId);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new PolicyAlertThresholds(resMessage.data);
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetNodeManagerPolicyAlertThresholds failed");
    }

    public String toString() {
        return "GetNodeManagerPolicyAlertThreasholds [domainId=" + this.domainId + ", policyId=" + this.policyId + "]";
    }

    static {
        completionCodeToString.put("80", "Policy ID Invalid.");
        completionCodeToString.put("81", "Domain ID Invalid.");
    }
}

