/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.sensor.SensorDefine;
import java.util.LinkedHashMap;
import java.util.Map;

public class Common {
    public static final byte[] INTEL_MANUFACTURERS_ID = new byte[]{87, 1, 0};
    public static final Map<Integer, String> PRODUCT_NAME = new LinkedHashMap<Integer, String>();
    public static final Map<Integer, SensorDefine> SENSOR_DEFINES;

    public static IPMIException cCodeToException(Map<String, String> cCodeToStringMap, IPMIMessage resMessage) {
        String completionCodeInHex = ByteUtility.byteToHex(resMessage.completionCode);
        String completionString = null;
        completionString = cCodeToStringMap.get(completionCodeInHex);
        if (completionString == null) {
            completionString = GlobalDefine.getCompletionCodeString(resMessage.completionCode);
        }
        return new IPMIException(resMessage, completionString + "(" + completionCodeInHex + "h)");
    }

    static {
        PRODUCT_NAME.put(0, "Tylersburg");
        PRODUCT_NAME.put(1, "Bromolow");
        PRODUCT_NAME.put(2, "Romley");
        PRODUCT_NAME.put(3, "Denlow");
        PRODUCT_NAME.put(4, "Brickland");
        PRODUCT_NAME.put(5, "Grantley");
        PRODUCT_NAME.put(6, "Grangeville");
        PRODUCT_NAME.put(7, "Groveport Self Boot");
        PRODUCT_NAME.put(8, "Groveport Leverage Boot");
        PRODUCT_NAME.put(9, "Greenlow");
        PRODUCT_NAME.put(10, "Purley");
        PRODUCT_NAME.put(11, "Harrisonville");
        PRODUCT_NAME.put(12, "Purley-EPO");
        PRODUCT_NAME.put(13, "Monte Vista");
        PRODUCT_NAME.put(14, "Bakerville");
        PRODUCT_NAME.put(15, "Ridgeport");
        PRODUCT_NAME.put(16, "Mehlow");
        SENSOR_DEFINES = new LinkedHashMap<Integer, SensorDefine>();
        SENSOR_DEFINES.put(8, new SensorDefine.Builder(8, "PCH Thermal Threshold").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(21, new SensorDefine.Builder(21, "Typical Power Consumption in Sx").sensorType((byte)-36).build());
        SENSOR_DEFINES.put(26, new SensorDefine.Builder(26, "Intel NM Operational Capabilities").eventType((byte)116).sensorType((byte)-36).eventOnly().build());
        SENSOR_DEFINES.put(28, new SensorDefine.Builder(28, "CPU 0 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(29, new SensorDefine.Builder(29, "CPU 1 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(30, new SensorDefine.Builder(30, "CPU 2 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(31, new SensorDefine.Builder(31, "CPU 3 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(235, new SensorDefine.Builder(235, "CPU 4 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(236, new SensorDefine.Builder(236, "CPU 5 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(237, new SensorDefine.Builder(237, "CPU 6 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(238, new SensorDefine.Builder(238, "CPU 7 Thermal Status").eventType((byte)118).sensorType((byte)7).build());
        SENSOR_DEFINES.put(32, new SensorDefine.Builder(32, "CPU 0 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(33, new SensorDefine.Builder(33, "CPU 1 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(34, new SensorDefine.Builder(34, "CPU 2 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(35, new SensorDefine.Builder(35, "CPU 3 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(239, new SensorDefine.Builder(239, "CPU 4 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(240, new SensorDefine.Builder(240, "CPU 5 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(241, new SensorDefine.Builder(241, "CPU 6 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(242, new SensorDefine.Builder(242, "CPU 7 Thermal Control Circuit Activation").eventType((byte)1).sensorType((byte)7).unit("%").build());
        SENSOR_DEFINES.put(36, new SensorDefine.Builder(36, "CPU 0 T-Control").build());
        SENSOR_DEFINES.put(37, new SensorDefine.Builder(37, "CPU 1 T-Control").build());
        SENSOR_DEFINES.put(38, new SensorDefine.Builder(38, "CPU 2 T-Control").build());
        SENSOR_DEFINES.put(39, new SensorDefine.Builder(39, "CPU 3 T-Control").build());
        SENSOR_DEFINES.put(243, new SensorDefine.Builder(243, "CPU 4 T-Control").build());
        SENSOR_DEFINES.put(244, new SensorDefine.Builder(244, "CPU 5 T-Control").build());
        SENSOR_DEFINES.put(245, new SensorDefine.Builder(245, "CPU 6 T-Control").build());
        SENSOR_DEFINES.put(246, new SensorDefine.Builder(246, "CPU 7 T-Control").build());
        SENSOR_DEFINES.put(48, new SensorDefine.Builder(48, "CPU 0 T-JMAX").build());
        SENSOR_DEFINES.put(49, new SensorDefine.Builder(49, "CPU 1 T-JMAX").build());
        SENSOR_DEFINES.put(50, new SensorDefine.Builder(50, "CPU 2 T-JMAX").build());
        SENSOR_DEFINES.put(51, new SensorDefine.Builder(51, "CPU 3 T-JMAX").build());
        SENSOR_DEFINES.put(247, new SensorDefine.Builder(247, "CPU 4 T-JMAX").build());
        SENSOR_DEFINES.put(248, new SensorDefine.Builder(248, "CPU 5 T-JMAX").build());
        SENSOR_DEFINES.put(249, new SensorDefine.Builder(249, "CPU 6 T-JMAX").build());
        SENSOR_DEFINES.put(250, new SensorDefine.Builder(250, "CPU 7 T-JMAX").build());
        SENSOR_DEFINES.put(52, new SensorDefine.Builder(52, "CPU 0 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(53, new SensorDefine.Builder(53, "CPU 1 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(54, new SensorDefine.Builder(54, "CPU 2 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(55, new SensorDefine.Builder(55, "CPU 3 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(251, new SensorDefine.Builder(251, "CPU 4 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(252, new SensorDefine.Builder(252, "CPU 5 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(253, new SensorDefine.Builder(253, "CPU 6 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(254, new SensorDefine.Builder(254, "CPU 7 Memory Throttling").eventType((byte)1).sensorType((byte)12).unit("%").build());
        SENSOR_DEFINES.put(162, new SensorDefine.Builder(162, "Volumetric Airflow").eventType((byte)1).sensorType((byte)11).unit("CFM").build());
        SENSOR_DEFINES.put(163, new SensorDefine.Builder(163, "Inlet Airflow Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(189, new SensorDefine.Builder(189, "Outlet Airflow Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(173, new SensorDefine.Builder(173, "Total Chassis power").eventType((byte)1).sensorType((byte)11).unit("W").build());
        SENSOR_DEFINES.put(190, new SensorDefine.Builder(190, "Core CUPS").eventType((byte)1).sensorType((byte)11).unit("%").build());
        SENSOR_DEFINES.put(191, new SensorDefine.Builder(191, "IO CUPS").eventType((byte)1).sensorType((byte)11).unit("%").build());
        SENSOR_DEFINES.put(192, new SensorDefine.Builder(192, "Memory CUPS").eventType((byte)1).sensorType((byte)11).unit("%").build());
        SENSOR_DEFINES.put(40, new SensorDefine.Builder(40, "HSC 0 Status Low").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(66, new SensorDefine.Builder(66, "HSC 0 Status Byte High").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(94, new SensorDefine.Builder(94, "HSC 0 Status MFR Specific").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(159, new SensorDefine.Builder(159, "HSC 0 Status Input").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(41, new SensorDefine.Builder(41, "HSC 0 Input Power").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(42, new SensorDefine.Builder(42, "HSC 0 Input Voltage").eventType((byte)1).sensorType((byte)2).build());
        SENSOR_DEFINES.put(44, new SensorDefine.Builder(44, "HSC 1 Status Low").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(68, new SensorDefine.Builder(68, "HSC 1 Status Byte High").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(111, new SensorDefine.Builder(111, "HSC 1 Status MFR Specific").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(161, new SensorDefine.Builder(161, "HSC 1 Status Input").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(45, new SensorDefine.Builder(45, "HSC 1 Input Power").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(46, new SensorDefine.Builder(46, "HSC 1 Input Voltage").eventType((byte)1).sensorType((byte)2).build());
        SENSOR_DEFINES.put(220, new SensorDefine.Builder(220, "HSC 2 Status Low").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(221, new SensorDefine.Builder(221, "HSC 2 Status Byte High").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(222, new SensorDefine.Builder(222, "HSC 2 Status MFR Specific").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(223, new SensorDefine.Builder(223, "HSC 2 Status Input").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(224, new SensorDefine.Builder(224, "HSC 2 Input Power").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(225, new SensorDefine.Builder(225, "HSC 2 Input Voltage").eventType((byte)1).sensorType((byte)2).build());
        SENSOR_DEFINES.put(226, new SensorDefine.Builder(226, "HSC 3 Status Low").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(227, new SensorDefine.Builder(227, "HSC 3 Status Byte High").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(228, new SensorDefine.Builder(228, "HSC 3 Status MFR Specific").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(229, new SensorDefine.Builder(229, "HSC 3 Status Input").eventType((byte)111).sensorType((byte)11).build());
        SENSOR_DEFINES.put(230, new SensorDefine.Builder(230, "HSC 3 Input Power").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(231, new SensorDefine.Builder(231, "HSC 3 Input Voltage").eventType((byte)1).sensorType((byte)2).build());
        SENSOR_DEFINES.put(78, new SensorDefine.Builder(78, "PSU 0 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(79, new SensorDefine.Builder(79, "PSU 1 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(80, new SensorDefine.Builder(80, "PSU 2 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(81, new SensorDefine.Builder(81, "PSU 3 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(82, new SensorDefine.Builder(82, "PSU 4 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(83, new SensorDefine.Builder(83, "PSU 5 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(84, new SensorDefine.Builder(84, "PSU 6 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(85, new SensorDefine.Builder(85, "PSU 7 AC Power Input").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(86, new SensorDefine.Builder(86, "PSU 0 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(87, new SensorDefine.Builder(87, "PSU 1 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(88, new SensorDefine.Builder(88, "PSU 2 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(89, new SensorDefine.Builder(89, "PSU 3 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(90, new SensorDefine.Builder(90, "PSU 4 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(91, new SensorDefine.Builder(91, "PSU 5 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(92, new SensorDefine.Builder(92, "PSU 6 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(93, new SensorDefine.Builder(93, "PSU 7 Temperature").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(102, new SensorDefine.Builder(102, "PSU 0 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(103, new SensorDefine.Builder(103, "PSU 1 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(104, new SensorDefine.Builder(104, "PSU 2 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(105, new SensorDefine.Builder(105, "PSU 3 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(106, new SensorDefine.Builder(106, "PSU 4 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(107, new SensorDefine.Builder(107, "PSU 5 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(108, new SensorDefine.Builder(108, "PSU 6 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(109, new SensorDefine.Builder(109, "PSU 7 Status").eventType((byte)111).sensorType((byte)8).build());
        SENSOR_DEFINES.put(164, new SensorDefine.Builder(164, "PSU 0 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(165, new SensorDefine.Builder(165, "PSU 1 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(166, new SensorDefine.Builder(166, "PSU 2 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(167, new SensorDefine.Builder(167, "PSU 3 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(168, new SensorDefine.Builder(168, "PSU 4 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(169, new SensorDefine.Builder(169, "PSU 5 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(170, new SensorDefine.Builder(170, "PSU 6 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(171, new SensorDefine.Builder(171, "PSU 7 DC Power Output").eventType((byte)1).sensorType((byte)11).build());
        SENSOR_DEFINES.put(174, new SensorDefine.Builder(174, "HPIO Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(179, new SensorDefine.Builder(179, "HPIO 0 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(180, new SensorDefine.Builder(180, "HPIO 1 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(181, new SensorDefine.Builder(181, "HPIO 2 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(182, new SensorDefine.Builder(182, "HPIO 3 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(183, new SensorDefine.Builder(183, "HPIO 4 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(184, new SensorDefine.Builder(184, "HPIO 5 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(185, new SensorDefine.Builder(185, "HPIO 6 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(186, new SensorDefine.Builder(186, "HPIO 7 Input Power").eventType((byte)1).sensorType((byte)7).unit("W").build());
        SENSOR_DEFINES.put(232, new SensorDefine.Builder(232, "IMON Input Power").eventType((byte)1).sensorType((byte)1).build());
        SENSOR_DEFINES.put(178, new SensorDefine.Builder(178, "NM SmaRT&CLST").eventType((byte)3).sensorType((byte)-36).build());
        SENSOR_DEFINES.put(197, new SensorDefine.Builder(197, "Host Partition Reset Warning Event").unit("min").eventOnly().build());
        SENSOR_DEFINES.put(58, new SensorDefine.Builder(58, "Power Off Event").eventType((byte)10).sensorType((byte)18).eventOnly().build());
        SENSOR_DEFINES.put(59, new SensorDefine.Builder(59, "Power Threshold").eventType((byte)5).sensorType((byte)9).eventOnly().build());
        SENSOR_DEFINES.put(22, new SensorDefine.Builder(22, "ME Power State Event").eventType((byte)10).sensorType((byte)22).eventOnly().build());
        SENSOR_DEFINES.put(23, new SensorDefine.Builder(23, "ME FW Health Event").eventType((byte)117).sensorType((byte)-36).eventOnly().build());
        SENSOR_DEFINES.put(24, new SensorDefine.Builder(24, "NM Exception Event").eventType((byte)114).sensorType((byte)-36).eventOnly().build());
        SENSOR_DEFINES.put(25, new SensorDefine.Builder(25, "NM Health Event").eventType((byte)115).sensorType((byte)-36).eventOnly().build());
        SENSOR_DEFINES.put(27, new SensorDefine.Builder(27, "NM Threshold Exceeded Event").eventType((byte)114).sensorType((byte)-36).eventOnly().build());
        SENSOR_DEFINES.put(128, new SensorDefine.Builder(128, "USB Connect Status Event").eventOnly().build());
        SENSOR_DEFINES.put(193, new SensorDefine.Builder(193, "CUPS Event").eventType((byte)114).sensorType((byte)-36).eventOnly().build());
    }

    public static enum Domain {
        ENTIRE(0),
        CPU(1),
        MEMORY(2),
        HW_PROTECTION(3),
        HPIO(4);

        private int value;

        private Domain(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static String getDesc(int val) {
            switch (val) {
                case 0: {
                    return "Entire platform";
                }
                case 1: {
                    return "CPU subsystem";
                }
                case 2: {
                    return "Memory subsystem";
                }
                case 3: {
                    return "HW Protection";
                }
                case 4: {
                    return "High Power I/O subsystem";
                }
            }
            return "Undefined";
        }
    }
}

