/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;
import com.supermicro.ipmi.text.MOut;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class SB_B11SRE
extends AbstractSBEntity {
    public Sensor cpuTemp = new Sensor();
    public Sensor pchTemp = new Sensor();
    public Sensor cpuvrmTemp = new Sensor();
    public Sensor systemTemp = new Sensor();
    public Sensor peripheralTemp = new Sensor();
    public Sensor lsiTemp = new Sensor();
    public Sensor inletTemp = new Sensor();
    public Sensor nicTemp = new Sensor();
    public Sensor dimmABvrmTemp = new Sensor();
    public Sensor dimmCDvrmTemp = new Sensor();
    public Sensor p1DimmA1Temp = new Sensor();
    public Sensor p1DimmA2Temp = new Sensor();
    public Sensor p1DimmB1Temp = new Sensor();
    public Sensor p1DimmB2Temp = new Sensor();
    public Sensor p1DimmC1Temp = new Sensor();
    public Sensor p1DimmC2Temp = new Sensor();
    public Sensor p1DimmD1Temp = new Sensor();
    public Sensor p1DimmD2Temp = new Sensor();
    public Sensor vCpu = new Sensor();
    public Sensor vDIMMABCD = new Sensor();
    public Sensor v5 = new Sensor();
    public Sensor v3P3 = new Sensor();
    public Sensor vBAT = new Sensor();
    public Sensor v12 = new Sensor();
    public Sensor vCCSA = new Sensor();
    public Sensor v5SB = new Sensor();
    public Sensor v3P3SB = new Sensor();
    public Sensor p1V8_PCH = new Sensor();
    public Sensor p1V05_PCH = new Sensor();
    public Sensor watchdog = new Sensor();
    public Sensor pwr = new Sensor();
    public Sensor nvme1_SSDTemp = new Sensor();
    public Sensor storageTemp = new Sensor();

    @Override
    public void fromRaw(byte[] raw) {
        Field[] fields;
        super.fromRaw(raw);
        int index = 0;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                ((Sensor)field.get(this)).fromRaw(ByteUtility.getBytes(raw, index, 12));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            index += 12;
        }
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        LinkedHashMap<Sensor, String[]> map = new LinkedHashMap<Sensor, String[]>();
        map.put(this.cpuTemp, new String[]{"CPU Temp", "T"});
        map.put(this.pchTemp, new String[]{"PCH Temp", "T"});
        map.put(this.cpuvrmTemp, new String[]{"CPUVRM Temp", "T"});
        map.put(this.dimmABvrmTemp, new String[]{"DIMMABVRM Temp", "T"});
        map.put(this.dimmCDvrmTemp, new String[]{"DIMMCDVRM Temp", "T"});
        map.put(this.systemTemp, new String[]{"System Temp", "T"});
        map.put(this.peripheralTemp, new String[]{"Peripheral Temp", "T"});
        map.put(this.inletTemp, new String[]{"Inlet Temp", "T"});
        map.put(this.lsiTemp, new String[]{"AOC-LSI Temp", "T"});
        map.put(this.nicTemp, new String[]{"NIC Temp", "T"});
        map.put(this.p1DimmA1Temp, new String[]{"P1-DIMMA1 Temp", "T"});
        map.put(this.p1DimmA2Temp, new String[]{"P1-DIMMA2 Temp", "T"});
        map.put(this.p1DimmB1Temp, new String[]{"P1-DIMMB1 Temp", "T"});
        map.put(this.p1DimmB2Temp, new String[]{"P1-DIMMB2 Temp", "T"});
        map.put(this.p1DimmC1Temp, new String[]{"P1-DIMMC1 Temp", "T"});
        map.put(this.p1DimmC2Temp, new String[]{"P1-DIMMC2 Temp", "T"});
        map.put(this.p1DimmD1Temp, new String[]{"P1-DIMMD1 Temp", "T"});
        map.put(this.p1DimmD2Temp, new String[]{"P1-DIMMD2 Temp", "T"});
        map.put(this.storageTemp, new String[]{"Storage Temp", "T"});
        map.put(this.vBAT, new String[]{"VBAT", "B"});
        map.put(this.v12, new String[]{"12V", "V"});
        map.put(this.v5, new String[]{"5V", "V"});
        map.put(this.v5SB, new String[]{"5VSB", "V"});
        map.put(this.v3P3, new String[]{"3.3VCC", "V"});
        map.put(this.v3P3SB, new String[]{"3.3VSB", "V"});
        map.put(this.vCpu, new String[]{"Vcpu", "V"});
        map.put(this.vDIMMABCD, new String[]{"VDIMMABCD", "V"});
        map.put(this.vCCSA, new String[]{"VCCSA", "V"});
        map.put(this.p1V8_PCH, new String[]{"1.8V PCH", "V"});
        map.put(this.p1V05_PCH, new String[]{"1.05V PCH", "V"});
        map.put(this.watchdog, new String[]{"Watchdog", "W"});
        map.put(this.pwr, new String[]{"PW Consumption", "P"});
        map.put(this.nvme1_SSDTemp, new String[]{"NVMe1_SSDTemp", "T"});
        for (Map.Entry entry : map.entrySet()) {
            try {
                Sensor sensor = (Sensor)entry.getKey();
                String name = ((String[])entry.getValue())[0];
                String type = ((String[])entry.getValue())[1];
                if (sensor.reading == 0) {
                    formatedString.append(String.format(this.formatTemplate, "N/A", name, "N/A", "N/A", "N/A"));
                    continue;
                }
                if ("T".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(true), name, sensor.getHumanReading(sensor.reading) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.min) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.max) + "\u00b0C"));
                    continue;
                }
                if ("V".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(false), name, sensor.getHumanReading(sensor.reading) + " V", sensor.getHumanReading(sensor.min) + " V", sensor.getHumanReading(sensor.max) + " V"));
                    continue;
                }
                if ("B".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, this.vBAT.getStatusString(false).contains("Lower") ? this.vBAT.getStatusString(false) : "Normal", "VBAT", "presence", "N/A", "N/A"));
                    continue;
                }
                if ("W".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
                    continue;
                }
                if ("P".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
                    continue;
                }
                MOut.G().println("Sensor Type Not Found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 33;
    }
}

