/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class UARTTerminalProtocol {
    public static String toTerminalCommand(byte[] raw) {
        byte[] dataBytes = null;
        if (raw.length - 7 > 0) {
            dataBytes = new byte[raw.length - 7];
            for (int i = 0; i < raw.length - 7; ++i) {
                dataBytes[i] = raw[i + 6];
            }
        }
        return "[" + ByteUtility.byteToHex(raw[1]) + " 00 " + ByteUtility.byteToHex(raw[5]) + (dataBytes != null ? " " + ByteUtility.bytesToHex(dataBytes) : "") + "]\r\n";
    }

    public static byte[] fromTerminalCommand(String resString) {
        int start = resString.lastIndexOf("[");
        int end = resString.lastIndexOf("]");
        if (start == -1 || end == -1) {
            return null;
        }
        byte[] raw = ByteUtility.hexToBytesWithSpace(resString = resString.substring(start + 1, end));
        if (raw.length < 4) {
            return null;
        }
        byte[] raw1 = new byte[raw.length + 4];
        raw1[0] = 0;
        raw1[1] = raw[0];
        raw1[2] = 0;
        raw1[3] = 0;
        raw1[4] = 0;
        raw1[5] = raw[2];
        raw1[6] = raw[3];
        System.arraycopy(raw, 4, raw1, 7, raw.length - 4);
        return raw1;
    }

    public static void main(String[] args) {
        byte[] req = new byte[]{32, 24, -56, 65, 0, 1, -47, -46, -66};
        String res = "[18 18 18]\n\r[1c 00 22 00 01 02 03 04 05 06 07 08]\n\r";
        String s = UARTTerminalProtocol.toTerminalCommand(req);
        System.out.println("s =" + s);
        byte[] resBytes = UARTTerminalProtocol.fromTerminalCommand(res);
        System.out.println(ByteUtility.bytesToHex(resBytes));
    }
}

