/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStaticInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.RedundantCMMInfo;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.microblade.SystemMiscInfo;
import java.io.IOException;
import java.util.StringTokenizer;

public class IPMIMicroBladeOEMCommand
extends IPMICommand {
    public static final byte DEVICE_TYPE_BLADE_SERVER = 1;
    public static final byte DEVICE_TYPE_CMM = 2;
    public static final byte DEVICE_TYPE_PS = 3;
    public static final byte DEVICE_TYPE_GB = 4;
    public static final byte DEVICE_TYPE_IB = 5;
    public static final byte DEVICE_TYPE_BLADESENSOR = 6;
    public static final byte DEVICE_TYPE_10GPASS = 8;
    public static final byte DEVICE_TYPE_BLADE = 9;
    public static final byte DEVICE_TYPE_MICROBLADE = 38;
    public static final byte MICROBLADE_NODE_SENSOR = 42;
    public static final byte MICROBLADE_NODE_STATUS = 41;
    public static final byte MICROBLADE_SWITCH = 36;
    public static final byte MICROBLADE_PSU = 35;
    public static final byte MICROBLADE_SYSTEM_MISC = 34;
    public static final byte MICROBLADE_CMM2CMM = 43;
    public static final byte MICROBLADE_REDUNDANT_CMM = 44;
    public static final byte MICROBLADE_FAN = 46;
    public static final byte MICROBLADE_NODE_STATIC = 50;
    public static final int BACKPANEL_TYPE_L628 = 1;
    public static final int BACKPANEL_TYPE_E314 = 2;
    public static final int BACKPANEL_TYPE_E614 = 3;
    public static final int BACKPANEL_TYPE_C820 = 4;
    public static final int BACKPANEL_TYPE_E628 = 5;
    public static final int BACKPANEL_TYPE_J610 = 6;
    public static final int BURST_POWER_OFF = 0;
    public static final int BURST_POWER_ON = 1;
    public static final int BURST_POWER_CYCLE = 2;
    public static final int BURST_POWER_RESET = 3;
    public static final int BURST_POWER_SOFTSHUTDOWN = 5;

    public IPMIMicroBladeOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getSystemInfoByBatchCommand(byte type, byte[] offset, byte[] length) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, type, offset[0], offset[1], length[0], length[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMicroBladeCommand(byte type, byte index, byte indexCount) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, type, index, 0, indexCount, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMicroBladeCommandByOffset(byte type, byte index, byte indexCount, int offset, int length) {
        byte[] offsetArray = new byte[2];
        byte[] lengthArray = new byte[2];
        ByteUtility.intTo2Bytes(offsetArray, 0, offset);
        ByteUtility.intTo2Bytes(lengthArray, 0, length);
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-14, type, index, 0, indexCount, 0, offsetArray[0], offsetArray[1], lengthArray[0], lengthArray[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMicroBladeSensorSizeCommand(byte type, byte index, byte indexCount) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-13, type, index, 0, indexCount, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemMiscInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, 34, 0, 0, 1, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMM2CMMInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, 43, 0, 0, 0, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getRedundantCMMInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, 44, 0, 0, 0, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerSupplyPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerSupplyStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerSupplyStatusCommand(byte index, byte enable) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, index, enable};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanSpeedCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanSpeedCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{8, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanModeCommand(byte auto) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, auto};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchPowerResetCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchPowerStatusCommand(byte index, byte function) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, index, function};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchPowerGracefulRebootCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{22, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchPowerGracefulPowerDownCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{35, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSwitchPowerStatusCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{27, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchLanCommand(byte option, byte index, byte[] pData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = option;
        data[1] = index;
        System.arraycopy(pData, 0, data, 2, pData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSwitchLanCommand(byte option, byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{option, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchDHCPCommand(byte index, byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{19, index, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSwitchDHCPCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{23, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSwitchUsernameCommand(byte ID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, ID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchUsernameCommand(byte ID, String userName) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[userName.length() + 3];
        data[0] = 8;
        data[1] = ID;
        data[2] = (byte)userName.length();
        System.arraycopy(userName.getBytes(), 0, data, 3, userName.length());
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchPasswordCommand(byte ID, String password) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[password.length() + 3];
        data[0] = 9;
        data[1] = ID;
        data[2] = (byte)password.length();
        System.arraycopy(password.getBytes(), 0, data, 3, password.length());
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSwitchTimeCommand(byte ID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, ID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSwitchUIDCommand(byte index, byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{26, index, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBackPlaneInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, -1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeStatusCommand(byte BladeID, byte NodeID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, BladeID, NodeID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeStatusCommand(byte BladeID, byte NodeID, byte status) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, BladeID, NodeID, status};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeLANConfigureCommand(byte BladeID, byte NodeID, byte selector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{29, BladeID, NodeID, selector};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeLANConfigureCommand(byte BladeID, byte NodeID, byte selector, byte[] dataToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[dataToWrite.length + 4];
        data[0] = 28;
        data[1] = BladeID;
        data[2] = NodeID;
        data[3] = selector;
        System.arraycopy(dataToWrite, 0, data, 4, dataToWrite.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeNameCommand(byte BladeID, byte NodeID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{24, BladeID, NodeID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeNameCommand(byte BladeID, byte NodeID, byte[] dataToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[dataToWrite.length + 3];
        data[0] = 23;
        data[1] = BladeID;
        data[2] = NodeID;
        System.arraycopy(dataToWrite, 0, data, 3, dataToWrite.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getNodeUIDLEDCommand(byte BladeID, byte NodeID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, BladeID, NodeID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNodeUIDLEDCommand(byte BladeID, byte NodeID, byte isOn) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, BladeID, NodeID, isOn};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage sendNodeIPMBCommand(byte BladeID, byte NodeID, byte netFn, byte command, byte[] subCommand) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5 + subCommand.length];
        data[0] = -9;
        data[1] = BladeID;
        data[2] = NodeID;
        data[3] = netFn;
        data[4] = command;
        System.arraycopy(subCommand, 0, data, 5, subCommand.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage cmmBurstCommand(byte BladeID, byte NodeID, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, BladeID, NodeID, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public BladeRemoteInfo getBladeRemoteInfo(byte index) throws IPMIException {
        byte[] indexBytes = new byte[2];
        byte[] lengthBytes = new byte[2];
        ByteUtility.intTo2Bytes(indexBytes, 0, index);
        ByteUtility.intTo2Bytes(lengthBytes, 0, 1);
        IPMIMessage resMessage = this.getSystemInfoByBatchCommand((byte)38, indexBytes, lengthBytes);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                BladeRemoteInfo bladeRemoteInfo = new BladeRemoteInfo();
                bladeRemoteInfo.fromRaw(resMessage.data);
                return bladeRemoteInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSystemInfoByBatchCommand(GetBladeRemoteInfo) failed");
    }

    public BladeRemoteInfo[] getAllBladeRemoteInfo(int size) throws IPMIException {
        BladeRemoteInfo[] allBladeRemoteInfo = new BladeRemoteInfo[size];
        for (int i = 0; i < size; ++i) {
            allBladeRemoteInfo[i] = this.getBladeRemoteInfo((byte)i);
        }
        return allBladeRemoteInfo;
    }

    public NodeSensorInfo getNodeSensor(byte bladeIndex, byte nodeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)42, bladeIndex, nodeIndex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeSensorInfo nodeSensorInfo = new NodeSensorInfo();
                nodeSensorInfo.setBladeIndex(bladeIndex);
                nodeSensorInfo.setIndex(nodeIndex);
                nodeSensorInfo.boardId = ByteUtility.getBytes(resMessage.data, 4, 2);
                nodeSensorInfo.setSBEntityType(nodeSensorInfo.getBoardId());
                if (nodeSensorInfo.getBoardId() == 2447 || nodeSensorInfo.getBoardId() == 2455) {
                    int commandSize = 960;
                    IPMIMessage lengthMessage = this.getMicroBladeSensorSizeCommand((byte)42, bladeIndex, nodeIndex);
                    int length = ByteUtility.twoBytesToIntLSBSigned(lengthMessage.data);
                    byte[] result = new byte[length];
                    int i = 0;
                    while (i < length) {
                        IPMIMessage resMessage2;
                        if (length - i < commandSize) {
                            resMessage2 = this.getMicroBladeCommandByOffset((byte)42, bladeIndex, nodeIndex, i, length - i);
                            System.arraycopy(resMessage2.data, 0, result, i, resMessage2.data.length);
                            i += length - i;
                            continue;
                        }
                        resMessage2 = this.getMicroBladeCommandByOffset((byte)42, bladeIndex, nodeIndex, i, commandSize);
                        System.arraycopy(resMessage2.data, 0, result, i, resMessage2.data.length);
                        i += commandSize;
                    }
                    nodeSensorInfo.fromRaw(result);
                } else {
                    nodeSensorInfo.fromRaw(resMessage.data);
                }
                return nodeSensorInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getNodeSensor) failed");
    }

    public NodeSensorInfo[] getAllNodeSensor(int size) throws IPMIException {
        NodeSensorInfo[] allNodeSensorInfo = new NodeSensorInfo[size * 4];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < 4; ++j) {
                allNodeSensorInfo[count++] = this.getNodeSensor((byte)i, (byte)j);
            }
        }
        return allNodeSensorInfo;
    }

    public NodeStatusInfo getNodeStatus(byte bladeIndex, byte nodeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)41, bladeIndex, nodeIndex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeStatusInfo nodeStatusInfo = new NodeStatusInfo();
                nodeStatusInfo.setIndex(nodeIndex);
                nodeStatusInfo.fromRaw(resMessage.data);
                return nodeStatusInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getNodeStatus) failed");
    }

    public NodeStatusInfo[] getAllNodeStatus(int size) throws IPMIException {
        NodeStatusInfo[] allNodeStatusInfo = new NodeStatusInfo[size * 4];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < 4; ++j) {
                allNodeStatusInfo[count++] = this.getNodeStatus((byte)i, (byte)j);
            }
        }
        return allNodeStatusInfo;
    }

    public SwitchInfo getSwitch(byte switchIndex, byte structureCount) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)36, switchIndex, structureCount);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                SwitchInfo switchInfo = new SwitchInfo();
                switchInfo.setIndex(switchIndex);
                if (resMessage.data.length > 0) {
                    switchInfo.fromRaw(resMessage.data);
                }
                return switchInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getSwitch) failed");
    }

    public SwitchInfo[] getAllSwitch(int size) throws IPMIException {
        SwitchInfo[] allSwitchInfo = new SwitchInfo[size];
        for (int i = 0; i < size; ++i) {
            allSwitchInfo[i] = this.getSwitch((byte)i, (byte)1);
        }
        return allSwitchInfo;
    }

    public PowerSupplyInfo getPowerSupply(byte psuIndex, byte structureCount) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)35, psuIndex, structureCount);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                PowerSupplyInfo powerSupplyInfo = new PowerSupplyInfo();
                powerSupplyInfo.setIndex(psuIndex);
                if (resMessage.data.length > 0) {
                    powerSupplyInfo.fromRaw(resMessage.data);
                }
                return powerSupplyInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getPowerSupply) failed");
    }

    public PowerSupplyInfo[] getAllPowerSupply(int size) throws IPMIException {
        PowerSupplyInfo[] allPowerSupplyInfo = new PowerSupplyInfo[size];
        for (int i = 0; i < size; ++i) {
            allPowerSupplyInfo[i] = this.getPowerSupply((byte)i, (byte)1);
        }
        return allPowerSupplyInfo;
    }

    public PowerSupplyInfo getFan(byte fanIndex, byte structureCount) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)46, fanIndex, structureCount);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                PowerSupplyInfo fanInfo = new PowerSupplyInfo();
                fanInfo.setIndex(fanIndex);
                if (resMessage.data.length > 0) {
                    fanInfo.fromRaw(resMessage.data);
                }
                return fanInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getPowerSupply) failed");
    }

    public PowerSupplyInfo[] getAllFan(int size) throws IPMIException {
        PowerSupplyInfo[] allFanInfo = new PowerSupplyInfo[size];
        for (int i = 0; i < size; ++i) {
            allFanInfo[i] = this.getFan((byte)i, (byte)1);
        }
        return allFanInfo;
    }

    public SystemMiscInfo getSystemMisc() throws IPMIException {
        IPMIMessage resMessage = this.getSystemMiscInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                SystemMiscInfo systemMiscInfo = new SystemMiscInfo();
                if (resMessage.data.length > 0) {
                    systemMiscInfo.fromRaw(resMessage.data);
                }
                return systemMiscInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSystemMiscInfoCommand(getSystemMisc) failed");
    }

    public CMM2CMMInfo getCMM2CMMInfo() throws IPMIException {
        IPMIMessage resMessage = this.getCMM2CMMInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                CMM2CMMInfo cmm2cmmInfo = new CMM2CMMInfo();
                if (resMessage.data.length > 0) {
                    cmm2cmmInfo.fromRaw(resMessage.data);
                }
                return cmm2cmmInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSystemMiscInfoCommand(getCMM2CMMInfo) failed");
    }

    public NodeStaticInfo getNodeStaticInfo(byte bladeIndex, byte nodeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)50, bladeIndex, nodeIndex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeStaticInfo nodeStaticInfo = new NodeStaticInfo();
                nodeStaticInfo.setIndex(nodeIndex);
                nodeStaticInfo.fromRaw(resMessage.data);
                return nodeStaticInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getMicroBladeCommand(getPowerSupply) failed");
    }

    public NodeStaticInfo[] getAllNodeStatic(int size) throws IPMIException {
        NodeStaticInfo[] allNodeStaticInfo = new NodeStaticInfo[size * 4];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < 4; ++j) {
                allNodeStaticInfo[count++] = this.getNodeStaticInfo((byte)i, (byte)j);
            }
        }
        return allNodeStaticInfo;
    }

    public RedundantCMMInfo getRedundantCMMInfo() throws IPMIException {
        IPMIMessage resMessage = this.getRedundantCMMInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                RedundantCMMInfo redundantCMMInfo = new RedundantCMMInfo();
                if (resMessage.data.length > 0) {
                    redundantCMMInfo.fromRaw(resMessage.data);
                }
                return redundantCMMInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSystemMiscInfoCommand(getRedundantCMMInfo) failed");
    }

    public String getALLPowerPresent() throws IPMIException {
        IPMIMessage resMessage = this.getPowerSupplyPresentCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String s = ByteUtility.bytesToBin(resMessage.data);
                return s;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getPowerSupplyStatusCommand failed");
    }

    public String getALLPowerStatus() throws IPMIException {
        IPMIMessage resMessage = this.getPowerSupplyStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String s = ByteUtility.bytesToBin(resMessage.data);
                return s;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getPowerSupplyStatusCommand failed");
    }

    public void setPowerStatus(int index, boolean isOn) throws IPMIException {
        byte enable = (byte)(isOn ? 1 : 0);
        IPMIMessage resMessage = this.setPowerSupplyStatusCommand((byte)index, enable);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getPowerSupplyStatusCommand failed");
    }

    public byte getFanMode() throws IPMIException {
        IPMIMessage resMessage = this.getFanModeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getPowerSupplyFanModeCommand failed");
    }

    public void setFanMode(boolean auto) throws IPMIException {
        byte mode = (byte)(!auto ? 1 : 0);
        IPMIMessage resMessage = this.setFanModeCommand(mode);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setPowerSupplyFanModeCommand failed");
    }

    public byte getFanSpeed() throws IPMIException {
        IPMIMessage resMessage = this.getFanSpeedCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getPowerSupplyFanModeCommand failed");
    }

    public void setFanSpeed(int level) throws IPMIException {
        byte index = (byte)level;
        IPMIMessage resMessage = this.setFanSpeedCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setPowerSupplyFanModeCommand failed");
    }

    public boolean setSwitchPowerReset(int id) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchPowerResetCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchPowerResetCommandfailed");
    }

    public boolean setSwitchPowerStatus(int id, byte option) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchPowerStatusCommand(index, option);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchPowerStatusCommand failed");
    }

    public boolean setSwitchPowerGracefulReboot(int id) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchPowerGracefulRebootCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchPowerGracefulReboot");
    }

    public boolean setSwitchPowerGracefulPowerDown(int id) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchPowerGracefulPowerDownCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchPowerGracefulPowerDown");
    }

    public boolean setSwitchIP(int id, String ip) throws IPMIException {
        byte option = 5;
        byte index = (byte)id;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setSwitchLanCommand(option, index, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchLanCommand failed");
    }

    public boolean setSwitchMask(int id, String ip) throws IPMIException {
        byte option = 6;
        byte index = (byte)id;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setSwitchLanCommand(option, index, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchLanCommand failed");
    }

    public boolean setSwitchGateway(int id, String ip) throws IPMIException {
        byte option = 7;
        byte index = (byte)id;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setSwitchLanCommand(option, index, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSwitchLanCommand failed");
    }

    public String getSwitchIP(int index) {
        IPMIMessage resMessage = this.getSwitchLanCommand((byte)11, (byte)index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Microblade LAN configuration");
        return null;
    }

    public String getSwitchMask(int index) {
        IPMIMessage resMessage = this.getSwitchLanCommand((byte)12, (byte)index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Microblade LAN configuration");
        return null;
    }

    public String getSwitchGateway(int index) {
        IPMIMessage resMessage = this.getSwitchLanCommand((byte)13, (byte)index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Microblade LAN configuration");
        return null;
    }

    public byte getSwitchPowerStatus(int id) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.getSwitchPowerStatusCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSwitchPowerStatusCommand failed");
    }

    public String getSwitchDHCPStatus(int id) throws IPMIException {
        byte index = (byte)id;
        IPMIMessage resMessage = this.getSwitchDHCPCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data[1] == 1) {
                    return "Static IP";
                }
                if (resMessage.data[1] == 2) {
                    return "DHCP";
                }
            } else {
                throw this.ccode2Exception(resMessage);
            }
        }
        throw new IPMIException("Call getSwitchPowerStatusCommand failed");
    }

    public boolean setSwitchDHCPStatus(int id, int mode) throws IPMIException {
        IPMIMessage resMessage = this.setSwitchDHCPCommand((byte)id, (byte)mode);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSwitchPowerStatusCommand failed");
    }

    public String getSwitchUsername(int id) {
        byte index = (byte)id;
        IPMIMessage resMessage = this.getSwitchUsernameCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte length = resMessage.data[0];
                byte[] username = new byte[length];
                System.arraycopy(resMessage.data, 1, username, 0, length);
                return new String(username).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Switch Username");
        return null;
    }

    public boolean setSwitchUsername(int id, String username) {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchUsernameCommand(index, username);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set user name successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set switch user name");
        return false;
    }

    public boolean setSwitchPassword(int id, String password) {
        byte index = (byte)id;
        IPMIMessage resMessage = this.setSwitchUsernameCommand(index, password);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set user password successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set switch password");
        return false;
    }

    public String getSwitchTime(int id) {
        byte index = (byte)id;
        IPMIMessage resMessage = this.getSwitchTimeCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte minute = resMessage.data[2];
                byte second = resMessage.data[1];
                String s_minute = minute < 10 ? "0" + Integer.toString(minute) : Integer.toString(minute);
                String s_second = second < 10 ? "0" + Integer.toString(second) : Integer.toString(second);
                String s = Integer.toString(resMessage.data[8]) + Integer.toString(resMessage.data[7]) + "-" + Integer.toString(resMessage.data[6]) + "-" + Integer.toString(resMessage.data[5]) + " " + Integer.toString(resMessage.data[3]) + ":" + s_minute + ":" + s_second;
                return s;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Switch Time");
        return null;
    }

    public boolean setSwitchUID(int id, int mode) throws IPMIException {
        IPMIMessage resMessage = this.setSwitchUIDCommand((byte)id, (byte)mode);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSwitchPowerStatusCommand failed");
    }

    public byte getNodeStatus(int bladeID, int nodeID) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeStatusCommand(Bladeindex, Nodeindex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeStatusCommand failed");
    }

    public void setNodeStatus(int bladeID, int nodeID, int option) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte PowerOption = (byte)option;
        IPMIMessage resMessage = this.setNodeStatusCommand(Bladeindex, Nodeindex, PowerOption);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeStatusCommand failed");
    }

    public String getNodeLanIP(int bladeID, int nodeID) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
                return ip;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeLANConfigureCommand failed");
    }

    public boolean setNodeLanIP(int bladeID, int nodeID, String ip) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)3, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeLANConfigureCommand failed");
    }

    public String getNodeLanDHCP(int bladeID, int nodeID) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)4);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data[0] == 1) {
                    return "Static IP";
                }
                if (resMessage.data[0] == 2) {
                    return "DHCP";
                }
                return "IP Mode Undefined";
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeLANConfigureCommand failed");
    }

    public boolean setNodeLanDHCP(int bladeID, int nodeID, int option) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte[] data = new byte[]{(byte)option};
        IPMIMessage resMessage = this.setNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)4, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeLANConfigureCommand failed");
    }

    public String getNodeLanMAC(int bladeID, int nodeID) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)5);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mac = "";
                mac = ByteUtility.byteToHex(resMessage.data[0]) + ":" + ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]);
                return mac;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get node LAN configuration");
        return null;
    }

    public boolean setNodeLanMAC(int bladeID, int nodeID, String mac) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte[] data = new byte[6];
        if (!IPMILanCommand.isMacAddress(mac)) {
            MessageCenter.getInstance().put(this, (Object)"MAC format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mac, ":");
        for (int i = 0; i < 6; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MAC format error!");
                return false;
            }
            data[i] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)5, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set node LAN configuration");
        return false;
    }

    public String getNodeLanSubnetMask(int bladeID, int nodeID) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)6);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mask = "";
                mask = (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
                return mask;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get node LAN configuration");
        return null;
    }

    public boolean setNodeLanSubnetMask(int bladeID, int nodeID, String mask) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(mask)) {
            MessageCenter.getInstance().put(this, (Object)"Subnet Mask format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mask, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MASK format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)6, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set node LAN configuration");
        return false;
    }

    public String getNodeLanGateway(int bladeID, int nodeID) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)12);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayIP = "";
                gatewayIP = (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
                return gatewayIP;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get node LAN configuration");
        return null;
    }

    public boolean setNodeLanGateway(int bladeID, int nodeID, String gatewayIP) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(gatewayIP)) {
            MessageCenter.getInstance().put(this, (Object)"Gateway IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(gatewayIP, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"gatewayIP format error!");
                return false;
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setNodeLANConfigureCommand(Bladeindex, Nodeindex, (byte)12, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set node LAN configuration");
        return false;
    }

    public String getNodeName(int bladeID, int nodeID) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeNameCommand(Bladeindex, Nodeindex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Node Name");
        return null;
    }

    public boolean setNodeName(int bladeID, int nodeID, String username) {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.setNodeNameCommand(Bladeindex, Nodeindex, username.getBytes());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set node name successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set node name");
        return false;
    }

    public boolean setNodeUIDLED(int bladeID, int nodeID, byte isOn) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.setNodeUIDLEDCommand(Bladeindex, Nodeindex, isOn);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNodeUIDLEDCommand failed");
    }

    public byte getNodeUIDLED(int bladeID, int nodeID) throws IPMIException {
        byte Bladeindex = (byte)bladeID;
        byte Nodeindex = (byte)nodeID;
        IPMIMessage resMessage = this.getNodeUIDLEDCommand(Bladeindex, Nodeindex);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeUIDLEDCommand failed");
    }

    public int getBackPlaneBladeNumber() throws IPMIException {
        IPMIMessage resMessage = this.getBackPlaneInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNodeUIDLEDCommand failed");
    }

    public byte[] sendNodeIPMB(byte bladeIndex, byte nodeIndex, byte netFn, byte command, byte[] data) throws IPMIException {
        IPMIMessage resMessage = this.sendNodeIPMBCommand(bladeIndex, nodeIndex, netFn, command, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call sendNodeIPMBCommand failed");
    }

    public boolean cmmBurst(byte BladeID, byte NodeID, byte action) throws IPMIException {
        IPMIMessage resMessage = this.cmmBurstCommand(BladeID, NodeID, action);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        throw new IPMIException("Call cmmBurstCommandfailed");
    }

    public static void main(String[] args) throws IPMIException {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.10.23");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        try {
            System.out.println("1 - Get data");
            System.out.println("2 - Spend time");
            int input = System.in.read();
            boolean enable = true;
            if (input == 0) {
                enable = false;
            } else if (input == 1) {
                enable = true;
            }
            String s = ipmiMicroBladeOEMCommand.getNodeName(25, 0);
            System.out.println(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sessionController.closeSession();
    }
}

