/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ASFMessage;
import com.supermicro.ipmi.ATENFlash;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIPayloadCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.SessionInfo;
import com.supermicro.ipmi.UART;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TreeMap;

public class IPMIMessagingCommand
extends IPMICommand {
    TreeMap userIDtoName = new TreeMap();

    public IPMIMessagingCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public ASFMessage asfPing() {
        ASFMessage asfPingMessage = new ASFMessage();
        ASFMessage asfPongMessage = ((RMCP)this.ipmiInterface).sendASFMessage(asfPingMessage);
        return asfPongMessage;
    }

    public IPMIMessage GetSystemGUIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        ipmiMessage.setCommandAndData((byte)24, (byte)55, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetChannelAuthenticationCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 4};
        ipmiMessage.setCommandAndData((byte)24, (byte)56, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetChannelAuthenticationCapabilitiesCommandForPlus() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-114, 4};
        ipmiMessage.setCommandAndData((byte)24, (byte)56, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetSessionChallengeCommand(String userName) {
        IPMIMessage resMessage;
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[18];
        data[0] = 2;
        System.arraycopy(userName.getBytes(), 0, data, 1, userName.length());
        ipmiMessage.setCommandAndData((byte)24, (byte)57, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        if ((resMessage = this.ipmiInterface.send(ipmiMessage)) != null && resMessage.completionCode == 0) {
            System.arraycopy(resMessage.data, 0, ((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, 4);
        }
        return resMessage;
    }

    public IPMIMessage activateSessionCommand(byte authType, byte maxPrivilege, byte[] challengeString) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[22];
        data[0] = authType;
        data[1] = maxPrivilege;
        System.arraycopy(challengeString, 0, data, 2, 16);
        System.arraycopy(((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, data, 18, 4);
        ipmiMessage.setCommandAndData((byte)24, (byte)58, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSessionPrivilegeLevelCommand(byte privilegeLevel) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{privilegeLevel};
        ipmiMessage.setCommandAndData((byte)24, (byte)59, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = (byte)2;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage closeSessionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        if (this.ipmiInterface instanceof RMCPPlus) {
            System.arraycopy(((RMCPPlus)this.ipmiInterface).rmcpPlusSession.sessionID, 0, data, 0, 4);
        } else if (this.ipmiInterface instanceof RMCP) {
            System.arraycopy(((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, data, 0, 4);
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage closeSessionCommand(byte[] sessionID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(sessionID, 0, data, 0, data.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSessionInfoCommand(byte sessionIndex, byte sessionHandle, byte[] sessionID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        if (sessionIndex == -2) {
            data = new byte[2];
            data[1] = sessionHandle;
        } else if (sessionIndex == -1) {
            data = new byte[5];
            System.arraycopy(sessionID, 0, data, 1, 4);
        } else {
            data = new byte[]{sessionIndex};
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)61, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserAccessCommand(byte data1, byte userID, byte userLimit, byte userSessionLimit) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{data1, userID, userLimit, userSessionLimit};
        ipmiMessage.setCommandAndData((byte)24, (byte)67, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUserAccessCommand(byte channelNumber, byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channelNumber, userID};
        ipmiMessage.setCommandAndData((byte)24, (byte)68, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserNameCommand(byte userID, String userName) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        data[0] = userID;
        System.arraycopy(userName.getBytes(), 0, data, 1, userName.length());
        ipmiMessage.setCommandAndData((byte)24, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserNameBinCommand(byte userID, byte value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        data[0] = userID;
        data[1] = value;
        ipmiMessage.setCommandAndData((byte)24, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setClearNameByFill0XFFCommand(byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        data[0] = userID;
        for (int i = 0; i < 16; ++i) {
            data[1 + i] = -1;
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUserNameCommand(byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{userID};
        ipmiMessage.setCommandAndData((byte)24, (byte)70, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserPasswordCommand(byte userID, byte operation, String password) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        if (this.ipmiInterface instanceof RMCP || password.getBytes().length <= 16) {
            data = new byte[18];
            data[0] = userID;
            data[1] = operation;
            System.arraycopy(password.getBytes(), 0, data, 2, password.getBytes().length);
        } else if (this.ipmiInterface instanceof RMCPPlus || this.ipmiInterface instanceof IPMB || this.ipmiInterface instanceof UART) {
            data = new byte[22];
            data[0] = (byte)(0xFFFFFF80 | userID);
            data[1] = operation;
            System.arraycopy(password.getBytes(), 0, data, 2, password.getBytes().length);
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)71, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBMCGlobalEnablesCommand(byte setting) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{setting};
        ipmiMessage.setCommandAndData((byte)24, (byte)46, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBMCGlobalEnablesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)47, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearMessageFlagsCommand(byte flags) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{flags};
        ipmiMessage.setCommandAndData((byte)24, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMessageFlagsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableMessageChannelReceiveCommand(byte channel, byte channelState) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, channelState};
        ipmiMessage.setCommandAndData((byte)24, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMessageCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage sendMessageCommand(byte channel, byte[] messageData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + messageData.length];
        data[0] = channel;
        data[0] = (byte)(data[0] | 0x40);
        System.arraycopy(messageData, 0, data, 1, messageData.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        resMessage = this.ipmiInterface.receive();
        return resMessage;
    }

    public IPMIMessage readEventMessageBufferCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)53, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInterfaceCapabilitiesCommand(byte type) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{type};
        ipmiMessage.setCommandAndData((byte)24, (byte)87, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage masterWriteReadCommand(byte busID, byte slaveAddr, byte readCount, byte[] dataToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + dataToWrite.length];
        data[0] = busID;
        data[1] = slaveAddr;
        data[2] = readCount;
        System.arraycopy(dataToWrite, 0, data, 3, dataToWrite.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getOEMGetPSUInfoCommand(byte psuIndex, byte busID, byte slaveAddr, byte readCount, byte[] dataToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte cmd = 112;
        byte[] data = new byte[5 + dataToWrite.length];
        data[0] = 121;
        data[1] = psuIndex;
        data[2] = busID;
        data[3] = slaveAddr;
        data[4] = readCount;
        System.arraycopy(dataToWrite, 0, data, 5, dataToWrite.length);
        ipmiMessage.setCommandAndData((byte)-64, cmd, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInfoParametersCommand(byte selector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, selector, 0, 0};
        ipmiMessage.setCommandAndData((byte)24, (byte)89, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSMBPBIInfoCommand(byte command, byte[] data) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, command, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isSupportedUserOEMCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{57, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        return this.ipmiInterface.send(ipmiMessage);
    }

    public IPMIMessage setUserByOEMCommand(byte accountIndex, byte usernameLength, byte passwordLength, byte[] encryptedPayload) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5 + encryptedPayload.length];
        data[0] = 57;
        data[1] = 1;
        data[2] = accountIndex;
        data[3] = usernameLength;
        data[4] = passwordLength;
        System.arraycopy(encryptedPayload, 0, data, 5, encryptedPayload.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        return this.ipmiInterface.send(ipmiMessage);
    }

    public IPMIMessage clearUserByOEMCommand(byte accountIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{57, 2, accountIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        return this.ipmiInterface.send(ipmiMessage);
    }

    public int getNumberOfAvailableUser() {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0x3F & resMessage.data[0];
            }
            if (resMessage.completionCode == -44) {
                return -2;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return -1;
    }

    public int getCountOfCurrentEnabledUser() {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0x3F & resMessage.data[1];
            }
            if (resMessage.completionCode == -44) {
                return -2;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return -1;
    }

    public String getUserNameByID(byte userID) {
        IPMIMessage resMessage = this.getUserNameCommand(userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User Name");
        return null;
    }

    public byte getUserNameBinByID(byte userID) {
        IPMIMessage resMessage = this.getUserNameCommand(userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User Name");
        return -1;
    }

    public byte getUserIDByName(String userName) {
        for (byte i = 2; i <= 10; i = (byte)(i + 1)) {
            String tempUserName = this.getUserNameByID(i);
            if (!tempUserName.equals(userName)) continue;
            return i;
        }
        return -1;
    }

    public boolean setUserNameByID(byte userID, String username) {
        IPMIMessage resMessage = this.setUserNameCommand(userID, username);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User name successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User name");
        return false;
    }

    public boolean setUserNameBinByID(byte userID, byte value) {
        IPMIMessage resMessage = this.setUserNameBinCommand(userID, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User name successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User name");
        return false;
    }

    public boolean clearUserNameByFill0XFF(byte userID) {
        IPMIMessage resMessage = this.setClearNameByFill0XFFCommand(userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"setClearName4AMICommand successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute setClearName4AMICommand");
        return false;
    }

    public boolean setUserPasswordByID(byte userID, String password) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)2, password);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User password successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                case -56: {
                    MessageCenter.getInstance().put(this, (Object)"Password requirements: \r\n- Require password length: 8 to 20 characters \r\n- Password can not be reverse of the user name \r\n- Password must include characters from at least 3 of the listed character classes \r\n- Allowed character classes \r\n - a - z \r\n - A - Z \r\n - 0 - 9 \r\n - Special characters \r\n");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public boolean setEnableUserByID(byte userID) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)1, "");
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable password successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public boolean setEnableUserPlusByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-79, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable user (plus) successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set enable User (Plus)");
        return false;
    }

    public boolean setDisableUserPlusByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-127, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable user (plus) successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set enable User (Plus)");
        return false;
    }

    public boolean setDisableUserByID(byte userID) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)0, "");
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set disable user successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public byte getUserPrivilegeByID(byte userID) {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (byte)(resMessage.data[3] & 0xF);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User Access");
        return -1;
    }

    public boolean setUserPrivilegeByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-79, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User privilege successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User Access");
        return false;
    }

    public boolean isSOLEnabled(byte userID) {
        IPMIPayloadCommand command = new IPMIPayloadCommand(this.ipmiInterface);
        return command.isSOLEnabled(userID);
    }

    public boolean setEnableUserPayloadForSOL(byte userID, boolean enable) {
        IPMIPayloadCommand command = new IPMIPayloadCommand(this.ipmiInterface);
        return command.setEnableUserPayloadForSOL(userID, enable);
    }

    public boolean isEnableUserMessaing(byte userID) {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[3] & 0x30) > 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return false;
    }

    public boolean isEnableUser(byte userID) {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if ((resMessage.data[1] >> 6 & 3) == 0) {
                    return (resMessage.data[3] & 0x30) > 1;
                }
                return (resMessage.data[1] >> 6 & 3) == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return false;
    }

    public boolean isUserOEMCommandSupported() {
        IPMIMessage resMessage = this.isSupportedUserOEMCommand();
        return resMessage != null && resMessage.completionCode == -57;
    }

    public int setUserOEMCommand(byte accountIndex, byte usernameLength, byte passwordLength, byte[] encryptedPayload) {
        IPMIMessage resMessage = this.setUserByOEMCommand(accountIndex, usernameLength, passwordLength, encryptedPayload);
        if (resMessage != null) {
            return resMessage.completionCode == 0 ? resMessage.completionCode : resMessage.data[0];
        }
        return -52;
    }

    public int clearUserOEMCommand(byte accountIndex) {
        IPMIMessage resMessage = this.clearUserByOEMCommand(accountIndex);
        if (resMessage != null) {
            return resMessage.completionCode == 0 ? resMessage.completionCode : resMessage.data[0];
        }
        return -52;
    }

    public void createUserID2Name() {
        this.userIDtoName.clear();
        int number = this.getNumberOfAvailableUser();
        for (int i = 1; i <= number; ++i) {
            String name = this.getUserNameByID((byte)i);
            this.userIDtoName.put("" + i, name);
        }
    }

    public SessionInfo getCurrentlySessionInfo(byte[] sessionID) {
        IPMIMessage resMessage = this.getSessionInfoCommand((byte)-1, (byte)0, sessionID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                SessionInfo sessionInfo = SessionInfo.fromRaw6Bytes(resMessage.data);
                return sessionInfo;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Session Info");
        return null;
    }

    public ArrayList getAllCurrentlySessionInfo(byte numberOfSessions) {
        ArrayList<SessionInfo> al = new ArrayList<SessionInfo>();
        for (int i = 1; i < numberOfSessions + 1; ++i) {
            IPMIMessage resMessage = this.getSessionInfoCommand((byte)i, (byte)0, null);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    SessionInfo sessionInfo = SessionInfo.fromRaw6Bytes(resMessage.data);
                    al.add(sessionInfo);
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        }
        return al;
    }

    public byte[] getSystemGUID() {
        IPMIMessage resMessage = this.GetSystemGUIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            return null;
        }
        return null;
    }

    public static byte[] getSystemGUIDByIP(String ip) {
        return IPMIMessagingCommand.getSystemGUIDByIP(ip, 10, 1);
    }

    public static byte[] getSystemGUIDByIP(String ip, int port) {
        return IPMIMessagingCommand.getSystemGUIDByIP(ip, 10, 1, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSystemGUIDByIP(String ip, int timeout, int retry) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setTimeout(timeout);
        config.setRetry(retry);
        config.setIp(ip);
        RMCP rmcp = new RMCP();
        byte[] guid = null;
        try {
            rmcp.initialize(config);
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
            guid = ipmiMessagingCommand.getSystemGUID();
        }
        finally {
            rmcp.closeSocket();
        }
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSystemGUIDByIP(String ip, int timeout, int retry, int port) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setTimeout(timeout);
        config.setRetry(retry);
        config.setIp(ip);
        config.setPort(port);
        RMCP rmcp = new RMCP();
        byte[] guid = null;
        try {
            rmcp.initialize(config);
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
            guid = ipmiMessagingCommand.getSystemGUID();
        }
        finally {
            rmcp.closeSocket();
        }
        return guid;
    }

    public static IPMIGUID getIPMIGUIDType(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return IPMIGUID.UNDEFINED;
        }
        if (IPMIMessagingCommand.isOSAGUID(guid)) {
            return IPMIGUID.OSA;
        }
        if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            return IPMIGUID.PEPPERCON_SIM_IPMI;
        }
        if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            return IPMIGUID.PEPPERCON_NONE_KVM_SIM_IPMI;
        }
        if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
            return IPMIGUID.PEPPERCON_NORMAL_BLADE_CMM;
        }
        if (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid)) {
            return IPMIGUID.PEPPERCOM_OFFICE_BLADE_CMM;
        }
        if (IPMIMessagingCommand.isTwinBladeCMMGUID(guid)) {
            return IPMIGUID.PEPPERCOM_TWIN_BLADE_CMM;
        }
        if (IPMIMessagingCommand.isSIMBL(guid)) {
            return IPMIGUID.PEPPERCON_SIMBL;
        }
        if (IPMIMessagingCommand.isAMIGUID(guid)) {
            return IPMIGUID.AMI;
        }
        if (IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            return IPMIGUID.AMI_SIMBL;
        }
        if (IPMIMessagingCommand.isATENGUID(guid)) {
            return IPMIGUID.ATEN;
        }
        if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
            return IPMIGUID.AMI_X9;
        }
        if (IPMIMessagingCommand.isATENAspeedGUID(guid)) {
            return IPMIGUID.ATEN_ASPEED;
        }
        if (IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
            return IPMIGUID.AMI_ASPEED;
        }
        if (IPMIMessagingCommand.isCB3GUID(guid)) {
            return IPMIGUID.ATEN_CB3;
        }
        if (IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
            return IPMIGUID.ATEN_SUPERBLADE;
        }
        if (IPMIMessagingCommand.isMicroBladeNodeGUID(guid)) {
            return IPMIGUID.ATEN_MICROBLADE_NODE;
        }
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
            return IPMIGUID.ATEN_MICROBLADE_CMM;
        }
        if (IPMIMessagingCommand.isSAS3_946E90GUID(guid)) {
            return IPMIGUID.SAS3_946E90;
        }
        if (IPMIMessagingCommand.isAST2400GUID(guid)) {
            return IPMIGUID.AST2400;
        }
        if (IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid)) {
            return IPMIGUID.AST2500;
        }
        if (IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid)) {
            return IPMIGUID.AST2600;
        }
        if (IPMIMessagingCommand.isH11GUID(guid)) {
            return IPMIGUID.H11;
        }
        if (IPMIMessagingCommand.isP8DTUGUID(guid)) {
            return IPMIGUID.Power8;
        }
        if (IPMIMessagingCommand.isPOWER9GUID(guid)) {
            return IPMIGUID.Power9;
        }
        if (IPMIMessagingCommand.isH12GUID(guid)) {
            return IPMIGUID.H12;
        }
        if (IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid)) {
            return IPMIGUID.H12_ROT;
        }
        if (IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid)) {
            return IPMIGUID.B12_ROT;
        }
        if (IPMIMessagingCommand.isNuvotonGUID(guid)) {
            return IPMIGUID.Nuvoton;
        }
        if (IPMIMessagingCommand.isJBOF2500GUID(guid)) {
            return IPMIGUID.AST2500JBOF;
        }
        if (IPMIMessagingCommand.isJBOD2500GUID(guid)) {
            return IPMIGUID.AST2500JBOD;
        }
        if (IPMIMessagingCommand.isM12GUID(guid)) {
            return IPMIGUID.M12;
        }
        if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            return IPMIGUID.HGIMEZZ;
        }
        if (IPMIMessagingCommand.isX13EGSGUID(guid) || IPMIMessagingCommand.isX13EGSHW1GUID(guid)) {
            return IPMIGUID.X13EGS;
        }
        return IPMIGUID.UNDEFINED;
    }

    public byte[] getSystemInfoParameter(byte selector) throws Exception {
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(selector);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getSystemInfoParametersCommand failed");
    }

    public byte[] getSMBPBIInfo(byte command, byte[] data, boolean showMsg) {
        IPMIMessage resMessage = this.getSMBPBIInfoCommand(command, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            if (showMsg) {
                System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
        } else if (showMsg) {
            System.out.println("Call GetSMBPBIInfo Failed");
        }
        return null;
    }

    public static boolean isOSAGUID(byte[] guid) {
        return guid[0] == 32 && guid[1] == 0 && guid[2] == 14 && guid[3] == 64 && guid[4] == 2 && guid[5] == 127 && guid[6] == 120 && guid[7] == 8;
    }

    public static boolean isPepperconGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 2 && guid[1] == 0 && guid[2] == 0 && guid[3] == -1 && guid[4] == -2 && guid[5] == 0 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isPepperconNoneKVMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid);
    }

    public static boolean isNormalBladeCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        boolean result = false;
        if (guid[0] == 49 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0) {
            result = true;
        }
        return result;
    }

    public static boolean isOfficeBladeCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        boolean result = false;
        if (guid[0] == 51 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0) {
            result = true;
        }
        return result;
    }

    public static boolean isTwinBladeCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        boolean result = false;
        if (guid[0] == 56 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0) {
            result = true;
        }
        return result;
    }

    public static boolean isSIMBL(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public static boolean isAMIGUID(byte[] guid) {
        if (IPMIMessagingCommand.isAMIOnBoardGUID(guid)) {
            return true;
        }
        return IPMIMessagingCommand.isAMIAddOnGUID(guid);
    }

    public static boolean isAMIOnBoardGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 53 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAMIAddOnGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 52 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAMISIMBLGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 54 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isATENGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 55 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAMIX9GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 57 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isRenesasATENGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 65 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isRenesasAddOnATENGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 66 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isATENAspeedGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 67 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAMIAspeedGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 68 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isMicroBladeCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 69 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isMicroBladeNodeGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 70 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isCB3GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isATENSuperBladeGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isSAS3_946E90GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2400GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 51 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2500GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 52 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isP8DTUGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 53 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean is8USuperBladeGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 56 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2500HW1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 57 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH11GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 54 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isPOWER9GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 55 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 66 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isNuvotonGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 69 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX11RotGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 68 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12DGOGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 68 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12RoTGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 70 && guid[1] == 49 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12RoTHW1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isB12RoTHW1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12RoTGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 51 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2600GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 53 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2600HW1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 54 && guid[1] == 50 && guid[2] == 48 && guid[3] == 50 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isB12AST2600GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 55 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isJBOF2500GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 56 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12SSFFGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 57 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isJBOD2500GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 65 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isM12GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 66 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isAST2600HW1ROT20GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 67 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12SSFRGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 69 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12AST2600NonRoT(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 70 && guid[1] == 50 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isB12AST2600MAC1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12DGQGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12DSGGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 52 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isHGIMEZZGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 53 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12AST2600NonRoTHW1(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 54 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isMicroBladeCMM64MBGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 55 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12DSCGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 56 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isH12SSGGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 57 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isB3ST1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 65 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX13EGSGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 67 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX13EGSHW1GUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 68 && guid[1] == 51 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public static boolean isX12SPTGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 53 && guid[1] == 52 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83;
    }

    public boolean clearReceiveMessageQueue() {
        IPMIMessage resMessage = this.clearMessageFlagsCommand((byte)1);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public static String getFWTypeByGUID(byte[] guid) {
        String type = "";
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            if (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid)) {
                type = "IPMI 2.0 (SuperBlade OfficeBlade CMM)";
            } else if (IPMIMessagingCommand.isTwinBladeCMMGUID(guid)) {
                type = "IPMI 2.0 (SuperBlade TwinBlade CMM)";
            } else if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
                type = "IPMI 2.0 (SuperBlade CMM)";
            }
        } else {
            type = IPMIMessagingCommand.isSIMBL(guid) ? "IPMI 2.0 SIMBL" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "IPMI 2.0 SIM IPMI+KVM" : (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) ? "IPMI 2.0 SIM IPMI+KVM" : (IPMIMessagingCommand.isOSAGUID(guid) ? "IPMI 2.0 SUPERO IPMI" : (IPMIMessagingCommand.isAMIGUID(guid) ? "IPMI 2.0 SIM(W) IPMI+KVM" : (IPMIMessagingCommand.isAMISIMBLGUID(guid) ? "IPMI 2.0 SIMBL(W) IPMI+KVM" : (IPMIMessagingCommand.isATENGUID(guid) ? "IPMI 2.0 SIM(WA) IPMI+KVM" : (IPMIMessagingCommand.isAMIX9GUID(guid) ? "IPMI 2.0 SIM(X9) IPMI+KVM" : (IPMIMessagingCommand.isATENAspeedGUID(guid) ? "IPMI 2.0 ASPD_T IPMI+KVM" : (IPMIMessagingCommand.isAMIAspeedGUID(guid) ? "IPMI 2.0 ASPD_M IPMI+KVM" : (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) ? "MicroCMM" : (IPMIMessagingCommand.isMicroBladeNodeGUID(guid) ? "MicroNode" : (IPMIMessagingCommand.isCB3GUID(guid) ? "CSE-PTJBOD-CB3" : (IPMIMessagingCommand.isATENSuperBladeGUID(guid) ? "SuperBlade" : (IPMIMessagingCommand.isSAS3_946E90GUID(guid) ? "SAS3_946E90" : (IPMIMessagingCommand.isAST2400GUID(guid) ? "AST2400" : (IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isX11RotGUID(guid) ? "AST2500" : (IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) ? "X12 AST2600RoT" : (IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid) ? "X12 AST2600NonRoT" : (IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) ? "X12 AST2500" : (IPMIMessagingCommand.isH11GUID(guid) ? "H11" : (IPMIMessagingCommand.isP8DTUGUID(guid) ? "Power8" : (IPMIMessagingCommand.isPOWER9GUID(guid) ? "Power9" : (IPMIMessagingCommand.isH12GUID(guid) ? "H12" : (IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) ? "H12RoT" : (IPMIMessagingCommand.isB12RoTHW1GUID(guid) ? "B12RoT" : (IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) ? "B12 AST2600RoT" : (IPMIMessagingCommand.isJBOF2500GUID(guid) ? "AST2500 JBOF" : (IPMIMessagingCommand.isJBOD2500GUID(guid) ? "AST2500 JBOD" : (IPMIMessagingCommand.isX12DGOGUID(guid) ? "X12DGO" : (IPMIMessagingCommand.isNuvotonGUID(guid) ? "Nuvoton" : (IPMIMessagingCommand.isM12GUID(guid) ? "M12" : (IPMIMessagingCommand.isB3ST1GUID(guid) ? "B3 AST2500" : (IPMIMessagingCommand.isHGIMEZZGUID(guid) ? "HGI-MEZZ AST2500" : (IPMIMessagingCommand.isX13EGSGUID(guid) || IPMIMessagingCommand.isX13EGSHW1GUID(guid) ? "X13 EGS" : "IPMI"))))))))))))))))))))))))))))))))));
        }
        return type;
    }

    public static boolean isSupportedIPMISummary(byte[] guid) {
        return !IPMIMessagingCommand.isAMIAddOnGUID(guid) && !IPMIMessagingCommand.isAMIAspeedGUID(guid) && !IPMIMessagingCommand.isAMIGUID(guid) && !IPMIMessagingCommand.isAMIOnBoardGUID(guid) && !IPMIMessagingCommand.isAMISIMBLGUID(guid) && !IPMIMessagingCommand.isAMIX9GUID(guid) && !IPMIMessagingCommand.isOSAGUID(guid) && !IPMIMessagingCommand.isPepperconGUID(guid) && !IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) && !IPMIMessagingCommand.isCMMGUID(guid);
    }

    public static boolean isBeforeX12(byte[] guid) {
        return guid != null && (IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid) || IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isJBOF2500GUID(guid) || IPMIMessagingCommand.isJBOD2500GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid));
    }

    public static boolean isNonROT(byte[] guid) {
        return guid != null && (IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid));
    }

    public static void main_sessionTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.100");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        ipmiMessageingCommand.createUserID2Name();
        System.out.println(ipmiMessageingCommand.userIDtoName.toString());
        SessionInfo sessionInfo = ipmiMessageingCommand.getCurrentlySessionInfo(((RMCPPlus)rmcp).rmcpPlusSession.sessionID);
        ArrayList al = ipmiMessageingCommand.getAllCurrentlySessionInfo(sessionInfo.getNumberOfCurrentlyActiveSession());
        System.out.println("SessionID = " + ByteUtility.bytesToHex(((RMCPPlus)rmcp).rmcpPlusSession.sessionID));
        for (SessionInfo aSessionInfo : al) {
            if (aSessionInfo != null) {
                System.out.println(aSessionInfo.toString());
                System.out.println(" User Name = " + ipmiMessageingCommand.userIDtoName.get("" + aSessionInfo.getUserID()));
            }
            if (aSessionInfo.getSessionHandle() == sessionInfo.getSessionHandle()) continue;
            System.out.println("sessionHandle =" + aSessionInfo.getSessionHandle());
            byte[] sessionID = new byte[4];
            sessionID[0] = aSessionInfo.getSessionHandle();
            System.out.println(" SessionID be to closed =" + ByteUtility.bytesToHex(sessionID));
            IPMIMessage resMessage = ipmiMessageingCommand.closeSessionCommand(sessionID);
            if (resMessage == null) continue;
            System.out.println(" Close session result = " + GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        sessionController.closeSession();
    }

    public static void main______(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        RMCP rmcp = new RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(rmcp);
        IPMIMessage resMessage = ipmiMessageingCommand.GetSystemGUIDCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
    }

    public static void main___ipmb(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        IPMIMessage resMessage = ipmiMessageingCommand.getBMCGlobalEnablesCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        resMessage = ipmiMessageingCommand.getMessageFlagsCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        resMessage = ipmiMessageingCommand.getSystemInterfaceCapabilitiesCommand((byte)1);
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        byte[] a = new byte[10];
        resMessage = ipmiMessageingCommand.sendMessageCommand((byte)0, a);
        System.out.println(ByteUtility.byteToHex(resMessage.completionCode));
        resMessage = ipmiMessageingCommand.getMessageCommand();
        System.out.println(ByteUtility.byteToHex(resMessage.completionCode));
        sessionController.closeSession();
    }

    public static void main_old(String[] args) {
        int i;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.117");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        int number = ipmiMessageingCommand.getNumberOfAvailableUser();
        System.out.println("number of available number =" + number);
        number = ipmiMessageingCommand.getCountOfCurrentEnabledUser();
        System.out.println("current enabled user =" + number);
        for (i = 1; i <= 10; ++i) {
            String name = ipmiMessageingCommand.getUserNameByID((byte)i);
            System.out.println(i + ": " + name);
        }
        for (i = 1; i <= 10; ++i) {
            boolean isEnable = ipmiMessageingCommand.isEnableUser((byte)i);
            System.out.println(i + ": " + (isEnable ? "enable" : "disable"));
        }
        boolean result = ipmiMessageingCommand.setUserNameByID((byte)1, "nulluser");
        System.out.println("result =" + result);
        result = ipmiMessageingCommand.setEnableUserByID((byte)1);
        System.out.println("result =" + result);
        for (i = 4; i <= 10; ++i) {
            ipmiMessageingCommand.setDisableUserByID((byte)i);
        }
        result = ipmiMessageingCommand.setUserNameByID((byte)10, "test");
        result = ipmiMessageingCommand.setUserPasswordByID((byte)10, "test");
        result = ipmiMessageingCommand.setEnableUserByID((byte)10);
        result = ipmiMessageingCommand.setUserPrivilegeByID((byte)10, (byte)4);
        System.out.println(ipmiMessageingCommand.getUserNameByID((byte)10));
        System.out.println(ipmiMessageingCommand.isEnableUser((byte)10));
        sessionController.closeSession();
    }

    public static void main_(String[] args) {
        String ip = "192.168.1.112";
        int count = 0;
        for (int i = 0; i < 5000; ++i) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Calendar c1 = Calendar.getInstance();
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
            System.out.println(ByteUtility.bytesToHex(guid));
            Calendar c2 = Calendar.getInstance();
            double timediff = (double)(c2.getTime().getTime() - c1.getTime().getTime()) / 1000.0;
            System.out.println(timediff + ":" + ++count);
        }
    }

    public static void oneCommandTest() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        int number = ipmiMessageingCommand.getNumberOfAvailableUser();
        System.out.println("number of available User =" + number);
    }

    public static void main___(String[] args) {
        int i;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        int number = ipmiMessageingCommand.getNumberOfAvailableUser();
        System.out.println("number of available User =" + number);
        number = ipmiMessageingCommand.getCountOfCurrentEnabledUser();
        System.out.println("current enabled user =" + number);
        for (i = 1; i <= 10; ++i) {
            String name = ipmiMessageingCommand.getUserNameByID((byte)i);
            System.out.println(i + ": " + name);
        }
        for (i = 1; i <= 10; ++i) {
            boolean isEnable = ipmiMessageingCommand.isEnableUser((byte)i);
            System.out.println(i + ": " + (isEnable ? "enable" : "disable"));
        }
        boolean result = ipmiMessageingCommand.setUserNameByID((byte)10, "test");
        result = ipmiMessageingCommand.setUserPasswordByID((byte)10, "test");
        result = ipmiMessageingCommand.setEnableUserByID((byte)10);
        result = ipmiMessageingCommand.setUserPrivilegeByID((byte)10, (byte)4);
        System.out.println(ipmiMessageingCommand.getUserNameByID((byte)10));
        System.out.println(ipmiMessageingCommand.isEnableUser((byte)10));
        sessionController.closeSession();
    }

    public static void main(String[] args) throws Exception {
        IPMIMessagingCommand.mainMagicSeqNumTest(args);
    }

    public static void main_old1(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.117");
        config.setUserName("root");
        config.setPassword("superuser");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        String name = ipmiMessageingCommand.getUserNameByID((byte)2);
        byte b = ipmiMessageingCommand.getUserPrivilegeByID((byte)2);
        System.out.println(name);
        System.out.println(b);
        IPMIMessage resMessage2 = ipmiMessageingCommand.GetSystemGUIDCommand();
        if (resMessage2 != null) {
            System.out.println(resMessage2.toString());
        }
        sessionController.closeSession();
    }

    public static void main_AMI(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.173");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        for (int i = 1; i <= 10; ++i) {
            String name = ipmiMessageingCommand.getUserNameByID((byte)i);
            byte b = ipmiMessageingCommand.getUserPrivilegeByID((byte)i);
            System.out.println(i + ": " + name + "," + b);
        }
        byte[] ff = new byte[16];
        for (int i = 0; i < 16; ++i) {
            ff[i] = -1;
        }
        boolean result = ipmiMessageingCommand.setUserNameByID((byte)5, new String(ff));
        System.out.println("result =" + result);
        result = ipmiMessageingCommand.setUserPasswordByID((byte)5, "cccccccc");
        System.out.println("result =" + result);
        sessionController.closeSession();
    }

    public static void main______sessionInfo(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.8.77");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        ipmiMessageingCommand.createUserID2Name();
        System.out.println(ipmiMessageingCommand.userIDtoName.toString());
        SessionInfo sessionInfo = ipmiMessageingCommand.getCurrentlySessionInfo(((RMCPPlus)rmcp).rmcpPlusSession.sessionID);
        System.out.println(sessionInfo.toString());
        sessionController.closeSession();
    }

    public static void mainxxx(String[] args) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.78");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiMessagingCommand);
        int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
        byte[] b = ipmiMessagingCommand.getSystemInfoParameter((byte)-64);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-63);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-62);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-61);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-60);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-59);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-58);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-57);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-56);
        System.out.println(new String(b));
        b = ipmiMessagingCommand.getSystemInfoParameter((byte)-55);
        System.out.println(new String(b));
    }

    public static void mainGUID(String[] args) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.44");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiMessagingCommand);
        ipmiGlobalCommand.setIPMIInterface(ipmiMessagingCommand.getIPMIInterface());
        ipmiMessagingCommand.isEnableUser((byte)0);
        for (int i = 0; i < 100; ++i) {
            ipmiMessagingCommand.getUserNameByID((byte)0);
        }
        sessionController.closeSession();
    }

    public static void mainMagicSeqNumTest(String[] args) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.44");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiMessagingCommand);
        ipmiGlobalCommand.setIPMIInterface(ipmiMessagingCommand.getIPMIInterface());
        ipmiMessagingCommand.getSystemGUID();
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.getCurrentFWVersion("10.133.176.44", "ADMIN", "ADMIN");
        sessionController.closeSession();
    }

    public static enum IPMIGUID {
        OSA,
        PEPPERCON_SIM_IPMI,
        PEPPERCON_NONE_KVM_SIM_IPMI,
        PEPPERCON_NORMAL_BLADE_CMM,
        PEPPERCOM_OFFICE_BLADE_CMM,
        PEPPERCOM_TWIN_BLADE_CMM,
        PEPPERCON_SIMBL,
        AMI,
        AMI_SIMBL,
        ATEN,
        AMI_X9,
        ATEN_ASPEED,
        AMI_ASPEED,
        ATEN_MICROBLADE_CMM,
        ATEN_MICROBLADE_NODE,
        ATEN_CB3,
        ATEN_SUPERBLADE,
        SAS3_946E90,
        AST2400,
        AST2500,
        AST2600,
        H11,
        Power8,
        Power9,
        UNDEFINED,
        H12,
        H12_ROT,
        B12_ROT,
        BH12_ROT,
        Nuvoton,
        AST2500JBOF,
        AST2500JBOD,
        M12,
        HGIMEZZ,
        X13EGS;

    }
}

