/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.MessageCenter;

public class DCPMMCommand
extends IPMICommand {
    public DCPMMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getDCMMPresentBitmapCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-41, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDCMMUpdateBitmapCommand(byte[] bitmap) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[bitmap.length + 2];
        data[0] = -41;
        data[1] = 1;
        System.arraycopy(bitmap, 0, data, 2, bitmap.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDCMMFirmwareVersionCommand(byte cpu, byte channel, byte slot) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-41, 2, cpu, channel, slot};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDCMMFirmwareUpdateStatusCommand(byte cpu, byte channel, byte slot) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-41, 3, cpu, channel, slot};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getDCMMPresentBitmap() {
        IPMIMessage resMessage = this.getDCMMPresentBitmapCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute GetDCPMM Bitmap Command");
        return null;
    }

    public boolean setDCMMUpdateBitmap(byte[] bitmap) {
        IPMIMessage resMessage = this.setDCMMUpdateBitmapCommand(bitmap);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute setDCPMM Bitmap Command");
        return false;
    }

    public String getDimmFWVersion(byte cpu, byte channel, byte slot) throws IPMIException {
        IPMIMessage resMessage = this.getDCMMFirmwareVersionCommand(cpu, channel, slot);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return ByteUtility.byteToHex(resMessage.data[4]) + "." + ByteUtility.byteToHex(resMessage.data[3]) + "." + ByteUtility.byteToHex(resMessage.data[2]) + "." + ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[0]);
            }
            return null;
        }
        return null;
    }

    public byte getDCMMFirmwareUpdateStatus(byte cpu, byte channel, byte slot) throws IPMIException {
        IPMIMessage resMessage = this.getDCMMFirmwareUpdateStatusCommand(cpu, channel, slot);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getDCMMFirmwareUpdateStatusCommand failed");
    }

    public class DIMM {
        int cpu;
        int channel;
        int slot;
        String version;
        String name;

        public DIMM(int dataIndex, int bitIndex) {
            this.createDimm(dataIndex, bitIndex);
        }

        public int getCpu() {
            return this.cpu;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getSlot() {
            return this.slot;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public void createDimm(int dataIndex, int bitIndex) {
            switch (dataIndex) {
                case 0: 
                case 1: {
                    this.cpu = 0;
                    this.name = "P1";
                    break;
                }
                case 2: 
                case 3: {
                    this.cpu = 1;
                    this.name = "P2";
                    break;
                }
                case 4: 
                case 5: {
                    this.cpu = 2;
                    this.name = "P3";
                    break;
                }
                case 6: 
                case 7: {
                    this.cpu = 3;
                    this.name = "P4";
                }
            }
            if (dataIndex % 2 == 0) {
                switch (bitIndex) {
                    case 0: {
                        this.channel = 0;
                        this.slot = 0;
                        this.name = this.name + "A1";
                        break;
                    }
                    case 1: {
                        this.channel = 0;
                        this.slot = 1;
                        this.name = this.name + "A2";
                        break;
                    }
                    case 2: {
                        this.channel = 1;
                        this.slot = 0;
                        this.name = this.name + "B1";
                        break;
                    }
                    case 3: {
                        this.channel = 1;
                        this.slot = 1;
                        this.name = this.name + "B2";
                        break;
                    }
                    case 4: {
                        this.channel = 2;
                        this.slot = 0;
                        this.name = this.name + "C1";
                        break;
                    }
                    case 5: {
                        this.channel = 2;
                        this.slot = 1;
                        this.name = this.name + "C2";
                        break;
                    }
                    case 6: {
                        this.channel = 3;
                        this.slot = 0;
                        this.name = this.name + "D1";
                        break;
                    }
                    case 7: {
                        this.channel = 3;
                        this.slot = 1;
                        this.name = this.name + "D2";
                    }
                }
            } else {
                switch (bitIndex) {
                    case 0: {
                        this.channel = 4;
                        this.slot = 0;
                        this.name = this.name + "E1";
                        break;
                    }
                    case 1: {
                        this.channel = 4;
                        this.slot = 1;
                        this.name = this.name + "E2";
                        break;
                    }
                    case 2: {
                        this.channel = 5;
                        this.slot = 0;
                        this.name = this.name + "F1";
                        break;
                    }
                    case 3: {
                        this.channel = 5;
                        this.slot = 1;
                        this.name = this.name + "F2";
                        break;
                    }
                    case 4: {
                        this.channel = 6;
                        this.slot = 0;
                        this.name = this.name + "G1";
                        break;
                    }
                    case 5: {
                        this.channel = 6;
                        this.slot = 1;
                        this.name = this.name + "G2";
                        break;
                    }
                    case 6: {
                        this.channel = 7;
                        this.slot = 0;
                        this.name = this.name + "H1";
                        break;
                    }
                    case 7: {
                        this.channel = 7;
                        this.slot = 1;
                        this.name = this.name + "H2";
                    }
                }
            }
        }
    }
}

