/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCJVVideo;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.soc.SOCFrameHdr;
import com.ami.kvm.jviewer.soc.video.AVICA2AU;
import com.ami.kvm.jviewer.soc.video.ChangeRgns;
import com.ami.kvm.jviewer.soc.video.Region;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SOCJVVideo
implements ISOCJVVideo {
    public static final int MAX_X_RESOLUTION = 1800;
    public static final int MAX_Y_RESOLUTION = 1800;
    public static final short CAPTURE_FRAME_BIT = 1;
    public static final short CAPTURE_EVEN_FRAME = 0;
    public static final short CAPTURE_ODD_FRAME = 1;
    public static final short CAPTURE_CLEAR_BUFFER = 2;
    public static final short INIT_QLZW = 4;
    private JViewerView m_view;
    private ChangeRgns m_changeList;
    private short[][] m_screenBuf;
    private short[] m_alovicaBuf;
    private short[] p_scr1 = null;
    private short[] p_scr2 = null;
    private AVICA2AU m_AVICA;
    private boolean m_need_full_screen = true;
    private SOCFrameHdr m_frameHdr;

    @Override
    public void VideoBuffer_Initialize() {
        this.m_view = JViewerApp.getInstance().getRCView();
        this.m_changeList = new ChangeRgns();
        this.m_screenBuf = new short[2][];
        this.m_screenBuf[0] = new short[3240000];
        this.m_screenBuf[1] = new short[3240000];
        this.m_alovicaBuf = this.imageMemory();
        Arrays.fill(this.m_alovicaBuf, (short)0);
        this.m_AVICA = new AVICA2AU();
    }

    public short[] imageMemory() {
        WritableRaster r = JViewerApp.getInstance().getPrepare_buf().getM_image().getRaster();
        DataBuffer buf = r.getDataBuffer();
        if (buf instanceof DataBufferUShort) {
            DataBufferUShort dbuf = (DataBufferUShort)buf;
            return dbuf.getData();
        }
        return null;
    }

    @Override
    public void Newframevalidate() {
        if (null == this.p_scr1 && null == this.p_scr2) {
            this.p_scr1 = this.m_screenBuf[0];
            this.p_scr2 = this.m_screenBuf[1];
            Arrays.fill(this.m_screenBuf[0], (short)0);
            Arrays.fill(this.m_screenBuf[1], (short)0);
        }
        if (0 != (this.m_frameHdr.flags & 2)) {
            Arrays.fill(this.m_screenBuf[0], (short)0);
            Arrays.fill(this.m_screenBuf[1], (short)0);
            Arrays.fill(this.m_alovicaBuf, (short)0);
            this.m_need_full_screen = false;
        }
        if (this.m_view.viewWidth() != SOCFrameHdr.resX || this.m_view.viewHeight() != this.m_frameHdr.resY) {
            this.onResolutionChange();
        }
        if (this.m_need_full_screen) {
            return;
        }
        if (0 == (this.m_frameHdr.flags & 1)) {
            this.p_scr1 = this.m_screenBuf[1];
            this.p_scr2 = this.m_screenBuf[0];
        } else {
            this.p_scr1 = this.m_screenBuf[0];
            this.p_scr2 = this.m_screenBuf[1];
        }
    }

    @Override
    public ByteBuffer decompressframe(ISOCFrameHdr m_frameHdr1, ByteBuffer frameByteBuf) {
        int diff = 0;
        diff = this.m_frameHdr.actresX - SOCFrameHdr.resX;
        try {
            this.m_AVICA.avica2a_uncompress_32(this.p_scr1, frameByteBuf, 13, this.m_frameHdr.frameSize, this.m_frameHdr.actresX, this.m_frameHdr.actresY, this.m_frameHdr.tHigh, this.p_scr2, this.m_alovicaBuf, this.m_changeList, diff);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Debug.out.println("ArrayIndexOutOfBoundsException caught during avica uncompress");
            this.m_changeList.clear();
            e.printStackTrace();
            this.m_need_full_screen = true;
            return null;
        }
        for (int i = 0; i < this.m_changeList.numRgn(); ++i) {
            Region rgn = this.m_changeList.getRgn(i);
            int rgnHeight = rgn.end + 1 > this.m_frameHdr.resY ? this.m_frameHdr.resY - rgn.start : rgn.end - rgn.start + 1;
            if (rgnHeight <= 0) continue;
            this.m_view.repaint(0, rgn.start, SOCFrameHdr.resX, rgnHeight);
        }
        this.m_changeList.clear();
        return frameByteBuf;
    }

    @Override
    public void SOC_Specific(ByteBuffer CompBuffer) {
    }

    @Override
    public void setframehdr(ISOCFrameHdr hdr) {
        this.m_frameHdr = (SOCFrameHdr)hdr;
    }

    public SOCFrameHdr getframehdr() {
        return this.m_frameHdr;
    }

    @Override
    public void SOCBlankscreen() {
    }

    @Override
    public void SOCreset() {
    }

    @Override
    public void soccompressionchange() {
    }

    public void onResolutionChange() {
        Debug.out.println("Resolution change " + SOCFrameHdr.resX + ":" + this.m_frameHdr.resY);
        JViewerApp.getInstance().getVidClnt().onResolutionChange();
        this.m_view.setRCView(SOCFrameHdr.resX, this.m_frameHdr.resY, this.m_frameHdr.getFrameType());
        this.m_alovicaBuf = this.imageMemory();
        System.gc();
        JViewerApp.getInstance().OnVideoRefreshRedirection();
    }
}

