/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.HeaderReader;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class NullReader
implements KVMReader {
    private KVMClient m_client;
    private ByteBuffer m_nullBuf;
    private int m_nullIx;
    private int m_readCnt;
    private int m_readSz;
    private int m_numRead;

    public NullReader(KVMClient client) {
        this.m_client = client;
        this.m_nullBuf = ByteBuffer.allocate(262144);
    }

    @Override
    public void initialize() {
        this.m_readSz = this.m_client.m_pktHdr.pktSize;
        this.m_numRead = this.m_client.m_pktHdr.status;
        this.m_nullIx = 0;
        this.m_readCnt = 0;
        this.m_nullBuf.position(0);
        this.m_nullBuf.limit(this.m_readSz);
        this.m_client.onStartReading();
    }

    @Override
    public int read(Socket sockCh) {
        try {
            byte[] read_frameByteBuf = new byte[this.m_nullBuf.remaining()];
            this.m_nullIx = this.m_client.read_data(sockCh, read_frameByteBuf);
            this.m_nullBuf.put(read_frameByteBuf);
        }
        catch (Exception e) {
            Debug.out.println("CTRL_RDR " + e);
            return -1;
        }
        try {
            if (this.m_readSz <= this.m_nullIx) {
                ++this.m_readCnt;
                if (this.m_numRead <= this.m_readCnt) {
                    this.m_client.onStopReading();
                    HeaderReader reader = this.m_client.getHdrReader();
                    reader.initialize();
                    this.m_client.setState(reader);
                } else {
                    this.m_nullIx = 0;
                    this.m_nullBuf.position(0);
                }
            }
        }
        catch (Exception e) {
            Debug.out.println("CTRL_RDR[2] " + e);
            return -2;
        }
        return 0;
    }
}

