/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.FragReader;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FragNumReader
implements KVMReader {
    private KVMClient m_client;
    private ByteBuffer m_fragNumBuf;
    private int m_fragNumIx;

    public FragNumReader(KVMClient client) {
        this.m_client = client;
        this.m_fragNumBuf = ByteBuffer.allocate(2);
        this.m_fragNumBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_fragNumIx = 0;
    }

    @Override
    public void initialize() {
        this.m_fragNumIx = 0;
        this.m_fragNumBuf.clear();
    }

    @Override
    public int read(Socket sockCh) {
        try {
            byte[] read_fragNumBuf = new byte[this.m_fragNumBuf.remaining()];
            this.m_fragNumIx = this.m_client.read_data(sockCh, read_fragNumBuf);
            this.m_fragNumBuf.put(read_fragNumBuf);
            if (2 <= this.m_fragNumIx) {
                this.m_client.m_fragNum = this.m_fragNumBuf.getShort(0);
                FragReader reader = this.m_client.getFragReader();
                reader.initialize();
                this.m_client.setState(reader);
            }
        }
        catch (Exception e) {
            Debug.out.println("ON_READ_FRAG_SZ " + e);
            return -1;
        }
        return 0;
    }
}

