/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CfgBandwidth {
    public static final int BANDWIDTH_100MBPS = 0xC80000;
    public static final int BANDWIDTH_10MBPS = 0x140000;
    public static final int BANDWIDTH_1MBPS = 131072;
    public static final int BANDWIDTH_512KBPS = 65536;
    public static final int BANDWIDTH_256KBPS = 32768;
    public static final int CFG_BANDWIDTH_SIZE = 4;
    public IVTPPktHdr m_vHdr;
    public int m_bandwidth;
    ByteBuffer m_repBuf;
    private byte[] m_report;

    public CfgBandwidth(int bandwidth) {
        this.m_bandwidth = bandwidth;
        this.m_report = new byte[12];
        this.m_vHdr = new IVTPPktHdr(2, 4, 0);
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.limit(this.m_report.length);
    }

    public int size() {
        return 12;
    }

    public byte[] report() {
        this.m_repBuf.position(0);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.putInt(this.m_bandwidth);
        return this.m_report;
    }

    public static int determineBandwidth(long tims) {
        double tis = (double)tims / 1000.0;
        double bps = 1.31072E7 / tis;
        Debug.out.println("bps " + bps);
        if (bps < 49152.0) {
            return 32768;
        }
        if (bps < 98304.0) {
            return 65536;
        }
        if (bps < 720896.0) {
            return 131072;
        }
        if (bps < 7208960.0) {
            return 0x140000;
        }
        return 0xC80000;
    }
}

