/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBMessage;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KMCrypt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class USBKeyboardRep
extends USBMessage {
    private int keyCode;
    private int keyLocation;
    private boolean keyPress;
    private byte[] m_report;
    private byte[] m_encReport;
    private ByteBuffer m_repBuf;
    private KeyProcessor m_USBKeyProcessor;
    public boolean KeyBoardDataNull;
    static int SeqNum = 0;

    public USBKeyboardRep() {
        this(0, 0, true);
    }

    public USBKeyboardRep(int keyCode, int keyLocation, boolean keyPress) {
        this.m_vHdr = new IVTPPktHdr(1, 41, 0);
        this.m_devType = (byte)48;
        this.m_protocol = (byte)16;
        this.m_dataLen = 8;
        this.m_report = new byte[49];
        this.m_encReport = new byte[49];
    }

    public void set(int keyCode, int keyLocation, boolean keyPress) {
        this.keyCode = keyCode;
        this.keyLocation = keyLocation;
        this.keyPress = keyPress;
    }

    @Override
    public byte[] report() {
        byte[] keybd_report_data;
        int DataPktLen = 9;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        this.m_vHdr.setSize(41);
        this.m_vHdr.setStatus((short)0);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(DataPktLen);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)48);
        this.m_repBuf.put((byte)16);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)8);
        if (this.m_USBKeyProcessor == null) {
            this.m_USBKeyProcessor = JViewerApp.getInstance().getKeyprocesssor();
        }
        if ((keybd_report_data = this.m_USBKeyProcessor.convertKeyCode(this.keyCode, this.keyLocation, this.keyPress)) == null) {
            this.m_repBuf.put(new byte[6]);
            this.KeyBoardDataNull = true;
        } else {
            this.m_repBuf.put(keybd_report_data);
        }
        int temp = 0;
        for (int i = 8; i < 40; ++i) {
            temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(19, -((byte)(temp & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    @Override
    public byte[] encryptedReport(KMCrypt crypt) {
        int DataPktLen = 9;
        this.m_repBuf = ByteBuffer.wrap(this.m_encReport);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        this.m_vHdr.setSize(41);
        this.m_vHdr.setStatus((short)255);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(DataPktLen);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)48);
        this.m_repBuf.put((byte)16);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)8);
        byte[] keybd_report_data = this.m_USBKeyProcessor.convertKeyCode(this.keyCode, this.keyLocation, this.keyPress);
        if (keybd_report_data == null) {
            return this.report();
        }
        byte[] crypt_data = crypt.encrypt(keybd_report_data);
        if (crypt_data == null) {
            return this.report();
        }
        this.m_repBuf.put(crypt_data);
        int temp = 0;
        for (int i = 8; i < 40; ++i) {
            temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(19, -((byte)(temp & 0xFF)));
        ++SeqNum;
        return this.m_encReport;
    }

    public void setAutoKeybreakMode(boolean state) {
        this.m_USBKeyProcessor.setAutoKeybreakMode(state);
    }

    public boolean getAutoKeybreakMode() {
        return this.m_USBKeyProcessor.getAutoKeybreakMode();
    }

    public KeyProcessor getM_USBKeyProcessor() {
        return this.m_USBKeyProcessor;
    }

    public void setM_USBKeyProcessor(KeyProcessor keyProcessor) {
        this.m_USBKeyProcessor = keyProcessor;
    }
}

