/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.DevicePanel;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class vMediaDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    DevicePanel[] cdromDevTable;
    DevicePanel[] floppyDevTable;
    DevicePanel[] HarddiskDevTable;
    JTable statusTable;
    JButton[] floppyButton;
    JButton[] cdromButton;
    JButton[] harddiskButton;
    JButton helpButton;
    JButton exitButton;
    private JPanel tablePanel;
    private JPanel dialogPanel;
    private Timer m_updateTimer;
    IUSBRedirSession m_vMediaSession;
    String m_hostIp;
    String m_sessToken;
    int m_cdPort;
    int m_fdPort;
    int m_hdPort;
    int m_numcd;
    int m_numfd;
    int m_numhd;
    int m_cdStatus;
    int m_fdStatus;
    int m_hdStatus;
    boolean m_useSSL;

    public vMediaDialog(JFrame parent_frame, IUSBRedirSession vMediaSession, String hostIp, int cdPort, int fdPort, int hdPort, int cdnum, int fdnum, int hdnum, int cdStatus, int fdStatus, int hdStatus, boolean useSSL, String sessToken) {
        super(parent_frame, "Virtual Media", true);
        int k;
        String t_data;
        int table_row;
        this.m_vMediaSession = vMediaSession;
        this.m_hostIp = hostIp;
        this.m_cdPort = cdPort;
        this.m_fdPort = fdPort;
        this.m_hdPort = hdPort;
        this.m_numcd = cdnum;
        this.m_numfd = fdnum;
        this.m_numhd = hdnum;
        this.m_useSSL = useSSL;
        this.m_cdStatus = cdStatus;
        this.m_fdStatus = fdStatus;
        this.m_hdStatus = hdStatus;
        this.m_sessToken = sessToken;
        this.cdromDevTable = new DevicePanel[this.m_numcd];
        this.floppyDevTable = new DevicePanel[this.m_numfd];
        this.HarddiskDevTable = new DevicePanel[this.m_numhd];
        this.cdromButton = new JButton[this.m_numcd];
        this.floppyButton = new JButton[this.m_numfd];
        this.harddiskButton = new JButton[this.m_numhd];
        ButtonListener cmdListener = new ButtonListener();
        JLabel[] floppyLabel = new JLabel[this.m_numfd];
        JLabel[] harddiskLabel = new JLabel[this.m_numhd];
        JLabel[] cdromLabel = new JLabel[this.m_numcd];
        JLabel statusLabel = new JLabel("Status");
        Object[][] tableData = new Object[][]{{"Virtual Floppy", "Not connected", "n/a"}, {"Virtual CD", "Not connected", "n/a"}, {"Virtual HardDisk", "Not connected", "n/a"}};
        int totaldevice = this.m_numfd + this.m_numhd + this.m_numcd;
        Object[][] NewtableData = new String[totaldevice][3];
        Object[] columnNames = new String[]{"Target Drive", "Connected To", "Read Bytes"};
        for (int dev_fdno = 0; dev_fdno < this.m_numfd; ++dev_fdno) {
            for (table_row = 0; table_row < 3; ++table_row) {
                if (table_row == 0) {
                    NewtableData[dev_fdno][table_row] = t_data = (String)tableData[0][0];
                    NewtableData[dev_fdno][table_row] = ((String)NewtableData[dev_fdno][table_row]).concat(" " + (dev_fdno + 1));
                    continue;
                }
                NewtableData[dev_fdno][table_row] = (String)tableData[0][table_row];
            }
        }
        for (int dev_cdno = 0; dev_cdno < this.m_numcd; ++dev_cdno) {
            for (table_row = 0; table_row < 3; ++table_row) {
                if (table_row == 0) {
                    t_data = (String)tableData[1][0];
                    NewtableData[dev_cdno + this.m_numfd][table_row] = t_data;
                    NewtableData[dev_cdno + this.m_numfd][table_row] = ((String)NewtableData[dev_cdno + this.m_numfd][table_row]).concat(" " + (dev_cdno + 1));
                    continue;
                }
                NewtableData[dev_cdno + this.m_numfd][table_row] = (String)tableData[1][table_row];
            }
        }
        for (int dev_hdno = 0; dev_hdno < JViewerApp.getInstance().getM_hdNum(); ++dev_hdno) {
            for (table_row = 0; table_row < 3; ++table_row) {
                if (table_row == 0) {
                    t_data = (String)tableData[2][0];
                    NewtableData[dev_hdno + this.m_numfd + this.m_numcd][table_row] = t_data;
                    NewtableData[dev_hdno + this.m_numfd + this.m_numcd][table_row] = ((String)NewtableData[dev_hdno + this.m_numfd + this.m_numcd][table_row]).concat(" " + (dev_hdno + 1));
                    continue;
                }
                NewtableData[dev_hdno + this.m_numfd + this.m_numcd][table_row] = (String)tableData[2][table_row];
            }
        }
        this.statusTable = new JTable(NewtableData, columnNames){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.statusTable.setShowGrid(false);
        this.statusTable.setCellSelectionEnabled(false);
        this.statusTable.setCellEditor(null);
        this.statusTable.setEnabled(false);
        JScrollPane statusScrollPane = new JScrollPane(this.statusTable);
        this.helpButton = new JButton("Help");
        this.exitButton = new JButton("Close");
        this.exitButton.addActionListener(cmdListener);
        JScrollPane[] scrollCdromList = new JScrollPane[this.m_numcd];
        JScrollPane[] scrollFloppyList = new JScrollPane[this.m_numfd];
        JScrollPane[] scrollHarddiskList = new JScrollPane[this.m_numhd];
        int setboundy = 10;
        this.tablePanel = new JPanel();
        this.tablePanel.setAutoscrolls(true);
        this.tablePanel.setLayout(null);
        String[] floppyList = this.getFloppyList();
        JPanel[] floppyPanel = new JPanel[this.m_numfd];
        for (int i = 0; i < this.m_numfd; ++i) {
            this.floppyButton[i] = new JButton("Connect Floppy" + (i + 1));
            this.floppyButton[i].addActionListener(cmdListener);
            this.floppyDevTable[i] = new DevicePanel(floppyList, 1);
            this.floppyDevTable[i].m_browseButton.addActionListener(cmdListener);
            scrollFloppyList[i] = new JScrollPane(this.floppyDevTable[i]);
            floppyPanel[i] = new JPanel();
            floppyPanel[i].setLayout(new BorderLayout(2, 2));
            floppyLabel[i] = new JLabel("Floppy Key Media" + (i + 1));
            floppyPanel[i].add((Component)floppyLabel[i], "North");
            floppyPanel[i].add((Component)scrollFloppyList[i], "Center");
            floppyPanel[i].setBounds(10, setboundy, 475, 100);
            this.floppyButton[i].setBounds(500, setboundy + 20, 210, 25);
            this.tablePanel.add(floppyPanel[i]);
            this.tablePanel.add(this.floppyButton[i]);
            setboundy += 120;
            this.updateFloppyRedirStatus(i);
            this.updateFloppyRedirStatus_another(i, false);
        }
        String[] cdromList = this.getCDROMList();
        JPanel[] cdromPanel = new JPanel[this.m_numcd];
        for (int i = 0; i < this.m_numcd; ++i) {
            this.cdromButton[i] = new JButton("Connect CD/DVD" + i);
            this.cdromButton[i].addActionListener(cmdListener);
            this.cdromDevTable[i] = new DevicePanel(cdromList, 0);
            this.cdromDevTable[i].m_browseButton.addActionListener(cmdListener);
            scrollCdromList[i] = new JScrollPane(this.cdromDevTable[i]);
            cdromPanel[i] = new JPanel();
            cdromPanel[i].setLayout(new BorderLayout(2, 2));
            cdromLabel[i] = new JLabel("CD/DVD Media" + (i + 1));
            cdromPanel[i].add((Component)cdromLabel[i], "North");
            cdromPanel[i].add((Component)scrollCdromList[i], "Center");
            cdromPanel[i].setBounds(10, setboundy, 475, 100);
            this.cdromButton[i].setBounds(500, setboundy + 20, 210, 25);
            this.tablePanel.add(this.cdromButton[i]);
            this.tablePanel.add(cdromPanel[i]);
            setboundy += 120;
            this.updateCDROMRedirStatus(i);
        }
        String[] harddiskList_Removable = this.getUSBHDDList();
        String[] harddiskList_Fixed = this.getHarddiskFixedList();
        String[] harddiskList = null;
        int i = 0;
        if (harddiskList_Removable != null || harddiskList_Fixed != null) {
            int deviceLen = 0;
            if (harddiskList_Removable != null) {
                deviceLen += harddiskList_Removable.length;
            }
            if (harddiskList_Fixed != null) {
                deviceLen += harddiskList_Fixed.length;
            }
            harddiskList = new String[deviceLen];
            if (harddiskList_Removable != null) {
                for (k = 0; k < harddiskList_Removable.length; ++k) {
                    harddiskList[i] = harddiskList_Removable[k];
                    harddiskList[i] = harddiskList[i].concat(" - USB");
                    ++i;
                }
            }
            if (harddiskList_Fixed != null) {
                int j = 0;
                while (j < harddiskList_Fixed.length) {
                    harddiskList[i] = harddiskList_Fixed[j];
                    harddiskList[i] = harddiskList[i].concat(" - Fixed Drive");
                    ++j;
                    ++i;
                }
            }
        }
        JPanel[] harddiskPanel = new JPanel[this.m_numhd];
        for (k = 0; k < hdnum; ++k) {
            this.harddiskButton[k] = new JButton("Connect Hard disk/USB Key" + k);
            this.harddiskButton[k].addActionListener(cmdListener);
            this.HarddiskDevTable[k] = new DevicePanel(harddiskList, 2);
            this.HarddiskDevTable[k].m_browseButton.addActionListener(cmdListener);
            scrollHarddiskList[k] = new JScrollPane(this.HarddiskDevTable[k]);
            harddiskPanel[k] = new JPanel();
            harddiskPanel[k].setLayout(new BorderLayout(2, 2));
            harddiskLabel[k] = new JLabel("Hard disk/USB Key Media" + (k + 1));
            harddiskPanel[k].add((Component)harddiskLabel[k], "North");
            harddiskPanel[k].add((Component)scrollHarddiskList[k], "Center");
            harddiskPanel[k].setBounds(10, setboundy, 475, 100);
            this.harddiskButton[k].setBounds(500, setboundy + 20, 210, 25);
            this.tablePanel.add(harddiskPanel[k]);
            this.tablePanel.add(this.harddiskButton[k]);
            setboundy += 120;
            this.updateharddiskRedirStatus(k);
        }
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout(2, 2));
        statusPanel.add((Component)statusLabel, "North");
        statusPanel.add((Component)statusScrollPane, "Center");
        this.setBackground(Color.WHITE);
        statusPanel.setBounds(10, setboundy, 475, 100);
        this.exitButton.setBounds(500, setboundy + 75, 130, 25);
        this.tablePanel.setSize(750, 520);
        this.tablePanel.add(this.exitButton);
        this.tablePanel.add(statusPanel);
        this.dialogPanel = new JPanel();
        this.dialogPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.setLocation(100, 100);
        JScrollPane scrollPane = new JScrollPane(this.tablePanel, 20, 30);
        this.dialogPanel.add(scrollPane);
        this.tablePanel.setPreferredSize(new Dimension(700, setboundy + 125));
        scrollPane.setMinimumSize(new Dimension(700, 550));
        this.setSize(750, 550);
        this.setLocationRelativeTo(null);
        this.m_updateTimer = new Timer();
        this.m_updateTimer.schedule((TimerTask)new UpdateReadBytesTask(), 0L, 1000L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                vMediaDialog.this.m_updateTimer.cancel();
            }
        });
    }

    public void DisplayDialog() {
        this.setVisible(true);
    }

    public String[] getCDROMList() {
        String[] cdromList = null;
        try {
            CDROMRedir cdromObj = new CDROMRedir(true);
            cdromList = cdromObj.getCDROMList();
            System.gc();
        }
        catch (RedirectionException e) {
            Debug.out.println("Exception occured while getCDROMList()");
        }
        return cdromList;
    }

    public String[] getFloppyList() {
        String[] floppyList = null;
        FloppyRedir floppyObj = new FloppyRedir(true);
        floppyList = floppyObj.getFloppyList();
        System.gc();
        return floppyList;
    }

    public String[] getUSBHDDList() {
        String[] hardDiskList = null;
        HarddiskRedir harddiskObj = new HarddiskRedir(true);
        hardDiskList = harddiskObj.getUSBHDDList();
        System.gc();
        return hardDiskList;
    }

    public String[] getHarddiskFixedList() {
        String[] hardDiskList = null;
        HarddiskRedir harddiskObj = new HarddiskRedir(true);
        hardDiskList = harddiskObj.getHarddiskFixedList();
        System.gc();
        return hardDiskList;
    }

    public String[] getEntireHarddiskList() {
        String[] hardDiskList = null;
        HarddiskRedir harddiskObj = new HarddiskRedir(true);
        hardDiskList = harddiskObj.getEntireHarddiskList();
        System.gc();
        return hardDiskList;
    }

    public void disableAllControls() {
        for (int numcd = 0; numcd < this.m_numcd; ++numcd) {
            this.cdromDevTable[numcd].setEnabled(false);
            this.cdromButton[numcd].setEnabled(false);
        }
        for (int numfd = 0; numfd < this.m_numfd; ++numfd) {
            this.floppyDevTable[numfd].setEnabled(false);
            this.floppyButton[numfd].setEnabled(false);
        }
        for (int numhd = 0; numhd < JViewerApp.getInstance().getM_hdNum(); ++numhd) {
            this.HarddiskDevTable[numhd].setEnabled(false);
            this.harddiskButton[numhd].setEnabled(false);
        }
        this.exitButton.setEnabled(false);
    }

    public void enableAllControls() {
        for (int numcd = 0; numcd < this.m_numcd; ++numcd) {
            this.cdromDevTable[numcd].enableAll();
            this.cdromButton[numcd].setEnabled(true);
        }
        for (int numfd = 0; numfd < this.m_numfd; ++numfd) {
            this.floppyDevTable[numfd].enableAll();
            this.floppyButton[numfd].setEnabled(true);
        }
        for (int numhd = 0; numhd < JViewerApp.getInstance().getM_hdNum(); ++numhd) {
            this.HarddiskDevTable[numhd].enableAll();
            this.harddiskButton[numhd].setEnabled(true);
        }
        this.exitButton.setEnabled(true);
    }

    public void updateCDROMRedirStatus(int device_no) {
        if (this.m_vMediaSession.getCDROMRedirStatus(device_no) == 1) {
            this.cdromDevTable[device_no].disableAll();
            this.cdromButton[device_no].setText("Disconnect");
            this.cdromDevTable[device_no].SelectRadioButton(this.m_vMediaSession.getCDROMSource(device_no));
            this.statusTable.setValueAt(this.m_vMediaSession.getCDROMSource(device_no), device_no + this.m_numfd, 1);
            int count = this.cdromDevTable[device_no].m_imagePath.getItemCount();
            int Ret = -1;
            for (int s = 0; s < count; ++s) {
                String Item = (String)this.cdromDevTable[device_no].m_imagePath.getItemAt(s);
                if (Item != null) {
                    Ret = Item.compareTo(this.m_vMediaSession.getCDROMSource(device_no));
                }
                if (Ret == 0) break;
            }
            if (Ret != 0 && !this.m_vMediaSession.getCdromSession(device_no).isPhysicalDevice()) {
                this.cdromDevTable[device_no].m_imagePath.insertItemAt(this.m_vMediaSession.getCDROMSource(device_no), 0);
                this.cdromDevTable[device_no].m_imagePath.setSelectedItem(this.m_vMediaSession.getCDROMSource(device_no));
            }
        } else {
            this.cdromDevTable[device_no].enableAll();
            this.updateCDROMRedirStatus_another(device_no, false);
            this.cdromButton[device_no].setText("Connect CD/DVD");
            this.statusTable.setValueAt("Not connected", device_no + this.m_numfd, 1);
            this.statusTable.setValueAt("n/a", device_no + this.m_numfd, 2);
            for (int i = 0; i < this.m_numcd; ++i) {
                URL imageCDR;
                if (this.m_vMediaSession.getCDROMRedirStatus(i) == 1) {
                    imageCDR = JViewer.class.getResource("res/CDR.png");
                    JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setIcon(new ImageIcon(imageCDR));
                    JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setToolTipText(" CD ROM is  Connected to the session");
                    break;
                }
                imageCDR = JViewer.class.getResource("res/CD.png");
                JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setIcon(new ImageIcon(imageCDR));
                JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setToolTipText(" CD ROM is not Connected to the session");
            }
        }
    }

    public void updateFloppyRedirStatus(int device_no) {
        if (this.m_vMediaSession.getFloppyRedirStatus(device_no) == 1) {
            this.floppyDevTable[device_no].disableAll();
            this.floppyButton[device_no].setText("Disconnect");
            this.floppyDevTable[device_no].SelectRadioButton(this.m_vMediaSession.getFloppySource(device_no));
            this.statusTable.setValueAt(this.m_vMediaSession.getFloppySource(device_no), device_no, 1);
            this.statusTable.repaint();
            int count = this.floppyDevTable[device_no].m_imagePath.getItemCount();
            int Ret = -1;
            for (int s = 0; s < count; ++s) {
                String Item = (String)this.floppyDevTable[device_no].m_imagePath.getItemAt(s);
                if (Item != null) {
                    Ret = Item.compareTo(this.m_vMediaSession.getFloppySource(device_no));
                }
                if (Ret == 0) break;
            }
            if (Ret != 0 && !this.m_vMediaSession.getFloppySession(device_no).isPhysicalDevice()) {
                this.floppyDevTable[device_no].m_imagePath.insertItemAt(this.m_vMediaSession.getFloppySource(device_no), 0);
                this.floppyDevTable[device_no].m_imagePath.setSelectedItem(this.m_vMediaSession.getFloppySource(device_no));
            }
        } else {
            this.floppyDevTable[device_no].enableAll();
            this.updateFloppyRedirStatus_another(device_no, false);
            this.floppyButton[device_no].setText("Connect Floppy");
            this.statusTable.setValueAt("Not connected", device_no, 1);
            this.statusTable.setValueAt("n/a", device_no, 2);
            for (int i = 0; i < this.m_numfd; ++i) {
                if (this.m_vMediaSession.getFloppyRedirStatus(i) == 1) {
                    URL imageFDR = JViewer.class.getResource("res/FloppyR.png");
                    JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setIcon(new ImageIcon(imageFDR));
                    JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setToolTipText(" Floppy is  Connected to the session");
                    break;
                }
                URL imageFD = JViewer.class.getResource("res/Floppy.png");
                JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setIcon(new ImageIcon(imageFD));
                JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setToolTipText(" Floppy is not Connected to the session");
            }
        }
    }

    public void updateFloppyRedirStatus_another(int device_no, boolean state) {
        String[] redirecteddrive = new String[this.m_numfd];
        for (int h = 0; h < this.m_numfd; ++h) {
            if (this.m_vMediaSession.getFloppyRedirStatus(h) != 1) continue;
            redirecteddrive[h] = this.m_vMediaSession.getFloppySource(h);
        }
        for (int g = 0; g < redirecteddrive.length; ++g) {
            if (redirecteddrive[g] == null && state) continue;
            this.floppyDevTable[device_no].SelectRadioButton_StateChange(redirecteddrive[g], state);
        }
    }

    public void updateFloppyRedirStatus_Enable(String drive, boolean state) {
        for (int g = 0; g < this.m_numfd; ++g) {
            if (this.m_vMediaSession.getFloppyRedirStatus(g) != 0) continue;
            this.floppyDevTable[g].SelectRadioButton_StateChange(drive, state);
        }
    }

    public void updateharddiskRedirStatus_another(int device_no, boolean state) {
        String[] redirecteddrive = new String[this.m_numhd];
        for (int h = 0; h < this.m_numhd; ++h) {
            if (this.m_vMediaSession.getHarddiskRedirStatus(h) != 1) continue;
            redirecteddrive[h] = this.m_vMediaSession.getharddiskSource(h);
        }
        for (int g = 0; g < redirecteddrive.length; ++g) {
            if (redirecteddrive[g] == null && state) continue;
            this.HarddiskDevTable[device_no].SelectRadioButton_StateChange(redirecteddrive[g], state);
        }
    }

    public void updateharddiskRedirStatus_Enable(String drive, boolean state) {
        for (int g = 0; g < this.m_numhd; ++g) {
            if (this.m_vMediaSession.getHarddiskRedirStatus(g) != 0) continue;
            this.HarddiskDevTable[g].SelectRadioButton_StateChange(drive, state);
        }
    }

    public void updateCDROMRedirStatus_another(int device_no, boolean state) {
        String[] redirecteddrive = new String[this.m_numcd];
        for (int h = 0; h < this.m_numcd; ++h) {
            if (this.m_vMediaSession.getCDROMRedirStatus(h) != 1) continue;
            redirecteddrive[h] = this.m_vMediaSession.getCDROMSource(h);
        }
        for (int g = 0; g < redirecteddrive.length; ++g) {
            if (redirecteddrive[g] == null && state) continue;
            this.cdromDevTable[device_no].SelectRadioButton_StateChange(redirecteddrive[g], state);
        }
    }

    public void updateCDROMRedirStatus_Enable(String drive, boolean state) {
        for (int g = 0; g < this.m_numcd; ++g) {
            if (this.m_vMediaSession.getCDROMRedirStatus(g) != 0) continue;
            this.cdromDevTable[g].SelectRadioButton_StateChange(drive, state);
        }
    }

    public void updateharddiskRedirStatus(int device_no) {
        if (this.m_vMediaSession.getHarddiskRedirStatus(device_no) == 1) {
            this.HarddiskDevTable[device_no].disableAll();
            this.harddiskButton[device_no].setText("Disconnect");
            this.HarddiskDevTable[device_no].SelectRadioButton(this.m_vMediaSession.getharddiskSource(device_no));
            this.statusTable.setValueAt(this.m_vMediaSession.getharddiskSource(device_no), device_no + this.m_numfd + this.m_numcd, 1);
            int count = this.HarddiskDevTable[device_no].m_imagePath.getItemCount();
            int Ret = -1;
            for (int s = 0; s < count; ++s) {
                String Item = (String)this.HarddiskDevTable[device_no].m_imagePath.getItemAt(s);
                if (Item != null) {
                    Ret = Item.compareTo(this.m_vMediaSession.getharddiskSource(device_no));
                }
                if (Ret == 0) break;
            }
            if (Ret != 0 && !this.m_vMediaSession.getHarddiskSession(device_no).isPhysicalDevice()) {
                this.HarddiskDevTable[device_no].m_imagePath.insertItemAt(this.m_vMediaSession.getharddiskSource(device_no), 0);
                this.HarddiskDevTable[device_no].m_imagePath.setSelectedItem(this.m_vMediaSession.getharddiskSource(device_no));
            }
        } else {
            this.HarddiskDevTable[device_no].enableAll();
            this.updateharddiskRedirStatus_another(device_no, false);
            this.harddiskButton[device_no].setText("Connect Hard disk/USB Key");
            this.statusTable.setValueAt("Not connected", device_no + this.m_numfd + this.m_numcd, 1);
            this.statusTable.setValueAt("n/a", device_no + this.m_numfd + this.m_numcd, 2);
            for (int i = 0; i < this.m_numhd; ++i) {
                URL imageHDDR;
                if (this.m_vMediaSession.getHarddiskRedirStatus(i) == 1) {
                    imageHDDR = JViewer.class.getResource("res/HDR.png");
                    JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setIcon(new ImageIcon(imageHDDR));
                    JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setToolTipText(" Hard disk/USB Redirection is Connected to the session");
                    break;
                }
                imageHDDR = JViewer.class.getResource("res/HD.png");
                JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setIcon(new ImageIcon(imageHDDR));
                JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setToolTipText(" Hard disk/USB Redirection is not Connected to the session");
            }
        }
    }

    public void updateReadBytes() {
        int l;
        for (l = 0; l < this.m_numfd; ++l) {
            if (this.m_vMediaSession.getFloppyRedirStatus(l) != 1) continue;
            this.statusTable.setValueAt(this.m_vMediaSession.getFloppyReadBytes(l) + " KB", l, 2);
        }
        for (l = 0; l < this.m_numcd; ++l) {
            if (this.m_vMediaSession.getCDROMRedirStatus(l) != 1) continue;
            this.statusTable.setValueAt(this.m_vMediaSession.getCDROMReadBytes(l) + " KB", l + this.m_numfd, 2);
        }
        for (l = 0; l < JViewerApp.getInstance().getM_hdNum(); ++l) {
            if (this.m_vMediaSession.getHarddiskRedirStatus(l) != 1) continue;
            this.statusTable.setValueAt(this.m_vMediaSession.getHarddiskReadBytes(l) + " KB", l + this.m_numfd + this.m_numcd, 2);
        }
    }

    public JPanel getDialogPanel() {
        return this.dialogPanel;
    }

    public void setDialogPanel(JPanel dialogPanel) {
        this.dialogPanel = dialogPanel;
    }

    public JPanel getTablePanel() {
        return this.tablePanel;
    }

    public void setTablePanel(JPanel tablePanel) {
        this.tablePanel = tablePanel;
    }

    public byte OngetMediatype(String string) {
        int Mediatype;
        block4: {
            String[] List_drive;
            block5: {
                Mediatype = 0;
                if (string == null) break block4;
                List_drive = this.getEntireHarddiskList();
                if (!System.getProperty("os.name").startsWith("Win")) break block5;
                String Physicaldriveno = string.substring(13, 14);
                int redirectedDrive = Integer.parseInt(Physicaldriveno);
                for (int i = 0; i < List_drive.length; ++i) {
                    String Drive = List_drive[i];
                    String Drive_no = Drive.substring(0, 1);
                    int driveno = Integer.parseInt(Drive_no);
                    if (driveno != redirectedDrive) continue;
                    String DriveType = Drive.substring(1, 2);
                    int drivetype = Integer.parseInt(DriveType);
                    if (drivetype == 3) {
                        Mediatype = 0;
                        continue;
                    }
                    if (drivetype != 2) continue;
                    Mediatype = -128;
                }
                break block4;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block4;
            for (int i = 0; i < List_drive.length; ++i) {
                String Drive = List_drive[i];
                String Drive_name = Drive.substring(0, Drive.length() - 1);
                String[] redirectedDrive = string.split("-");
                String drivename = redirectedDrive[0].trim();
                System.out.println("string::" + string + "Drive_name::" + Drive_name);
                System.out.println("COMPARED::" + Drive_name.compareTo(drivename));
                if (Drive_name.compareTo(drivename) != 0) continue;
                String DriveType = Drive.substring(Drive.length() - 1, Drive.length());
                int drivetype = Integer.parseInt(DriveType);
                if (drivetype == 0) {
                    Mediatype = 0;
                    continue;
                }
                if (drivetype != 1) continue;
                Mediatype = -128;
            }
        }
        return (byte)Mediatype;
    }

    class UpdateReadBytesTask
    extends TimerTask {
        UpdateReadBytesTask() {
        }

        @Override
        public void run() {
            vMediaDialog.this.updateReadBytes();
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int j;
            String imagePath;
            int k;
            Object actionObj = e.getSource();
            if (actionObj == vMediaDialog.this.exitButton) {
                vMediaDialog.this.m_updateTimer.cancel();
                if (JViewer.isStandalone()) {
                    vMediaDialog.this.setVisible(false);
                } else {
                    JViewerApp.getInstance().mediaDlg.dispose();
                }
            }
            for (k = 0; k < vMediaDialog.this.m_numcd; ++k) {
                if (actionObj != vMediaDialog.this.cdromDevTable[k].m_browseButton) continue;
                if (vMediaDialog.this.cdromDevTable[k].getImagepathSelect() == null) {
                    vMediaDialog.this.cdromDevTable[k].setImagepathSelect(JViewerApp.Imagepath_CD[0]);
                }
                if ((imagePath = vMediaDialog.this.m_vMediaSession.isoImageSelector(vMediaDialog.this.cdromDevTable[k].getImagepathSelect())) == null) continue;
                vMediaDialog.this.cdromDevTable[k].setImagePath(imagePath, 1);
            }
            for (k = 0; k < vMediaDialog.this.m_numfd; ++k) {
                if (actionObj != vMediaDialog.this.floppyDevTable[k].m_browseButton) continue;
                if (vMediaDialog.this.floppyDevTable[k].getImagepathSelect() == null) {
                    vMediaDialog.this.floppyDevTable[k].setImagepathSelect(JViewerApp.Imagepath_Floppy[0]);
                }
                if ((imagePath = vMediaDialog.this.m_vMediaSession.floppyImageSelector(vMediaDialog.this.floppyDevTable[k].getImagepathSelect())) == null) continue;
                vMediaDialog.this.floppyDevTable[k].setImagePath(imagePath, 2);
            }
            for (k = 0; k < JViewerApp.getInstance().getM_hdNum(); ++k) {
                if (actionObj != vMediaDialog.this.HarddiskDevTable[k].m_browseButton) continue;
                if (vMediaDialog.this.HarddiskDevTable[k].getImagepathSelect() == null) {
                    vMediaDialog.this.HarddiskDevTable[k].setImagepathSelect(JViewerApp.Imagepath_Harddsik[0]);
                }
                if ((imagePath = vMediaDialog.this.m_vMediaSession.floppyImageSelector(vMediaDialog.this.HarddiskDevTable[k].getImagepathSelect())) == null) continue;
                vMediaDialog.this.HarddiskDevTable[k].setImagePath(imagePath, 2);
            }
            for (k = 0; k < vMediaDialog.this.m_numcd; ++k) {
                if (actionObj != vMediaDialog.this.cdromButton[k]) continue;
                if (JViewerApp.getInstance().getM_cdStatus() == 0) {
                    Debug.out.println("cdrom service disabled");
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", "CD-ROM Media redirection Service Disabled");
                    return;
                }
                if (vMediaDialog.this.m_vMediaSession.getCDROMRedirStatus(k) == 0) {
                    Debug.out.println("Starting cdrom redirection");
                    vMediaDialog.this.disableAllControls();
                    boolean bRet = false;
                    if (vMediaDialog.this.cdromDevTable[k].isImageSelected()) {
                        Debug.out.println("Starting ISO redirection " + vMediaDialog.this.cdromDevTable[k].getImagePath());
                        bRet = vMediaDialog.this.m_vMediaSession.StartISORedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_cdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.cdromDevTable[k].getImagePath());
                        if (bRet) {
                            vMediaDialog.this.cdromDevTable[k].saveImagepath(vMediaDialog.this.cdromDevTable[k].getImagePath(), 1);
                            vMediaDialog.this.m_vMediaSession.getCdromSession((int)k).ImageRedirectionCD = true;
                        }
                    } else {
                        Debug.out.println("Starting cdrom redirection " + vMediaDialog.this.cdromDevTable[k].selectedDeviceString());
                        bRet = vMediaDialog.this.m_vMediaSession.StartCDROMRedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_cdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.cdromDevTable[k].selectedDeviceString());
                        if (bRet) {
                            vMediaDialog.this.m_vMediaSession.getCdromSession((int)k).ImageRedirectionCD = false;
                        }
                    }
                    vMediaDialog.this.enableAllControls();
                    Debug.out.println("cdrom redirection should be running");
                    if (bRet) {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                            vMediaDialog.this.updateCDROMRedirStatus_another(j, false);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                        URL imageCDR = JViewer.class.getResource("res/CDR.png");
                        JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setIcon(new ImageIcon(imageCDR));
                        JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setToolTipText(" CD ROM is  Connected to the session");
                    } else {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                    }
                    for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                        vMediaDialog.this.updateCDROMRedirStatus_another(j, false);
                    }
                    Debug.out.println("after updating cdrom redirection status");
                    continue;
                }
                vMediaDialog.this.m_vMediaSession.getCdromSession((int)k).ImageRedirectionCD = false;
                String drive = vMediaDialog.this.cdromDevTable[k].selectedDeviceString();
                vMediaDialog.this.m_vMediaSession.StopCDROMRedir(k);
                vMediaDialog.this.updateCDROMRedirStatus(k);
                vMediaDialog.this.updateCDROMRedirStatus_Enable(drive, true);
            }
            for (k = 0; k < vMediaDialog.this.m_numfd; ++k) {
                if (actionObj != vMediaDialog.this.floppyButton[k]) continue;
                if (JViewerApp.getInstance().getM_fdStatus() == 0) {
                    Debug.out.println("Floppy service disabled");
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", "Floppy Media redirection Service Disabled");
                    return;
                }
                if (vMediaDialog.this.m_vMediaSession.getFloppyRedirStatus(k) == 0) {
                    Debug.out.println("Starting floppy redirection");
                    vMediaDialog.this.disableAllControls();
                    boolean bRet = false;
                    if (vMediaDialog.this.floppyDevTable[k].isImageSelected()) {
                        Debug.out.println("Starting floppy image redirection " + vMediaDialog.this.floppyDevTable[k].getImagePath());
                        bRet = vMediaDialog.this.m_vMediaSession.StartFloppyImageRedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_fdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.floppyDevTable[k].getImagePath());
                        if (bRet) {
                            vMediaDialog.this.floppyDevTable[k].saveImagepath(vMediaDialog.this.floppyDevTable[k].getImagePath(), 2);
                            vMediaDialog.this.m_vMediaSession.floppySession[k].ImageRedirectionfloppy = true;
                        }
                    } else {
                        Debug.out.println("Starting floppy redirection " + vMediaDialog.this.floppyDevTable[k].selectedDeviceString());
                        bRet = vMediaDialog.this.m_vMediaSession.StartFloppyRedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_fdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.floppyDevTable[k].selectedDeviceString());
                        if (bRet) {
                            vMediaDialog.this.m_vMediaSession.floppySession[k].ImageRedirectionfloppy = false;
                        }
                    }
                    vMediaDialog.this.enableAllControls();
                    Debug.out.println("floppy redirection should be running");
                    if (bRet) {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                            vMediaDialog.this.updateFloppyRedirStatus_another(j, false);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                        URL imageFDR = JViewer.class.getResource("res/FloppyR.png");
                        JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setIcon(new ImageIcon(imageFDR));
                        JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setToolTipText(" Floppy is  Connected to the session");
                    } else {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                    }
                    for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                        vMediaDialog.this.updateFloppyRedirStatus_another(j, false);
                    }
                    Debug.out.println("after updating floppy redirection status");
                    continue;
                }
                vMediaDialog.this.m_vMediaSession.floppySession[k].ImageRedirectionfloppy = false;
                String drive = vMediaDialog.this.floppyDevTable[k].selectedDeviceString();
                vMediaDialog.this.m_vMediaSession.StopFloppyRedir(k);
                vMediaDialog.this.updateFloppyRedirStatus(k);
                vMediaDialog.this.updateFloppyRedirStatus_Enable(drive, true);
            }
            for (k = 0; k < vMediaDialog.this.m_numhd; ++k) {
                if (actionObj != vMediaDialog.this.harddiskButton[k]) continue;
                if (JViewerApp.getInstance().getM_hdStatus() == 0) {
                    Debug.out.println("Harddisk service disabled");
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key", "Hard disk Media redirection Service Disabled");
                    return;
                }
                if (vMediaDialog.this.m_vMediaSession.getHarddiskRedirStatus(k) == 0) {
                    Debug.out.println("Starting floppy redirection");
                    vMediaDialog.this.disableAllControls();
                    boolean bRet = false;
                    if (vMediaDialog.this.HarddiskDevTable[k].isImageSelected()) {
                        Debug.out.println("Starting floppy image redirection " + vMediaDialog.this.HarddiskDevTable[k].getImagePath());
                        bRet = vMediaDialog.this.m_vMediaSession.StartharddiskImageRedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_hdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.HarddiskDevTable[k].getImagePath());
                        if (bRet) {
                            vMediaDialog.this.HarddiskDevTable[k].saveImagepath(vMediaDialog.this.HarddiskDevTable[k].getImagePath(), 3);
                            vMediaDialog.this.m_vMediaSession.harddiskSession[k].ImageRedirectionHD_USB = true;
                        }
                    } else {
                        Debug.out.println("Starting floppy redirection " + vMediaDialog.this.HarddiskDevTable[k].selectedDeviceString());
                        byte mediatype = vMediaDialog.this.OngetMediatype(vMediaDialog.this.HarddiskDevTable[k].selectedDeviceString());
                        bRet = vMediaDialog.this.m_vMediaSession.StartHarddiskRedir(vMediaDialog.this.m_sessToken, vMediaDialog.this.m_hdPort, k, vMediaDialog.this.m_useSSL, vMediaDialog.this.HarddiskDevTable[k].selectedDeviceString(), mediatype);
                        if (bRet) {
                            vMediaDialog.this.m_vMediaSession.harddiskSession[k].ImageRedirectionHD_USB = false;
                        }
                    }
                    vMediaDialog.this.enableAllControls();
                    Debug.out.println("floppy redirection should be running");
                    if (bRet) {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                        URL imageHDDR = JViewer.class.getResource("res/HDR.png");
                        JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setIcon(new ImageIcon(imageHDDR));
                        JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setToolTipText(" Hard disk/USB Redirection is  Connected to the session");
                    } else {
                        for (j = 0; j < vMediaDialog.this.m_numfd; ++j) {
                            vMediaDialog.this.updateFloppyRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numcd; ++j) {
                            vMediaDialog.this.updateCDROMRedirStatus(j);
                        }
                        for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                            vMediaDialog.this.updateharddiskRedirStatus(j);
                        }
                    }
                    for (j = 0; j < vMediaDialog.this.m_numhd; ++j) {
                        vMediaDialog.this.updateharddiskRedirStatus_another(j, false);
                    }
                    Debug.out.println("after updating floppy redirection status");
                    continue;
                }
                vMediaDialog.this.m_vMediaSession.harddiskSession[k].ImageRedirectionHD_USB = false;
                String drive = vMediaDialog.this.HarddiskDevTable[k].selectedDeviceString();
                vMediaDialog.this.m_vMediaSession.StopHarddiskRedir(k);
                vMediaDialog.this.updateharddiskRedirStatus(k);
                vMediaDialog.this.updateharddiskRedirStatus_Enable(drive, true);
            }
        }
    }
}

