/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JVStatusBar;
import com.ami.kvm.jviewer.gui.JVToolBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.Macrows;
import com.ami.kvm.jviewer.gui.RecorderToolBar;
import com.ami.kvm.jviewer.gui.WindowMenu;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WindowFrame
extends JVFrame {
    private WindowMenu m_menu;
    private JVStatusBar m_status;
    public Macrows macrows;
    public JVToolBar toolbar;
    private String m_label;

    public WindowFrame() {
        this.setTitle("KVM Remote Console");
        this.constructUserIf();
        this.setDefaultCloseOperation(0);
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    JViewerView.m_keyled_flag = false;
                    JViewerView.Lost_focus_flag = false;
                    if (JViewerApp.getInstance().GetRedirectionState() == JViewerApp.REDIR_STARTED) {
                        JViewerApp.getInstance().getKVMClient().sendLEDrequest();
                        if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() != USBMouseRep.INVALID_MOUSE_MODE) {
                            JViewerApp.getInstance().getRCView().USBsyncCursor(true);
                        }
                        if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                            Mousecaliberation.resetCursor();
                        }
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    JViewerView.m_keyled_flag = true;
                    JViewerView.Lost_focus_flag = true;
                    if (JViewerApp.getInstance().GetRedirectionState() == JViewerApp.REDIR_STARTED) {
                        JViewerApp.getInstance().getRCView().USBsyncCursor(false);
                    }
                }
            });
            JViewer.getMainFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    WindowFrame.this.windowClosed();
                }
            });
        } else {
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    if (!JViewer.isStandalone()) {
                        JViewer.getMainFrame().setJMenuBar(WindowFrame.this.m_menu.getMenuBar());
                    }
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    WindowFrame.this.windowClosed();
                }
            });
        }
    }

    @Override
    public JVMenu getMenu() {
        return this.m_menu;
    }

    @Override
    public void setStatus(String msg) {
        this.m_status.setStatus(msg);
    }

    @Override
    public void resetStatus() {
        this.m_status.resetStatus();
    }

    @Override
    public void exitApp() {
        this.windowClosed();
    }

    @Override
    public void refreshTitle() {
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().setTitle("JViewer[" + m_serverIP + "] - " + this.m_label);
        } else {
            this.setTitle("JViewer[" + m_serverIP + "] - " + this.m_label);
        }
    }

    @Override
    public void setWndLabel(String label) {
        this.m_label = label;
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().setTitle("JViewer[" + m_serverIP + "] - " + label);
        } else {
            this.setTitle("JViewer[" + m_serverIP + "] - " + label);
        }
    }

    private void constructUserIf() {
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new BorderLayout());
        if (!JViewer.isdownloadapp()) {
            if (JViewer.isplayerapp()) {
                this.toolbar = new RecorderToolBar();
            } else {
                this.m_menu = new WindowMenu();
                if (JViewer.isStandalone()) {
                    this.setJMenuBar(this.m_menu.getMenuBar());
                } else {
                    JViewer.getMainFrame().setJMenuBar(this.m_menu.getMenuBar());
                    JViewer.getMainFrame().setVisible(true);
                }
                this.m_status = new JVStatusBar();
                this.macrows = new Macrows(this.m_status);
                contentPane.add((Component)this.m_status.getStatusBar(), "Last");
                this.m_status.setStatus("KVM Remote Console started... ");
                this.toolbar = new JVToolBar();
            }
            contentPane.add((Component)this.toolbar.getToolBar(), "First");
        }
        if (JViewer.isStandalone()) {
            URL imageURL = JViewer.class.getResource("res/jviewer.jpg");
            JViewer.getMainFrame().setIconImage(Toolkit.getDefaultToolkit().getImage(imageURL));
        }
    }

    public JVStatusBar getM_status() {
        return this.m_status;
    }

    public void setM_status(JVStatusBar m_status) {
        this.m_status = m_status;
    }

    public WindowMenu getWindowMenu() {
        return this.m_menu;
    }
}

