/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.ImagesToVideo;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.videorecord.DisplayVideoDataTask;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.TimerTask;
import javax.imageio.ImageIO;

class VideoRecordStart
extends TimerTask {
    JViewerApp RCApp = JViewerApp.getInstance();
    private int init_fps = 0;
    private Date CurrTime = new Date(0L);
    private Date RunTime = new Date(0L);

    VideoRecordStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.CurrTime = new Date(System.currentTimeMillis() / 1000L);
        this.RunTime = this.RCApp.getM_videorecord().TimeToRun;
        if (this.CurrTime.before(this.RunTime) && !JViewer.isdownloadapp()) {
            this.captureFrames();
            try {
                Object object = this.RCApp.getM_videorecord().obj;
                synchronized (object) {
                    this.RCApp.getM_videorecord().obj.wait(VideoRecord.RecordStopTimer * 1000);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (DisplayVideoDataTask.run && JViewer.isdownloadapp()) {
            this.captureFrames();
            try {
                Object e1 = this.RCApp.getM_videorecord().obj;
                synchronized (e1) {
                    this.RCApp.getM_videorecord().obj.wait(VideoRecord.RecordStopTimer * 1000);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.cancel();
            this.RCApp.getM_videorecord().OnVideoRecordStop();
        }
    }

    public void makeVideo(String movFile) throws MalformedURLException {
        this.CurrTime = new Date(System.currentTimeMillis() / 1000L);
        long duration = !JViewer.isdownloadapp() ? (long)VideoRecord.RecordStopTimer - (this.RunTime.getTime() - this.CurrTime.getTime()) : JViewerApp.getInstance().getVideorecordapp().getDuration();
        String imagePath = JViewerApp.getInstance().getM_videorecord().Temp_store_Path;
        ImagesToVideo imageToMovie = new ImagesToVideo(movFile, imagePath, VideoRecord.TotalFrames, duration);
    }

    public File getFile(int count, String path) {
        String fileName = "file" + count + ".jpeg";
        File file = new File(path, fileName);
        return file;
    }

    private void captureFrames() {
        File infile = this.getFile(VideoRecord.TotalFrames, this.RCApp.getM_videorecord().Temp_store_Path);
        ++VideoRecord.TotalFrames;
        try {
            infile.createNewFile();
            ImageIO.write((RenderedImage)this.RCApp.getRCView().getImage(), "jpeg", infile);
        }
        catch (IOException e) {
            String errorMsg = "Unable to complete Video Recording due to Insufficient Disk Space";
            this.cancel();
            this.RCApp.getM_videorecord().OnLowDiskSpace(infile, errorMsg);
            VideoRecord.Record_Interrupted = true;
            this.RCApp.getM_videorecord().OnVideoRecordStop();
        }
        this.init_fps = this.RCApp.getVidClnt().getM_frameRate();
        VideoRecord.fps += this.init_fps;
    }
}

