/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.FSMenu;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FSMenuBar
extends JDialog {
    private static final long serialVersionUID = 1L;
    FSFrame m_frame;
    FSMenu m_fsMenu;
    JPopupMenu m_popupMenu;
    MouseEnterExit m_msEE;
    ButtonListener m_btnListener;
    private int m_slide = 0;
    private int m_fsMenuX;
    private int m_fsMenuY;
    private int m_fsMenuWidth;
    private Timer m_timer;
    private boolean m_show;
    private JComponent m_contentPane;
    private JLabel m_idLbl;
    private JLabel m_conSsnLbl;
    private JButton m_menuBtn;
    private JPanel m_autoPanel;
    private JButton m_autoPin;
    private JButton m_autoUnpin;
    private JPanel m_conSsnMsgPanel;
    private boolean m_auto;

    public FSMenuBar() {
    }

    public FSMenuBar(FSFrame frame) {
        super(JViewer.getMainFrame());
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.m_fsMenuX = sd.width / 2 - 200;
        this.m_fsMenuWidth = 400;
        this.setBounds(this.m_fsMenuX, 0, this.m_fsMenuWidth, this.m_slide);
        this.setUndecorated(true);
        this.setResizable(false);
        this.m_msEE = new MouseEnterExit();
        this.addMouseListener(this.m_msEE);
        this.addMouseListener(new WindowMouseEvents());
        this.m_btnListener = new ButtonListener();
        this.m_contentPane = (JComponent)this.getContentPane();
        this.m_contentPane.setBackground(new Color(250, 250, 250));
        this.m_contentPane.setLayout(new BoxLayout(this.m_contentPane, 0));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_autoPin = this.createButton("res/pin.jpg", "Auto Hide", "Pin");
        this.m_autoUnpin = this.createButton("res/unpin.jpg", "Auto Hide", "Unpin");
        this.m_autoPanel = new JPanel();
        this.m_autoPanel.setLayout(new BoxLayout(this.m_autoPanel, 0));
        this.m_autoPanel.setPreferredSize(new Dimension(15, 15));
        this.m_autoPanel.setMaximumSize(new Dimension(15, 15));
        this.m_autoPanel.add(this.m_autoPin);
        this.m_auto = false;
        this.m_contentPane.add(this.m_autoPanel);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_menuBtn = this.createButton("res/menu.jpg", "Menu", "Menu");
        this.m_fsMenu = new FSMenu();
        this.m_popupMenu = this.m_fsMenu.getPopupMenu();
        this.m_popupMenu.addPopupMenuListener(new PopupMenuEventListener());
        this.m_menuBtn.addMouseListener(new PopupListener());
        this.m_contentPane.add(this.m_menuBtn);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_contentPane.add(this.createSeparator());
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_idLbl = new JLabel("Not connected");
        this.m_idLbl.setForeground(new Color(0, 100, 100));
        this.m_idLbl.setFont(new Font("SansSerif", 0, 12));
        this.m_idLbl.setHorizontalAlignment(0);
        this.m_idLbl.setPreferredSize(new Dimension(287, 15));
        this.m_idLbl.setMinimumSize(new Dimension(287, 15));
        this.m_idLbl.setMaximumSize(new Dimension(287, 15));
        this.m_contentPane.add(this.m_idLbl);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_contentPane.add(this.createButton("res/min.jpg", "Minimize", "Minimize"));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_contentPane.add(this.createButton("res/max.jpg", "Toggle to frame window", "ToFrame"));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_contentPane.add(this.createButton("res/close.jpg", "Close", "Close"));
        this.m_contentPane.add(Box.createHorizontalGlue());
        this.createConcurrentSessionMsg();
    }

    public JVMenu getFSMenu() {
        return this.m_fsMenu;
    }

    public void showMenu() {
        this.m_show = true;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
    }

    public void hideMenu() {
        this.m_show = false;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
    }

    public void setIDLabel(String idLbl) {
        int height = 15;
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.m_conSsnMsgPanel.isVisible()) {
            int width;
            if (idLbl.startsWith("Video")) {
                if (System.getProperty("os.name").startsWith("Mac")) {
                    width = 199;
                    this.m_fsMenuX = sd.width / 2 - 272;
                    this.m_fsMenuWidth = 472;
                    this.m_fsMenuY = 20;
                } else {
                    width = 187;
                    this.m_fsMenuX = sd.width / 2 - 260;
                    this.m_fsMenuWidth = 460;
                    this.m_fsMenuY = 0;
                }
            } else {
                width = 127;
                this.m_fsMenuX = sd.width / 2 - 200;
                this.m_fsMenuWidth = 400;
                this.m_fsMenuY = System.getProperty("os.name").startsWith("Mac") ? 20 : 0;
            }
            this.m_idLbl.setPreferredSize(new Dimension(width, height));
            this.m_idLbl.setMinimumSize(new Dimension(width, height));
            this.m_idLbl.setMaximumSize(new Dimension(width, height));
        }
        this.m_idLbl.setText(idLbl);
        this.setBounds(this.m_fsMenuX, this.m_fsMenuY, this.m_fsMenuWidth, this.m_slide);
    }

    public void cancelTimer() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    private void slide() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.setBounds(this.m_fsMenuX, 20, this.m_fsMenuWidth, this.m_slide);
        } else {
            this.setBounds(this.m_fsMenuX, 0, this.m_fsMenuWidth, this.m_slide);
        }
        this.setVisible(true);
    }

    private JButton createButton(String image, String tip, String actionCmd) {
        URL imageURL = JViewer.class.getResource(image);
        JButton btn = new JButton();
        if (imageURL != null) {
            btn.setIcon(new ImageIcon(imageURL));
        }
        btn.setToolTipText(tip);
        btn.setPreferredSize(new Dimension(15, 15));
        btn.setMinimumSize(new Dimension(15, 15));
        btn.setMaximumSize(new Dimension(15, 15));
        btn.addMouseListener(this.m_msEE);
        btn.setActionCommand(actionCmd);
        btn.addActionListener(this.m_btnListener);
        return btn;
    }

    private JLabel createSeparator() {
        JLabel m_separatorLbl = new JLabel("|");
        m_separatorLbl.setForeground(new Color(200, 200, 200));
        m_separatorLbl.setFont(new Font("Arial", 0, 18));
        return m_separatorLbl;
    }

    private void createConcurrentSessionMsg() {
        this.m_conSsnMsgPanel = new JPanel();
        this.m_conSsnMsgPanel.setPreferredSize(new Dimension(160, 15));
        this.m_conSsnMsgPanel.setMinimumSize(new Dimension(160, 15));
        this.m_conSsnMsgPanel.setMaximumSize(new Dimension(160, 15));
        this.m_conSsnMsgPanel.setBackground(new Color(250, 250, 250));
        this.m_conSsnMsgPanel.setLayout(new BoxLayout(this.m_conSsnMsgPanel, 0));
        this.m_conSsnMsgPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_conSsnMsgPanel.add(this.createSeparator());
        this.m_conSsnMsgPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_conSsnLbl = new JLabel("Concurrent Session");
        this.m_conSsnLbl.setForeground(new Color(0, 100, 100));
        this.m_conSsnLbl.setHorizontalAlignment(0);
        this.m_conSsnLbl.setFont(new Font("SansSerif", 0, 12));
        this.m_conSsnLbl.setPreferredSize(new Dimension(150, 15));
        this.m_conSsnLbl.setMinimumSize(new Dimension(150, 15));
        this.m_conSsnLbl.setMaximumSize(new Dimension(150, 15));
        this.m_conSsnLbl.setVisible(true);
        this.m_conSsnMsgPanel.add(this.m_conSsnLbl);
    }

    public void addConcurrentSessionMsg(String tip) {
        int index = 0;
        try {
            index = this.getIndex(this.m_idLbl);
        }
        catch (InvalidParameterException ipe) {
            Debug.out.println(ipe);
        }
        this.m_idLbl.setPreferredSize(new Dimension(127, 15));
        this.m_idLbl.setMinimumSize(new Dimension(127, 15));
        this.m_idLbl.setMaximumSize(new Dimension(127, 15));
        this.m_conSsnLbl.setToolTipText(tip);
        this.m_conSsnMsgPanel.setVisible(true);
        this.m_contentPane.add((Component)this.m_conSsnMsgPanel, ++index);
    }

    public void removeConcurrentSessionMsg() {
        this.m_conSsnMsgPanel.setVisible(false);
        this.m_contentPane.remove(this.m_conSsnMsgPanel);
        if (this.m_idLbl != null) {
            this.m_idLbl.setPreferredSize(new Dimension(287, 15));
            this.m_idLbl.setMinimumSize(new Dimension(287, 15));
            this.m_idLbl.setMaximumSize(new Dimension(287, 15));
        }
    }

    private int getIndex(JComponent comp) {
        for (int index = 0; index < this.m_contentPane.getComponentCount(); ++index) {
            if (!this.m_contentPane.getComponent(index).equals(comp)) continue;
            return index;
        }
        throw new InvalidParameterException("Component not avilable");
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JViewerApp RCApp = JViewerApp.getInstance();
            String cmd = e.getActionCommand();
            if (cmd.equals("Unpin")) {
                Debug.out.println("Disable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoPin);
                FSMenuBar.this.m_autoPanel.repaint();
                FSMenuBar.this.m_auto = false;
                JViewerApp.getInstance().getRCView().requestFocus();
            } else if (cmd.equals("Pin")) {
                Debug.out.println("Enable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoUnpin);
                FSMenuBar.this.m_auto = true;
                JViewerApp.getInstance().getRCView().requestFocus();
            } else if (cmd.equals("ToFrame")) {
                Debug.out.println("Toggle to frame window");
                FSMenuBar.this.m_auto = false;
                RCApp.OnVideoFullScreen(false);
            } else if (cmd.equals("Minimize")) {
                Debug.out.println("Minimize");
                if (JViewer.isStandalone()) {
                    JViewer.getMainFrame().setState(1);
                }
            } else if (cmd.equals("Close")) {
                Debug.out.println("Close");
                RCApp.OnVideoExit();
            } else if (cmd.equals("Menu")) {
                Debug.out.println("Menu");
            } else {
                JViewerApp.getInstance().getRCView().requestFocus();
            }
        }
    }

    class PopupMenuEventListener
    implements PopupMenuListener {
        boolean m_autoCanceled = false;

        PopupMenuEventListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            Debug.out.println("Popup canceled");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Debug.out.println("Popup visible");
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_auto = false;
                this.m_autoCanceled = true;
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Debug.out.println("Popup invisible");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
            JViewerApp.getInstance().getRCView().requestFocus();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Debug.out.println("Popup event");
            FSMenuBar.this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class MouseEnterExit
    extends MouseAdapter {
        MouseEnterExit() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.showMenu();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class WindowMouseEvents
    extends MouseAdapter {
        WindowMouseEvents() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JViewerApp.getInstance().getRCView().requestFocus();
        }
    }

    class SlideTask
    extends TimerTask {
        SlideTask() {
        }

        @Override
        public void run() {
            if (FSMenuBar.this.m_show) {
                if (FSMenuBar.this.m_slide < 20) {
                    FSMenuBar.this.m_slide++;
                    FSMenuBar.this.slide();
                } else {
                    FSMenuBar.this.m_timer.cancel();
                    JViewerApp.getInstance().getRCView().requestFocus();
                }
            } else if (FSMenuBar.this.m_slide > 1) {
                FSMenuBar.this.m_slide--;
                FSMenuBar.this.slide();
            } else {
                FSMenuBar.this.m_timer.cancel();
                JViewerApp.getInstance().getRCView().requestFocus();
            }
        }
    }
}

