/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.iusb.protocol.RedirProtocol;
import com.ami.kvm.jviewer.Debug;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Selector;
import java.nio.channels.UnresolvedAddressException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PacketMaster {
    private Socket packetSock;
    private Socket Sock;
    private SSLSocket packetSockssl;
    private Selector packetSel;
    private RedirProtocol protocol;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private String host;
    private int port;
    private boolean wakeup = false;
    private static final int IUSB_HDR_SIZE = 32;

    public PacketMaster(String host, int port, boolean blocking, RedirProtocol protocol, boolean sslEncryption) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    public void setupBuffers(int inBufferSize, int outBufferSize) {
        this.netIn = ByteBuffer.allocateDirect(inBufferSize);
        this.netOut = ByteBuffer.allocateDirect(outBufferSize);
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        Debug.out.println("No SSL, allocating only netIn and netOut...");
        Debug.out.println("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
        Debug.out.println("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
    }

    public void setupBuffers(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        this.netIn = inBuffer;
        this.netOut = outBuffer;
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        this.netIn.clear();
        this.netOut.clear();
        Debug.out.println("No SSL, using provided buffers exclusively");
    }

    public void setBufferEndianness(ByteOrder inByteOrder, ByteOrder outByteOrder) {
        this.appIn.order(inByteOrder);
        this.appOut.order(outByteOrder);
    }

    public void connectVmedia(boolean useSSL) {
        if (useSSL) {
            try {
                this.connectVmediaSSl();
            }
            catch (IOException e) {
                Debug.out.println(e);
            }
        } else {
            try {
                this.connectVmedianonssl();
            }
            catch (IOException e) {
                Debug.out.println(e);
            }
        }
    }

    public void connectVmedianonssl() throws IOException {
        this.packetSock = new Socket();
        try {
            this.packetSock.connect(new InetSocketAddress(this.host, this.port));
        }
        catch (UnresolvedAddressException e) {
            throw new IOException("Cannot resolve host name: " + this.host);
        }
        this.setSock(this.packetSock);
    }

    public void connectVmediaSSl() throws IOException {
        SSLContext context = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            context = sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            Debug.out.println("NoSuchAlgorithmException  exception is thrown");
        }
        catch (KeyManagementException e) {
            Debug.out.println("KeyManagementException  exception is thrown");
        }
        SSLSocketFactory sf = context.getSocketFactory();
        try {
            this.packetSockssl = (SSLSocket)sf.createSocket(this.host, this.port);
            this.packetSockssl.startHandshake();
            this.setSock(this.packetSockssl);
        }
        catch (UnresolvedAddressException e) {
            throw new IOException("Cannot resolve host name: " + this.host);
        }
    }

    public Socket getSock() {
        return this.Sock;
    }

    public void setSock(Socket sock) {
        this.Sock = sock;
    }

    public void VmediaSockclose() throws IOException {
        if (this.packetSock != null) {
            this.packetSock.close();
        }
        if (this.packetSockssl != null) {
            this.packetSockssl.close();
        }
    }

    public void wakeup() {
        this.wakeup = true;
        if (this.packetSel.isOpen()) {
            this.packetSel.wakeup();
        }
    }

    public void sendPacket(RedirPacket packet) throws IOException, EncryptionException {
        this.appOut.clear();
        this.netOut.clear();
        packet.writePacket(this.appOut);
        this.appOut.flip();
        byte[] write_buf = new byte[this.netOut.remaining()];
        this.netOut.get(write_buf);
        this.getSock().getOutputStream().write(write_buf);
    }

    public RedirPacket receivePacket(boolean clearBuffer) throws IOException, RedirectionException {
        int rc = 0;
        RedirPacket packet = null;
        if (this.appIn.position() != 0) {
            this.appIn.flip();
            packet = this.protocol.getPacket(this.appIn);
            if (packet == null) {
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
            } else {
                Debug.out.println("Got a packet!");
            }
        }
        while (packet == null) {
            byte[] readheader_buf = new byte[32];
            rc = this.read_data(readheader_buf);
            if (rc < 0) {
                throw new IOException("Virtual Media service closed the connection");
            }
            this.netIn.put(readheader_buf);
            this.netIn.position(12);
            long dataPacketLen = (long)this.netIn.getInt() & 0xFFFFFFFFFFFFFFFFL;
            byte[] readdata_buf = new byte[(int)dataPacketLen];
            rc = 0;
            rc = this.read_data(readdata_buf);
            if (rc < 0) {
                throw new IOException("Virtual Media service closed the connection");
            }
            this.netIn.position(32);
            this.netIn.put(readdata_buf, 0, readdata_buf.length);
            this.netIn.position(0);
            this.netIn.limit(readheader_buf.length + readdata_buf.length);
            packet = this.protocol.getPacket(this.netIn);
            if (packet == null) {
                Debug.out.println("Can't build a packet from input data");
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
                continue;
            }
            Debug.out.println("Got a packet!");
        }
        if (clearBuffer) {
            this.appIn.compact();
        }
        return packet;
    }

    public RedirPacket receivePacket() throws IOException, RedirectionException {
        return this.receivePacket(true);
    }

    public void clearBuffer() {
        this.appIn.compact();
    }

    public int read_data(byte[] read_buf) {
        int dwIndex = 0;
        int bytes_to_read = read_buf.length;
        int m_readIx = 0;
        while (bytes_to_read != 0) {
            try {
                m_readIx = this.getSock().getInputStream().read(read_buf, dwIndex, bytes_to_read);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (m_readIx <= 0) {
                System.out.println("SOCKET FAILURE");
                return m_readIx;
            }
            bytes_to_read -= m_readIx;
            dwIndex += m_readIx;
        }
        m_readIx = read_buf.length;
        return m_readIx;
    }
}

