/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class IUSBRedirSession {
    public static final byte AUTH_USER_PKT_SIZE = 98;
    public static final byte AUTH_PKT_MAX_SIZE = 98;
    public static final int DEVICE_REDIR_STATUS_IDLE = 0;
    public static final int DEVICE_REDIR_STATUS_CONNECTED = 1;
    public CDROMRedir[] cdromSession = new CDROMRedir[JViewerApp.getInstance().getM_cdNum()];
    public FloppyRedir[] floppySession = new FloppyRedir[JViewerApp.getInstance().getM_fdNum()];
    public HarddiskRedir[] harddiskSession = new HarddiskRedir[JViewerApp.getInstance().getM_hdNum()];
    private int[] cdromRedirStatus = new int[JViewerApp.getInstance().getM_cdNum()];
    private int[] floppyRedirStatus = new int[JViewerApp.getInstance().getM_fdNum()];
    private int[] harddiskRedirStatus = new int[JViewerApp.getInstance().getM_hdNum()];

    public IUSBRedirSession() {
        int j;
        for (j = 0; j < this.cdromRedirStatus.length; ++j) {
            this.cdromRedirStatus[j] = 0;
        }
        for (j = 0; j < this.floppyRedirStatus.length; ++j) {
            this.floppyRedirStatus[j] = 0;
        }
        for (j = 0; j < this.harddiskRedirStatus.length; ++j) {
            this.harddiskRedirStatus[j] = 0;
        }
    }

    public boolean StartCDROMRedir(String token, int port, int cddevice_no, boolean bVMUseSSL, String cdromDrive) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", "Invalid IP Address");
            return false;
        }
        if (cdromDrive.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid source drive: Cannot redirect CD");
            return false;
        }
        try {
            if (this.cdromSession[cddevice_no] != null) {
                if (this.cdromSession[cddevice_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous CD/ISO redirection session failed to close properly");
                    return false;
                }
                this.cdromSession = null;
                System.gc();
            }
            this.cdromSession[cddevice_no] = new CDROMRedir(true);
            if (!this.cdromSession[cddevice_no].startRedirection(host, cdromDrive, cddevice_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", "CD-ROM redirection failed to start");
                this.StopCDROMRedir(cddevice_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", "CD-ROM redirection is not supported on this platform");
            this.StopCDROMRedir(cddevice_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", e.getMessage());
            this.StopCDROMRedir(cddevice_no);
            return false;
        }
        this.cdromRedirStatus[cddevice_no] = 1;
        return true;
    }

    public boolean StopCDROMRedir(int cddevice_no) {
        if (this.cdromSession[cddevice_no] != null) {
            if (!this.cdromSession[cddevice_no].stopRedirection()) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Close CDROM/ISO redirection", "Unable to stop CDROM/ISO Redirection. Please try again.");
                return false;
            }
            this.cdromSession[cddevice_no] = null;
            System.gc();
        }
        this.cdromRedirStatus[cddevice_no] = 0;
        return true;
    }

    public boolean StartISORedir(String token, int port, int cddevice_no, boolean bVMUseSSL, String filename) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM", "Invalid IP Address");
            return false;
        }
        if (filename.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect CD Image");
            return false;
        }
        if (!filename.endsWith(".iso")) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect CD Image");
            return false;
        }
        try {
            if (this.cdromSession[cddevice_no] != null) {
                if (this.cdromSession[cddevice_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous CD/ISO redirection session failed to close properly");
                    return false;
                }
                this.cdromSession[cddevice_no] = null;
                System.gc();
            }
            this.cdromSession[cddevice_no] = new CDROMRedir(false);
            if (!this.cdromSession[cddevice_no].startRedirection(host, filename, cddevice_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM image", "CD/DVD image redirection failed to start");
                this.StopISORedir(cddevice_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM image", "CD-ROM image redirection is not supported on this platform");
            this.StopISORedir(cddevice_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect CD-ROM image", e.getMessage());
            this.StopISORedir(cddevice_no);
            return false;
        }
        this.cdromRedirStatus[cddevice_no] = 1;
        return true;
    }

    public boolean StopISORedir(int cddevice_no) {
        return this.StopCDROMRedir(cddevice_no);
    }

    public boolean StartHarddiskRedir(String token, int port, int device_no, boolean bVMUseSSL, String hardDrive, byte MediaType) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key", "Invalid IP Address");
            return false;
        }
        if (hardDrive.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid source drive. Cannot redirect Hard disk/USB Key");
            return false;
        }
        try {
            if (this.harddiskSession[device_no] != null) {
                if (this.harddiskSession[device_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous Hard disk/USB Key image redirection session failed to close properly");
                    return false;
                }
                this.harddiskSession[device_no] = null;
                System.gc();
            }
            this.harddiskSession[device_no] = new HarddiskRedir(true);
            this.harddiskSession[device_no].setDrive_Type(MediaType);
            if (!this.harddiskSession[device_no].startRedirection(host, hardDrive, device_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key", "Hard disk/USB Key redirection failed to start");
                this.StopHarddiskRedir(device_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            Debug.out.println(e);
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key", "Hard disk/USB Key redirection is not supported on this platform");
            this.StopHarddiskRedir(device_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key", e.getMessage());
            this.StopHarddiskRedir(device_no);
            return false;
        }
        this.harddiskRedirStatus[device_no] = 1;
        return true;
    }

    public boolean StartFloppyRedir(String token, int port, int device_no, boolean bVMUseSSL, String floppyDrive) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", "Invalid IP Address");
            return false;
        }
        if (floppyDrive.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid source drive. Cannot redirect floppy");
            return false;
        }
        try {
            if (this.floppySession[device_no] != null) {
                if (this.floppySession[device_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous floppy/floppy image redirection session failed to close properly");
                    return false;
                }
                this.floppySession[device_no] = null;
                System.gc();
            }
            this.floppySession[device_no] = new FloppyRedir(true);
            if (!this.floppySession[device_no].startRedirection(host, floppyDrive, device_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", "Floppy redirection failed to start");
                this.StopFloppyRedir(device_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", "Floppy redirection is not supported on this platform");
            this.StopFloppyRedir(device_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", e.getMessage());
            this.StopFloppyRedir(device_no);
            return false;
        }
        this.floppyRedirStatus[device_no] = 1;
        return true;
    }

    public boolean StopHarddiskRedir(int device_no) {
        if (this.harddiskSession[device_no] != null) {
            if (!this.harddiskSession[device_no].stopRedirection()) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Close Floppy/Floppy Image redirection", "Unable to stop Hardisk/USB Image Redirection. Please try again.");
                return false;
            }
            this.harddiskSession[device_no] = null;
            System.gc();
        }
        this.harddiskRedirStatus[device_no] = 0;
        return true;
    }

    public boolean StopFloppyRedir(int device_no) {
        if (this.floppySession[device_no] != null) {
            if (!this.floppySession[device_no].stopRedirection()) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Close Floppy/Floppy Image redirection", "Unable to stop Floppy/Floppy Image Redirection. Please try again.");
                return false;
            }
            this.floppySession[device_no] = null;
            System.gc();
        }
        this.floppyRedirStatus[device_no] = 0;
        return true;
    }

    public boolean StartFloppyImageRedir(String token, int port, int device_no, boolean bVMUseSSL, String filename) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy", "Invalid IP Address");
            return false;
        }
        if (filename.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect floppy image");
            return false;
        }
        if (!filename.endsWith(".img")) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect Floppy Image");
            return false;
        }
        try {
            if (this.floppySession[device_no] != null) {
                if (this.floppySession[device_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous floppy/floppy image redirection session failed to close properly");
                    return false;
                }
                this.floppySession[device_no] = null;
                System.gc();
            }
            this.floppySession[device_no] = new FloppyRedir(false);
            if (!this.floppySession[device_no].startRedirection(host, filename, device_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy image", "Floppy image redirection failed to start");
                this.StopFloppyImageRedir(device_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy image", "Floppy image redirection is not supported on this platform");
            this.StopFloppyImageRedir(device_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Floppy image", e.getMessage());
            this.StopFloppyImageRedir(device_no);
            return false;
        }
        this.floppyRedirStatus[device_no] = 1;
        return true;
    }

    public boolean StartharddiskImageRedir(String token, int port, int device_no, boolean bVMUseSSL, String filename) {
        JViewerApp.getInstance().getMainWindow();
        String host = JVFrame.getServerIP();
        if (host == null) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key Image", "Invalid IP Address");
            return false;
        }
        if (filename.length() == 0) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect Hard disk/USB Key image");
            return false;
        }
        if (!filename.endsWith(".img")) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Invalid image file: Cannot redirect Hard disk/USB Key image");
            return false;
        }
        try {
            if (this.harddiskSession[device_no] != null) {
                if (this.harddiskSession[device_no].isRedirActive()) {
                    JViewerApp.getInstance().getMainWindow().generalErrorMessage("VMedia", "Previous Hard disk/USB Key image redirection session failed to close properly");
                    return false;
                }
                this.harddiskSession = null;
                System.gc();
            }
            this.harddiskSession[device_no] = new HarddiskRedir(false);
            if (!this.harddiskSession[device_no].startRedirection(host, filename, device_no, token, port, bVMUseSSL)) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key image", "Hard disk/USB Key image redirection failed to start");
                this.StopHarddiskImageRedir(device_no);
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key image", "Hard disk/USB Key image redirection is not supported on this platform");
            this.StopHarddiskImageRedir(device_no);
            return false;
        }
        catch (RedirectionException e) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Cannot redirect Hard disk/USB Key image", e.getMessage());
            this.StopHarddiskImageRedir(device_no);
            return false;
        }
        this.harddiskRedirStatus[device_no] = 1;
        return true;
    }

    public boolean StopFloppyImageRedir(int device_no) {
        return this.StopFloppyRedir(device_no);
    }

    public boolean StopHarddiskImageRedir(int device_no) {
        return this.StopHarddiskRedir(device_no);
    }

    public String getLIBCDROMVersion(int cddevice_no) {
        String version;
        try {
            if (this.cdromSession[cddevice_no] == null) {
                this.cdromSession[cddevice_no] = new CDROMRedir(false);
                version = this.cdromSession[cddevice_no].getLIBCDROMVersion();
                this.cdromSession[cddevice_no] = null;
                System.gc();
            } else {
                version = this.cdromSession[cddevice_no].getLIBCDROMVersion();
            }
        }
        catch (UnsatisfiedLinkError e) {
            version = "Not present";
        }
        return version;
    }

    public String isoImageSelector(String dirpath) {
        JVFrame frame = JViewerApp.getInstance().getMainWindow();
        JFileChooser chooser = new JFileChooser(dirpath);
        chooser.setFileFilter(new IsoImageFilter());
        if (chooser.showOpenDialog(frame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public String getLIBFLOPPYVersion(int device_no) {
        String version;
        try {
            if (this.floppySession[device_no] == null) {
                this.floppySession[device_no] = new FloppyRedir(false);
                version = this.floppySession[device_no].getLIBFLOPPYVersion();
                this.floppySession = null;
                System.gc();
            } else {
                version = this.floppySession[device_no].getLIBFLOPPYVersion();
            }
        }
        catch (UnsatisfiedLinkError e) {
            version = "Not present";
        }
        return version;
    }

    public boolean isCDROMPhysicalDrive(int cddevice_no) {
        return this.cdromSession[cddevice_no] != null && this.cdromSession[cddevice_no].isPhysicalDevice();
    }

    public boolean isHarddiskPhysicalDrive(int device_no) {
        return this.harddiskSession[device_no] != null && this.harddiskSession[device_no].isPhysicalDevice();
    }

    public boolean isFloppyPhysicalDrive(int device_no) {
        return this.floppySession[device_no] != null && this.floppySession[device_no].isPhysicalDevice();
    }

    public String floppyImageSelector(String dirpath) {
        JVFrame mainFrame = JViewerApp.getInstance().getMainWindow();
        JFileChooser chooser = new JFileChooser(dirpath);
        chooser.setFileFilter(new FloppyImageFilter());
        if (chooser.showOpenDialog(mainFrame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void stopCDROMAbnormal(int device_no) {
        this.cdromSession[device_no] = null;
        System.gc();
        this.cdromRedirStatus[device_no] = 0;
    }

    public void stopFloppyAbnormal(int device_no) {
        this.floppySession[device_no] = null;
        System.gc();
        this.floppyRedirStatus[device_no] = 0;
    }

    public void stopHarddiskAbnormal(int device_no) {
        this.harddiskSession[device_no] = null;
        System.gc();
        this.harddiskRedirStatus[device_no] = 0;
    }

    public int getCDROMRedirStatus(int device_no) {
        return this.cdromRedirStatus[device_no];
    }

    public int getHarddiskRedirStatus(int device_no) {
        return this.harddiskRedirStatus[device_no];
    }

    public int getFloppyRedirStatus(int device_no) {
        return this.floppyRedirStatus[device_no];
    }

    public String getCDROMSource(int cddevice_no) {
        if (this.cdromSession[cddevice_no] != null) {
            return this.cdromSession[cddevice_no].getSourceDrive();
        }
        return new String("");
    }

    public String getFloppySource(int device_no) {
        if (this.floppySession[device_no] != null) {
            return this.floppySession[device_no].getSourceDrive();
        }
        return new String("");
    }

    public String getharddiskSource(int device_no) {
        if (this.harddiskSession[device_no] != null) {
            return this.harddiskSession[device_no].getSourceDrive();
        }
        return new String("");
    }

    public int getCDROMReadBytes(int cddevice_no) {
        if (this.cdromSession[cddevice_no] != null) {
            return this.cdromSession[cddevice_no].getBytesRedirected();
        }
        return 0;
    }

    public int getFloppyReadBytes(int device_no) {
        if (this.floppySession[device_no] != null) {
            return this.floppySession[device_no].getBytesRedirected();
        }
        return 0;
    }

    public int getHarddiskReadBytes(int device_no) {
        if (this.harddiskSession[device_no] != null) {
            return this.harddiskSession[device_no].getBytesRedirected();
        }
        return 0;
    }

    public CDROMRedir getCdromSession(int cddevice_no) {
        return this.cdromSession[cddevice_no];
    }

    public void setCdromSession(CDROMRedir cdromSession, int cddevice_no) {
        this.cdromSession[cddevice_no] = cdromSession;
    }

    public FloppyRedir getFloppySession(int device_no) {
        return this.floppySession[device_no];
    }

    public void setFloppySession(FloppyRedir floppySession, int device_no) {
        this.floppySession[device_no] = floppySession;
    }

    public HarddiskRedir getHarddiskSession(int device_no) {
        return this.harddiskSession[device_no];
    }

    public void setHarddiskSession(HarddiskRedir harddiskSession, int device_no) {
        this.harddiskSession[device_no] = harddiskSession;
    }

    class FloppyImageFilter
    extends FileFilter {
        FloppyImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            return filename.endsWith(".img") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.img";
        }
    }

    class IsoImageFilter
    extends FileFilter {
        IsoImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            return filename.endsWith(".iso") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.iso";
        }
    }
}

