/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.HarddiskProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.vHarddiskMonitorThread;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JOptionPane;
import supermicro.jviewer.SMCUtil;

public class HarddiskRedir
extends Thread {
    private PacketMaster packetMaster;
    private HarddiskProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDevice;
    private int HDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceHarddisk = null;
    private int nBytesRedirected = 0;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int SET_HARDDISK_TYPE = 244;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int MAX_READ_SECTORS = 256;
    private static final int MAX_READ_SIZE = 131072;
    private static final String IOERRMSG = "Hard disk Redirection has lost connectivity to the host.\n Please check the Network connectivity or\n VMedia Devices Configuration could be modified. Retry after 2 Minutes.\n Closing the active media redirections.\n";
    public boolean Ejectharddiskimage = false;
    public boolean ImageRedirectionHD_USB = false;
    public static int READ_WRITE = 1;
    public static int READ_ONLY = 2;
    int Drive_Type;
    String[] ListDrive_USB = null;
    String[] ListDrive_Fixed = null;
    private vHarddiskMonitorThread vMThread = null;
    private static Object syncObj = new Object();
    private boolean confModified = false;

    private native String[] listHardDrivesFixed();

    private native String[] listHardDrives();

    private native void newHarddiskReader(boolean var1);

    private native void deleteHarddiskReader();

    private native int openHarddisk(byte[] var1);

    private native void closeHarddisk();

    private native int executeHarddiskSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    public HarddiskRedir(boolean physicalDevice) {
        this.physicalDevice = physicalDevice;
        this.protocol = new HarddiskProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(131134);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private void harddiskConnect(String host, int port, boolean bVMUseSSL) throws IOException {
        this.packetMaster = new PacketMaster(host, port, false, this.protocol, bVMUseSSL);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connectVmedia(bVMUseSSL);
    }

    private void harddiskDisconnect() {
        try {
            this.packetMaster.VmediaSockclose();
        }
        catch (IOException e) {
            System.err.println("Error closing Hard disk connection: " + e.getMessage());
        }
    }

    public boolean startRedirection(String host, String hardDrive, int hddevice_no, String token, int port, boolean bVMuseSSL) throws RedirectionException {
        block18: {
            if (this.running) {
                return true;
            }
            this.HDDevice_no = hddevice_no;
            try {
                this.harddiskConnect(host, port, bVMuseSSL);
                this.SendAuth_SessionToken(token);
                IUSBSCSI request = this.recvRequest();
                if (request.opcode == 241) {
                    if (request.connectionStatus != 1) {
                        this.harddiskDisconnect();
                        if (request.m_otherIP != null) {
                            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Virtual Media redirection", "Virtual Media is already in use.\nIf the client that is doing Virtual Media redirection has\nlost connectivity to the card, it may take upto 3 minutes\nfor the card to discard the old connection and\naccept a new connection.\nVirtual Media redirection is on from client with IP : " + request.m_otherIP);
                        }
                        return false;
                    }
                    break block18;
                }
                this.harddiskDisconnect();
                throw new RedirectionException("Got unexpected opcode: " + request.opcode);
            }
            catch (IOException e) {
                throw new RedirectionException(e.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(this.physicalDevice);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.sourceHarddisk = hardDrive = hardDrive.trim();
            if (this.isPhysicalDevice()) {
                int j;
                String remove = hardDrive.substring(hardDrive.indexOf(91));
                hardDrive = hardDrive.substring(0, hardDrive.indexOf(91));
                for (j = 0; j < remove.indexOf(93); ++j) {
                    char ch = remove.charAt(j);
                    if (ch == '[' || ch == ']' || ch == '-') continue;
                    hardDrive = hardDrive + ch;
                }
                hardDrive = hardDrive + remove.substring(j + 1);
            }
        } else if (this.isPhysicalDevice()) {
            String[] sourceHarddisk_temp = hardDrive.split("-");
            this.sourceHarddisk = hardDrive;
            hardDrive = sourceHarddisk_temp[0].trim();
        } else {
            this.sourceHarddisk = hardDrive = hardDrive.trim();
        }
        try {
            int Open_ret = this.openHarddisk(hardDrive.getBytes("UTF-8"));
            if (Open_ret < 0) {
                System.err.println("Cannot open Harddisk!");
                this.deleteHarddiskReader();
                this.harddiskDisconnect();
                return false;
            }
            if (Open_ret == READ_ONLY) {
                JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Device redirected in Read Only Mode");
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Path UTF-8 encoding error!");
        }
        JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)1);
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        if (JViewerApp.getInstance().getM_IUSBSession().isHarddiskPhysicalDrive(this.HDDevice_no)) {
            this.vMThread = new vHarddiskMonitorThread(this.HDDevice_no);
            this.vMThread.startharddiskMonitor();
        }
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            this.harddiskDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while joining floppy thread");
            }
            JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)0);
            this.harddiskDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeHarddisk();
            this.deleteHarddiskReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public String getSourceDrive() {
        return this.sourceHarddisk;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.harddiskDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeHarddisk();
            this.deleteHarddiskReader();
            JViewerApp.getInstance().reportHarddiskAbnormal(this.HDDevice_no);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nTempLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = this.recvRequest();
                if (request == null) continue;
                int dataLen = this.executeHarddiskSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(dataLen);
                if (request.opcode == 244) {
                    this.packetWriteBuffer.position(11);
                    this.packetWriteBuffer.putInt(31);
                    this.packetWriteBuffer.limit(++dataLen);
                    this.packetWriteBuffer.position(this.packetWriteBuffer.limit() - 1);
                    this.packetWriteBuffer.put((byte)this.getDrive_Type());
                }
                this.packetWriteBuffer.position(0);
                if (request.opcode == 27 && request.Lba == 2) {
                    this.Ejectharddiskimage = true;
                }
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
            }
            catch (IOException e) {
                if (this.stopRunning) continue;
                Object object = HarddiskRedir.getSyncObj();
                synchronized (object) {
                    try {
                        HarddiskRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
            catch (RedirectionException e) {
                if (this.stopRunning) continue;
                Object object = HarddiskRedir.getSyncObj();
                synchronized (object) {
                    try {
                        HarddiskRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
        }
    }

    public String[] getEntireHarddiskList() {
        int j;
        if (!this.physicalDevice) {
            this.DisplayErrorMsg("Cannot get Hard disk drive list during Hard disk IMAGE redirection");
            return null;
        }
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(true);
        }
        String[] ListDrive_original = this.listHardDrives();
        String[] ListDriveFixed_original = this.listHardDrivesFixed();
        String[] ListDrive_filter = null;
        if (ListDrive_original != null && ListDriveFixed_original != null) {
            ListDrive_filter = new String[ListDrive_original.length + ListDriveFixed_original.length];
        } else if (ListDriveFixed_original == null) {
            ListDrive_filter = new String[ListDrive_original.length];
        } else if (ListDrive_original == null) {
            ListDrive_filter = new String[ListDriveFixed_original.length];
        }
        int counter = 0;
        if (ListDrive_original != null) {
            for (j = 0; j < ListDrive_original.length; ++j) {
                ListDrive_filter[counter] = ListDrive_original[j];
                ++counter;
            }
        }
        if (ListDriveFixed_original != null) {
            for (j = 0; j < ListDriveFixed_original.length; ++j) {
                ListDrive_filter[counter] = ListDriveFixed_original[j];
                ++counter;
            }
        }
        return ListDrive_filter;
    }

    public String[] getUSBHDDList() {
        String[] ListDrive_original;
        block7: {
            block6: {
                if (!this.physicalDevice) {
                    this.DisplayErrorMsg("Cannot get Floppy drive list during Floppy IMAGE redirection");
                    return null;
                }
                if (this.nativeReaderPointer == -1L) {
                    this.newHarddiskReader(true);
                }
                if ((ListDrive_original = this.listHardDrives()) == null) {
                    return ListDrive_original;
                }
                if (!System.getProperty("os.name").startsWith("Win")) break block6;
                for (int i = 0; i < ListDrive_original.length; ++i) {
                    String Wholedrive;
                    int j;
                    String Drive = ListDrive_original[i];
                    String Drive_no = Drive.substring(0, 1);
                    String Drive_name = Drive.substring(2);
                    String Drive_name_append = "[";
                    for (j = 0; j < Drive_name.length() - 1; ++j) {
                        Drive_name_append = Drive_name_append + Drive_name.charAt(j) + "-";
                    }
                    Drive_name_append = Drive_name_append + Drive_name.charAt(j) + "]";
                    String Physicaldevice = "PhysicalDrive";
                    ListDrive_original[i] = Wholedrive = Physicaldevice.concat(Drive_no).concat("-").concat(Drive_name_append);
                }
                break block7;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block7;
            for (int i = 0; i < ListDrive_original.length; ++i) {
                String Drive_name;
                String Drive = ListDrive_original[i];
                ListDrive_original[i] = Drive_name = Drive.substring(0, Drive.length() - 1);
            }
        }
        return ListDrive_original;
    }

    public String[] getHarddiskFixedList() {
        String[] ListDrive_original;
        block7: {
            block6: {
                if (!this.physicalDevice) {
                    this.DisplayErrorMsg("Cannot get Floppy drive list during Floppy IMAGE redirection");
                    return null;
                }
                if (this.nativeReaderPointer == -1L) {
                    this.newHarddiskReader(true);
                }
                if ((ListDrive_original = this.listHardDrivesFixed()) == null) {
                    return null;
                }
                if (!System.getProperty("os.name").startsWith("Win")) break block6;
                for (int i = 0; i < ListDrive_original.length; ++i) {
                    String Wholedrive;
                    int j;
                    String Drive = ListDrive_original[i];
                    String Drive_no = Drive.substring(0, 1);
                    String Drive_name = Drive.substring(2);
                    String Drive_name_append = "[";
                    for (j = 0; j < Drive_name.length() - 1; ++j) {
                        Drive_name_append = Drive_name_append + Drive_name.charAt(j) + "-";
                    }
                    Drive_name_append = Drive_name_append + Drive_name.charAt(j) + "]";
                    String Physicaldevice = "PhysicalDrive";
                    ListDrive_original[i] = Wholedrive = Physicaldevice.concat(Drive_no).concat("-").concat(Drive_name_append);
                }
                break block7;
            }
            if (!System.getProperty("os.name").equals("Linux")) break block7;
            for (int i = 0; i < ListDrive_original.length; ++i) {
                String Drive_name;
                String Drive = ListDrive_original[i];
                ListDrive_original[i] = Drive_name = Drive.substring(0, Drive.length() - 1);
            }
        }
        return ListDrive_original;
    }

    public String getLIBFLOPPYVersion() {
        String version;
        if (this.nativeReaderPointer == -1L) {
            this.newHarddiskReader(false);
            version = this.getVersion();
            this.deleteHarddiskReader();
        } else {
            version = this.getVersion();
        }
        return version;
    }

    public void DisplayErrorMsg(String str) {
        JViewerApp.getInstance().getMainWindow().generalErrorMessage("Device Redirection", str);
    }

    public void handleError(String str) {
        this.DisplayErrorMsg(str);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDevice;
    }

    public void SendAuth_SessionToken(String session_token) throws RedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(session_token.getBytes());
        this.packetWriteBuffer.position(22);
        this.packetWriteBuffer.put((byte)this.getDrive_Type());
        this.packetWriteBuffer.put((byte)this.HDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public int getDrive_Type() {
        return this.Drive_Type;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean confModified) {
        this.confModified = confModified;
    }

    public void setDrive_Type(int drive_Type) {
        this.Drive_Type = drive_Type;
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isStandalone()) {
                    SMCUtil.loadLib("javaharddiskwrapper");
                } else {
                    String jarPath = System.getProperty("os.name").startsWith("Windows") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\javaharddiskwrapper.dll" : (System.getProperty("os.name").startsWith("Linux") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavaharddiskwrapper.so" : System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavaharddiskwrapper.jnilib");
                    System.load(jarPath);
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cannot find Harddisk wrapper library");
        }
    }
}

