/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

class ImageViewerFrame
extends JFrame {
    private JLabel label;

    public ImageViewerFrame() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem openItem = new JMenuItem("Open");
        menu.add(openItem);
        openItem.addActionListener(new FileOpenListener());
        JMenuItem exitItem = new JMenuItem("Exit");
        menu.add(exitItem);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageViewerFrame.this.dispose();
            }
        });
        this.label = new JLabel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.label);
        contentPane.add((Component)scrollPane, "Center");
    }

    public void openImage(String filename) {
        this.label.setIcon(new ImageIcon(filename));
    }

    private class FileOpenListener
    implements ActionListener {
        private FileOpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".gif") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "GIF Images";
                }
            });
            int r = chooser.showOpenDialog(ImageViewerFrame.this);
            if (r == 0) {
                String name = chooser.getSelectedFile().getPath();
                ImageViewerFrame.this.label.setIcon(new ImageIcon(name));
            }
        }
    }
}

