/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;
import java.util.HashMap;

public class SMTPPortCommand
extends RedfishCommand {
    private String port = null;

    @Override
    public boolean preValidate() {
        this.port = null;
        if (this.parameters != null) {
            if (SMTPRedfishHelper.isValidPort(this.parameters[0])) {
                this.port = this.parameters[0];
            } else {
                MOut.G(this).println("The port number must be between 1 and 65535.");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/EventService";
        if (this.port == null) {
            RedfishCommand.HTTP_CALLBACK callback = () -> {
                HashMap<String, String> entryMap = utils.getEntry();
                MOut.G(this.getOriginalParser()).println(entryMap.get("SMTP/Port"));
            };
            int httpStatusCode = utils.sendRedfishGet(this.getConfig(), url);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        } else {
            RedfishCommand.HTTP_CALLBACK callback = () -> MOut.G(this.getOriginalParser()).println("Done");
            String body = utils.getPatchBody(this.getConfig(), url);
            body = utils.updateEntryValue(body, "SMTP/Port", Integer.valueOf(this.port));
            int httpStatusCode = utils.sendRedfishPatch(this.getConfig(), url, body);
            this.statusCode = this.statusCodeHandler(callback, httpStatusCode, utils.getRedfishResponse());
        }
    }
}

