/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class RedfishVersionCommand
extends RedfishCommand {
    @Override
    public void runCommand() throws Exception {
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/";
        int result = bc.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode version = node.path("RedfishVersion");
            MOut.G(this).println(version.asText());
            this.statusCode = 0;
        } else {
            this.printFailMessage(result, bc.getResponseString());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }
}

