/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class LDAPUsernameAttributeCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode LDAP = node.path("LDAP");
            JsonNode ServiceEnabled = LDAP.path("ServiceEnabled");
            JsonNode Service2 = LDAP.path("LDAPService");
            JsonNode SearchSetting = Service2.path("SearchSettings");
            JsonNode Username = SearchSetting.findPath("UsernameAttribute");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                if (this.parameters == null) {
                    MOut.G(this).println("UsernameAttribute :" + Username.asText());
                    this.statusCode = 0;
                } else {
                    String body = "{\"LDAP\": {\"LDAPService\":{\"SearchSettings\":{\"UsernameAttribute\":";
                    result = this.sessionLoginClient.send_https_patch(url, body = body + "\"" + this.parameters[0] + "\"}}}}");
                    if (result >= 200 && result <= 210) {
                        MOut.G(this).println("Done");
                    } else {
                        MOut.G(this).println("Action failed. ErrorCode:" + result);
                        this.statusCode = 149;
                    }
                }
            } else {
                MOut.G(this).println("LDAP is disabled");
            }
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Fail to read LDAP information. ErrorCode:" + result);
            this.statusCode = 149;
        }
    }
}

