/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishActAPI;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import com.supermicro.redfish.module.RemoteRoleMapping;
import java.util.ArrayList;

public class LDAPDeleteRemoteRoleCommand
extends RedfishTokenCommand {
    int deleteIndex = 99;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 1) {
            this.printUsage();
            return false;
        }
        try {
            this.deleteIndex = Integer.parseInt(this.parameters[0]);
            if (this.deleteIndex < 1 || this.deleteIndex > 5) {
                MOut.G(this).println("Invalid Index");
                this.printUsage();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishActAPI api = new RedfishActAPI(this.config);
        if (!api.checkIfDCMSSingleExist()) {
            MOut.G(this).println("Login failed. DCMS-single may need to be activated for this device.");
            MOut.G(this).println("Or user credentials may be wrong.");
            this.statusCode = 155;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/AccountService/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode LDAP = node.path("LDAP");
            JsonNode ServiceEnabled = LDAP.path("ServiceEnabled");
            JsonNode RemoteRole = LDAP.path("RemoteRoleMapping");
            boolean isEnable = ServiceEnabled.asBoolean();
            if (isEnable) {
                ArrayList<RemoteRoleMapping> list = new ArrayList<RemoteRoleMapping>();
                if (RemoteRole.isArray()) {
                    for (int i = 0; i < RemoteRole.size(); ++i) {
                        JsonNode roleMapping = RemoteRole.get(i);
                        JsonNode RemoteGroup = roleMapping.path("RemoteGroup");
                        JsonNode RemoteUser = roleMapping.path("RemoteUser");
                        JsonNode LocalRole = roleMapping.path("LocalRole");
                        RemoteRoleMapping rrm = new RemoteRoleMapping();
                        rrm.setUser(RemoteUser.asText());
                        rrm.setGroup(RemoteGroup.asText());
                        rrm.setRole(LocalRole.asText());
                        list.add(rrm);
                    }
                    if (this.deleteIndex > list.size()) {
                        MOut.G(this).println("Role not found");
                        this.statusCode = 149;
                        return;
                    }
                    list.remove(this.deleteIndex - 1);
                    String body = "{\"LDAP\": {\"RemoteRoleMapping\":[";
                    for (int i = 0; i < list.size(); ++i) {
                        body = body + "{\"RemoteGroup\":\"" + ((RemoteRoleMapping)list.get(i)).getGroup() + "\",\"RemoteUser\":\"" + ((RemoteRoleMapping)list.get(i)).getUser() + "\",\"LocalRole\":\"" + ((RemoteRoleMapping)list.get(i)).getRole() + "\"},";
                        if (i != list.size() - 1) continue;
                        body = body.substring(0, body.length() - 1);
                    }
                    result = this.sessionLoginClient.send_https_patch(url, body = body + "]}}");
                    if (result >= 200 && result <= 210) {
                        MOut.G(this).println("Done");
                    } else {
                        this.printFailMessage(result, this.sessionLoginClient.getResponseString());
                        this.statusCode = 149;
                    }
                }
            } else {
                MOut.G(this).println("LDAP is disabled");
            }
            this.statusCode = 0;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: redfish accountService ldap deleteRemoteRole <number>");
    }
}

