/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class FirmwareInventoryInfoCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/UpdateService/" + "FirmwareInventory";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("404 not found");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            String formatTemplate = " %-30s | %40s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Name", "Version"));
            header.append(String.format(formatTemplate, "----", "-----"));
            MOut.G(this).print(header.toString());
            StringBuffer fStr = new StringBuffer();
            if (member.isArray()) {
                for (JsonNode l : member) {
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    try {
                        JsonNode inventory = mapper.readTree(this.sessionLoginClient.getResponseString());
                        JsonNode name = inventory.path("Name");
                        JsonNode versionNumber = inventory.path("Version");
                        fStr.append(String.format(formatTemplate, name.asText(), versionNumber.asText()));
                    }
                    catch (JsonParseException ex) {
                        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL == 0) continue;
                        ex.printStackTrace();
                    }
                }
                MOut.G(this).println(fStr.toString());
                this.statusCode = 0;
            }
        } else {
            this.printFailMessage(result, this.sessionLoginClient.getResponseString());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }
}

