/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;
import com.supermicro.redfish.text.AlertSetBaseCommand;
import java.util.HashMap;

public class AlertListCommand
extends RedfishTokenCommand {
    public static final int ALERT_PROTOCOL_SNMP_V1 = 0;
    public static final int ALERT_PROTOCOL_SNMP_V3 = 1;
    public static final int ALERT_PROTOCOL_SMTP = 2;
    public static final int ALERT_PROTOCOL_REDFISH = 3;
    public static final int ALERT_PROTOCOL_NOKNOWN = 4;
    public static final int ALERT_PROFILES_LIMIT = 16;
    public static final String URL_SUFFIX = "EventService/Subscriptions/";
    public static final String ALERT_NODE_ID = "Id";
    public static final String ALERT_NODE_DESTINATION = "Destination";
    public static final String ALERT_NODE_PROTOCOL = "Protocol";
    public static final String ALERT_NODE_EVENT_TYPES = "EventTypes";
    public static final String ALERT_NODE_ENABLE = "Oem/Supermicro/EnableSubscription";
    public static final String ALERT_NODE_SEVERITY = "Oem/Supermicro/Severity";
    public static final String ALERT_NODE_SMT_SUBJECT = "Oem/Supermicro/SMTPSubject";
    public static final String ALERT_NODE_USERNAME = "Oem/Supermicro/UserName";
    public static final String ALERT_NODE_CONTEXT = "Context";
    public static final String ALERT_NODE_AUTH_PROTOCOL = "SNMP/AuthenticationProtocol";
    public static final String ALERT_NODE_ENCRYT_PROTOCOL = "SNMP/EncryptionProtocol";
    private int displayIndex = 0;

    @Override
    public boolean preValidate() {
        boolean result = false;
        if (null == this.parameters) {
            this.displayIndex = 0;
            result = true;
        } else if (this.parameters.length == 1) {
            try {
                this.displayIndex = Integer.parseInt(this.parameters[0]);
                if (0 < this.displayIndex && this.displayIndex <= 16) {
                    result = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result) {
            return true;
        }
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!AlertSetBaseCommand.isSupported(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        int beginIdx = this.displayIndex > 0 ? this.displayIndex : 1;
        int endIdx = this.displayIndex > 0 ? this.displayIndex : 16;
        StringBuilder resultStrBuilder = new StringBuilder();
        String format1 = "%2d. %-25s : %-30s \n";
        String format2 = "    %-25s : %-30s \n";
        String MAIN_URI = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URL_SUFFIX;
        MOut.G().println("--------------------------------------------------------------------------------");
        RedfishHttpUtils utils = new RedfishHttpUtils();
        for (int idx = beginIdx; idx <= endIdx; ++idx) {
            int result = utils.sendRedfishGet(this.sessionLoginClient, MAIN_URI + idx);
            if (result == 200) {
                HashMap<String, String> entryMap = utils.getEntry();
                resultStrBuilder.setLength(0);
                resultStrBuilder.append(String.format("%2d. %-25s : %-30s \n", Integer.valueOf(entryMap.get(ALERT_NODE_ID)), "Enable", entryMap.get(ALERT_NODE_ENABLE)));
                resultStrBuilder.append(String.format("    %-25s : %-30s \n", ALERT_NODE_PROTOCOL, entryMap.get(ALERT_NODE_PROTOCOL)));
                resultStrBuilder.append(String.format("    %-25s : %-30s \n", ALERT_NODE_DESTINATION, entryMap.get(ALERT_NODE_DESTINATION)));
                if (entryMap.get(ALERT_NODE_EVENT_TYPES) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", ALERT_NODE_EVENT_TYPES, entryMap.get(ALERT_NODE_EVENT_TYPES)));
                }
                if (entryMap.get(ALERT_NODE_SEVERITY) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", "Severity", entryMap.get(ALERT_NODE_SEVERITY)));
                }
                if (entryMap.get(ALERT_NODE_USERNAME) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", "User Name", entryMap.get(ALERT_NODE_USERNAME)));
                }
                if (entryMap.get(ALERT_NODE_AUTH_PROTOCOL) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", "Authentication Protocol", entryMap.get(ALERT_NODE_AUTH_PROTOCOL)));
                }
                if (entryMap.get(ALERT_NODE_ENCRYT_PROTOCOL) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", "Encryption Protocol", entryMap.get(ALERT_NODE_ENCRYT_PROTOCOL)));
                }
                if (entryMap.get(ALERT_NODE_SMT_SUBJECT) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", "Subject", entryMap.get(ALERT_NODE_SMT_SUBJECT)));
                }
                if (entryMap.get(ALERT_NODE_CONTEXT) != null) {
                    resultStrBuilder.append(String.format("    %-25s : %-30s \n", this.getProtocolType(entryMap.get(ALERT_NODE_PROTOCOL)) == 2 ? "Message" : ALERT_NODE_CONTEXT, entryMap.get(ALERT_NODE_CONTEXT)));
                }
            } else {
                if (result == 404) {
                    MOut.G(this).println("404 not found");
                    this.statusCode = 153;
                    return;
                }
                this.printFailMessage(result, utils.getRedfishResponse());
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                return;
            }
            resultStrBuilder.append("--------------------------------------------------------------------------------\n");
            MOut.G().print(resultStrBuilder.toString());
        }
        this.statusCode = 0;
    }

    private int getProtocolType(String protocol) {
        if (protocol.equalsIgnoreCase("SNMPv1")) {
            return 0;
        }
        if (protocol.equalsIgnoreCase("SNMPv3")) {
            return 1;
        }
        if (protocol.equalsIgnoreCase("SMTP")) {
            return 2;
        }
        if (protocol.equalsIgnoreCase("Redfish")) {
            return 3;
        }
        return 4;
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish event alert list [number]");
    }
}

