/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.ByteUtility;
import java.util.Arrays;

public class SuspendPeriodRaw {
    private static final int BYTES_PER_PERIOD = 3;
    private byte[] current;
    private byte[] update;
    private int count;
    private int newCount;

    public SuspendPeriodRaw(byte[] raw) {
        this.current = raw;
        if (raw.length % 3 != 0) {
            throw new IllegalArgumentException();
        }
        this.count = raw.length / 3;
    }

    public byte[] add(byte start, byte stop, byte days) {
        if (this.count == 5) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        byte[] update = Arrays.copyOf(this.current, this.current.length + 3);
        int off = this.current.length;
        update[off] = start;
        update[off + 1] = stop;
        update[off + 2] = days;
        this.update = update;
        this.newCount = update.length / 3;
        return update;
    }

    public byte[] update(int id, int startInMinute, int stopInMinute, byte days) {
        int off = this.getOffsetByIdx(id);
        if (startInMinute != -1) {
            this.current[off] = (byte)(startInMinute / 6);
        }
        if (stopInMinute != -1) {
            this.current[off + 1] = (byte)(stopInMinute / 6);
        }
        if ((days & 0xFF) != 128) {
            this.current[off + 2] = days;
        }
        this.newCount = this.count;
        return this.current;
    }

    public byte[] delete(int id) {
        int off = this.getOffsetByIdx(id);
        byte[] update = new byte[this.current.length - 3];
        int n = 0;
        for (int i = 0; i < this.current.length; ++i) {
            if (i >= off && i < off + 3) continue;
            update[n] = this.current[i];
            ++n;
        }
        this.update = update;
        this.newCount = update.length / 3;
        return update;
    }

    public int getNewPeriodCount() {
        return this.newCount;
    }

    private int getOffsetByIdx(int id) {
        if (id > this.count) {
            throw new IllegalArgumentException("Invalid Period ID");
        }
        return (id - 1) * 3;
    }

    public String toString() {
        return "SuspendPeriodRaw [current=" + ByteUtility.bytesToHex(this.current) + ",  update=" + ByteUtility.bytesToHex(this.update) + "]";
    }
}

