/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.UserAccountProperty;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;

public class UserAccountHelper {
    public static final byte IPMI_USER_PRIVILEGE_USER = 2;
    public static final byte IPMI_USER_PRIVILEGE_OPERATOR = 3;
    public static final byte IPMI_USER_PRIVILEGE_ADMIN = 4;
    public static final byte IPMI_USER_PRIVILEGE_NO_ACCESS = 15;
    public static final int USER_ID_BEGIN = 1;
    public static final int USER_ID_END_LEGACY = 10;
    public static final int USER_ID_END = 16;
    public static final int USERNANE_LENGTH_MIN = 4;
    public static final int USERNANE_LENGTH_MAX = 15;
    public static final int PASSWORD_LENGTH_MIN = 8;
    public static final int PASSWORD_LENGTH_MAX = 20;
    public static final int EXEC_CODE_SUCCESS = 0;
    public static final int EXEC_CODE_VERIFY_PASSWORD_LENGTH_INVALID = 1;
    public static final int EXEC_CODE_VERIFY_PASSWORD_EQUAL_USERNAME = 2;
    public static final int EXEC_CODE_VERIFY_PASSWORD_EQUAL_REVERSE_USERNAME = 3;
    public static final int EXEC_CODE_VERIFY_PASSWORD_SECURITY_POLICY_INVALID = 4;
    public static final int EXEC_CODE_SET_USER_ID_FAILED = 5;
    public static final int EXEC_CODE_SET_USER_ID_OCCUPIED = 6;
    public static final int EXEC_CODE_SET_USER_ID_RESERVED = 7;
    public static final int EXEC_CODE_SET_USER_ENABLE_FAILED = 8;
    public static final int EXEC_CODE_SET_USER_PRIVILEGE_FAILED = 9;
    public static final int EXEC_CODE_SET_USER_PASSWORD_FAILED = 10;
    public static final int EXEC_CODE_SET_USER_NAME_FAILED = 11;
    public static final int EXEC_CODE_SET_USER_NAME_DUPLICATED = 12;
    public static final int EXEC_CODE_CLEAR_USER_ENABLE_FAILED = 13;
    public static final int EXEC_CODE_CLEAR_USER_PRIVILEGE_FAILED = 14;
    public static final int EXEC_CODE_CLEAR_USER_PASSWORD_FAILED = 15;
    public static final int EXEC_CODE_CLEAR_USER_NAME_FAILED = 16;
    public static final int EXEC_CODE_CLEAR_USER_ID_INVALID = 17;
    public static final int EXEC_CODE_UNKNOWN = 18;

    public static boolean isReservedUserID(String userIDStr) {
        int userID = Integer.valueOf(userIDStr);
        return userID == 1 || userID == 2;
    }

    public static boolean isValidUserID(String userIDStr) {
        return UserAccountHelper.isValidUserID(userIDStr, (byte)16);
    }

    public static boolean isValidUserID(String userIDStr, byte maxUserID) {
        try {
            byte userID = Byte.parseByte(userIDStr);
            if (userID < 1 || userID > maxUserID) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static boolean isValidUsernameLength(String username) {
        return username.length() >= 4 && 15 >= username.length();
    }

    public static boolean isValidPrivilege(String privilegeStr) {
        try {
            byte privilege = Byte.parseByte(privilegeStr);
            if (privilege != 2 && privilege != 3 && privilege != 4 && privilege != 15) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static boolean isValidPasswordSecurityPolicy(String password) {
        int matchCount = 0;
        Pattern numberPattern = Pattern.compile("\\d+");
        Pattern alphaLowercasePattern = Pattern.compile("[a-z]+");
        Pattern alphaUppercasePattern = Pattern.compile("[A-Z]+");
        Pattern specialSymbolPattern = Pattern.compile("[`~!,;#@$%\\^&*()\\-\\_=\\\\+\\[{\\]}\\|<.>\\/?]+");
        matchCount += numberPattern.matcher(password).find() ? 1 : 0;
        matchCount += alphaLowercasePattern.matcher(password).find() ? 1 : 0;
        matchCount += alphaUppercasePattern.matcher(password).find() ? 1 : 0;
        return (matchCount += specialSymbolPattern.matcher(password).find() ? 1 : 0) >= 3;
    }

    public static int isValidPassword(String password, String username, boolean hasSecurityPolicy) {
        int result;
        block1: {
            block3: {
                block2: {
                    block0: {
                        result = 0;
                        if (password.length() >= 8 && 20 >= password.length()) break block0;
                        result = 1;
                        break block1;
                    }
                    if (!username.equalsIgnoreCase(password)) break block2;
                    result = 2;
                    break block1;
                }
                StringBuilder usernameStringBuilder = new StringBuilder(username);
                if (!usernameStringBuilder.reverse().toString().equalsIgnoreCase(password)) break block3;
                result = 3;
                break block1;
            }
            if (!hasSecurityPolicy || UserAccountHelper.isValidPasswordSecurityPolicy(password)) break block1;
            result = 4;
        }
        return result;
    }

    public boolean isValidUserID(IPMIMessagingCommand command, byte userID) {
        int maxUserID = this.getNumberOfAvailableUser(command);
        String userIDStr = String.valueOf(userID);
        return UserAccountHelper.isValidUserID(userIDStr, (byte)maxUserID);
    }

    public boolean isEnabledSOL(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.isSOLEnabled(userID) : false;
    }

    public boolean isEnabledUser(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.isEnableUser(userID) : false;
    }

    public boolean isSupportedUserOEMCommand(IPMIMessagingCommand command) {
        return command != null ? command.isUserOEMCommandSupported() : false;
    }

    public boolean isAvailableUsername(IPMIMessagingCommand command, String username) {
        if (command == null) {
            return false;
        }
        int numberOfUsers = command.getNumberOfAvailableUser();
        for (int id = 1; id <= numberOfUsers; ++id) {
            String name = command.getUserNameByID((byte)id);
            if (name == null || name.isEmpty() || !name.equalsIgnoreCase(username)) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfAvailableUser(IPMIMessagingCommand command) {
        return command != null ? command.getNumberOfAvailableUser() : 0;
    }

    public byte getUserPrivilege(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.getUserPrivilegeByID(userID) : (byte)0;
    }

    public String getUsername(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.getUserNameByID(userID) : "";
    }

    public boolean setUserEnable(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.setEnableUserByID(userID) : false;
    }

    public boolean setUserPrivilege(IPMIMessagingCommand command, byte userID, int privilege) {
        return command != null ? command.setUserPrivilegeByID(userID, (byte)privilege) : false;
    }

    public int setUserPassword(IPMIMessagingCommand command, byte userID, String password) {
        IPMIMessage resMessage = command.setUserPasswordCommand(userID, (byte)2, password);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0;
            }
            if (resMessage.completionCode == -56) {
                return 4;
            }
        }
        return 10;
    }

    public boolean setUsername(IPMIMessagingCommand command, byte userID, String username) {
        return command != null ? command.setUserNameByID(userID, username) : false;
    }

    public boolean setUserSOL(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.setEnableUserPayloadForSOL(userID, true) : false;
    }

    public int setUserOEM(IPMIMessagingCommand command, byte userID, String username, String password) {
        String cipher = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        int result = command.setUserOEMCommand((byte)(userID - 1), (byte)username.length(), (byte)password.length(), cipher.getBytes());
        if (result == 0) {
            return 0;
        }
        if (result == 1) {
            return 11;
        }
        if (result == 17) {
            return 4;
        }
        if (result == 32) {
            return 5;
        }
        return 18;
    }

    public boolean clearUserEnable(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.setDisableUserByID(userID) : false;
    }

    public boolean clearUserPlusEnable(IPMIMessagingCommand command, byte userID) {
        if (command == null) {
            return false;
        }
        if (!command.setDisableUserPlusByID(userID, (byte)0)) {
            return command.setDisableUserPlusByID(userID, (byte)15);
        }
        return true;
    }

    public boolean clearUserPrivilege(IPMIMessagingCommand command, byte userID) {
        boolean result = false;
        result = this.setUserPrivilege(command, userID, 0);
        if (!result) {
            result = this.setUserPrivilege(command, userID, 15);
        }
        return result;
    }

    public boolean clearUserPassword(IPMIMessagingCommand command, byte userID) {
        return command != null ? this.setUserPassword(command, userID, "") == 0 : false;
    }

    public boolean clearUsername(IPMIMessagingCommand command, byte userID, boolean isLegacyDevice) {
        if (command == null) {
            return false;
        }
        if (isLegacyDevice) {
            return command.clearUserNameByFill0XFF(userID);
        }
        return command.setUserNameByID(userID, "");
    }

    public boolean clearUserSOL(IPMIMessagingCommand command, byte userID) {
        return command != null ? command.setEnableUserPayloadForSOL(userID, false) : false;
    }

    public int clearUserOEM(IPMIMessagingCommand command, byte userID) {
        int result = command.clearUserOEMCommand(userID);
        if (result == 0) {
            return 0;
        }
        if (result == 32) {
            return 17;
        }
        return 18;
    }

    public UserAccountProperty getUser(IPMIMessagingCommand command, byte userID) {
        if (null == command) {
            return null;
        }
        UserAccountProperty properties = new UserAccountProperty();
        properties.setUserID(userID);
        properties.setNetworkPrivilege(this.getUserPrivilege(command, userID));
        properties.setAccountState(this.isEnabledUser(command, userID) ? 1 : 0);
        properties.setUsername(this.getUsername(command, userID));
        properties.setEnabledSOL(this.isEnabledSOL(command, userID));
        return properties;
    }

    public List<UserAccountProperty> getAllUsers(IPMIMessagingCommand command) {
        if (null == command) {
            return null;
        }
        int numberOfUsers = command.getNumberOfAvailableUser();
        ArrayList<UserAccountProperty> accountPropList = new ArrayList<UserAccountProperty>();
        for (int id = 1; id <= numberOfUsers; ++id) {
            accountPropList.add(this.getUser(command, (byte)id));
        }
        return accountPropList;
    }

    public int addUser(IPMIMessagingCommand command, byte userID, String username, String password, int previlege) {
        if (this.isSupportedUserOEMCommand(command)) {
            return this.addUserOEMCommand(command, userID, username, password, previlege);
        }
        return this.addUserIPMICommand(command, userID, username, password, previlege);
    }

    public int modifyUser(IPMIMessagingCommand command, byte userID, String username, String password, int previlege) {
        int status = 0;
        status = this.setUserPassword(command, userID, password);
        if (status == 0) {
            if (!this.setUserPrivilege(command, userID, previlege)) {
                status = 9;
            } else if (!this.setUsername(command, userID, username)) {
                status = 11;
            }
        }
        return status;
    }

    public int deleteUser(IPMIMessagingCommand command, byte userID, boolean isLegacyDevice) {
        if (this.isSupportedUserOEMCommand(command)) {
            return this.deleteUserOEMCommand(command, userID);
        }
        return this.deleteUserIPMICommand(command, userID, isLegacyDevice);
    }

    public int addUserIPMICommand(IPMIMessagingCommand command, byte userID, String username, String password, int previlege) {
        int status = 0;
        if (!this.isValidUserID(command, userID)) {
            status = 5;
        } else if (this.isEnabledUser(command, userID)) {
            status = 6;
        } else if (!this.isAvailableUsername(command, username)) {
            status = 12;
        } else if (!this.setUserEnable(command, userID)) {
            status = 8;
        } else if (!this.setUserPrivilege(command, userID, previlege)) {
            this.clearUserEnable(command, userID);
            this.clearUserPlusEnable(command, userID);
            status = 9;
        } else {
            status = this.setUserPassword(command, userID, password);
            if (status != 0) {
                this.clearUserPrivilege(command, userID);
                this.clearUserEnable(command, userID);
                this.clearUserPlusEnable(command, userID);
            } else if (!this.setUsername(command, userID, username)) {
                this.clearUserPrivilege(command, userID);
                this.clearUserEnable(command, userID);
                this.clearUserPassword(command, userID);
                this.clearUserPlusEnable(command, userID);
                status = 11;
            }
        }
        return status;
    }

    public int addUserOEMCommand(IPMIMessagingCommand command, byte userID, String username, String password, int previlege) {
        int status = 0;
        if (!this.isValidUserID(command, userID)) {
            status = 5;
        } else if (this.isEnabledUser(command, userID)) {
            status = 6;
        } else {
            status = this.setUserOEM(command, userID, username, password);
            if (status == 0) {
                if (!this.setUserEnable(command, userID)) {
                    this.clearUserOEM(command, userID);
                    status = 8;
                } else if (!this.setUserPrivilege(command, userID, previlege)) {
                    this.clearUserEnable(command, userID);
                    this.clearUserOEM(command, userID);
                    status = 9;
                }
            }
        }
        return status;
    }

    public int deleteUserIPMICommand(IPMIMessagingCommand command, byte userID, boolean isLegacyDevice) {
        int status = 0;
        if (!this.isValidUserID(command, userID)) {
            status = 17;
        } else if (!this.clearUserPrivilege(command, userID)) {
            status = 14;
        } else if (!this.clearUserEnable(command, userID)) {
            status = 13;
        } else if (!this.clearUserPassword(command, userID)) {
            status = 15;
        } else if (!this.clearUserPlusEnable(command, userID)) {
            status = 13;
        } else if (!this.clearUsername(command, userID, isLegacyDevice)) {
            status = 16;
        }
        return status;
    }

    public int deleteUserOEMCommand(IPMIMessagingCommand command, byte userID) {
        int status = 0;
        status = this.clearUserOEM(command, (byte)(userID - 1));
        if (status != 0) {
            // empty if block
        }
        return status;
    }
}

