/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20StatisticsCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 3) {
            MOut.G(this).println("statistics <mode> <domainID> <policy ID>");
            MOut.G(this).println("mode:");
            MOut.G(this).println("  1(01h) \u00a1V Global power statistics in [Watts]");
            MOut.G(this).println("  2(02h) \u00a1V Global inlet temperature statistics in [Celsius]");
            MOut.G(this).println("  3(03h) \u00a1V Global throttling statistics [%] (NM3.0)");
            MOut.G(this).println("  4(04h) \u00a1V Global volumetric airflow statistics [1/10th of CFM] (NM3.0)");
            MOut.G(this).println("  5(05h) \u00a1V Global outlet airflow temperature statistics [Celsius] (NM3.0)");
            MOut.G(this).println("  6(06h) \u00a1V Global chassis power statistics [Watts] (NM3.0)");
            MOut.G(this).println(" 17(11h) \u00a1V Per policy power statistics in [Watts]");
            MOut.G(this).println(" 18(12h) \u00a1V Per policy trigger statistics in [Celsius]");
            MOut.G(this).println(" 19(13h) \u00a1V Per policy throttling statistics in [%] (NM3.0)");
            MOut.G(this).println(" 27(1Bh) \u00a1V Global Host Unhandled Requests statistics");
            MOut.G(this).println(" 28(1Ch) \u00a1V Global Host Response Time statistics");
            MOut.G(this).println(" 29(1Dh) \u00a1V Global CPU throttling statistics");
            MOut.G(this).println(" 30(1Eh) \u00a1V Global memory throttling statistics");
            MOut.G(this).println(" 31(1Fh) \u00a1V Global Host Communication Failure statistics");
            MOut.G(this).println("Domain ID:");
            MOut.G(this).println(" 0 \u00a1V Entire platform");
            MOut.G(this).println(" 1 \u00a1V CPU subsystem");
            MOut.G(this).println(" 2 \u00a1V Memory subsystem");
            MOut.G(this).println(" 3 \u00a1V HW Protection (NM3.0)");
            MOut.G(this).println(" 4 \u00a1V High Power I/O subsystem");
            MOut.G(this).println(" For mode in a range 1Bh to 1Fh Domain ID must be set to 00h");
            MOut.G(this).println("Policy ID:");
            MOut.G(this).println(" Apply for mode 11h or 12h. otherwise set to 0");
            this.statusCode = 0;
            return;
        }
        try {
            byte mode = Byte.parseByte(this.parameters[0]);
            byte did = Byte.parseByte(this.parameters[1]);
            int pid = Integer.parseInt(this.parameters[2]);
            IPMINM20Command.NodeManagerStatistics stat = null;
            stat = this.ipmiNM20Command.getNodeManagerStatistics(mode, did, (byte)pid);
            if (stat == null) {
                MOut.G(this).println("Call getNodeManagerStatistics failed");
                this.statusCode = 147;
                return;
            }
            if ((stat.domainIdAndPolicyState & 0x40) != 64) {
                MOut.G(this).println("Measurements are suspended");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Current = " + ByteUtility.twoBytesToInt(stat.current) + this.getUnit(mode));
            MOut.G(this).println("Minimum = " + ByteUtility.twoBytesToInt(stat.minimum) + this.getUnit(mode));
            MOut.G(this).println("Maximum = " + ByteUtility.twoBytesToInt(stat.maximum) + this.getUnit(mode));
            MOut.G(this).println("Average = " + ByteUtility.twoBytesToInt(stat.average) + this.getUnit(mode));
            MOut.G(this).println("Time    = " + ByteUtility.fourByteToDateFormat2(stat.timeStamp));
            MOut.G(this).println("Reporting Period = " + ByteUtility.fourBytesToIntByLSBFirst(stat.statisticsReportingPeriod) + " sec");
            MOut.G(this).println("Domain ID:");
            if ((stat.domainIdAndPolicyState & 0xF) == 0) {
                MOut.G(this).println("    Entire platform");
            } else if ((stat.domainIdAndPolicyState & 0xF) == 1) {
                MOut.G(this).println("    CPU subsystem");
            } else if ((stat.domainIdAndPolicyState & 0xF) == 2) {
                MOut.G(this).println("    Memory subsystem");
            } else if ((stat.domainIdAndPolicyState & 0xF) == 3) {
                MOut.G(this).println("    HW Protection");
            } else if ((stat.domainIdAndPolicyState & 0xF) == 4) {
                MOut.G(this).println("    High Power I/O subsystem");
            }
            if (mode >= 1 && mode <= 8 || mode >= 17 && mode <= 19) {
                MOut.G(this).println("Policy/Global Administrative state:");
                if ((stat.domainIdAndPolicyState & 0x10) == 16) {
                    if (mode >= 1 && mode <= 8) {
                        MOut.G(this).println("    NM Policy Control is Globally Enabled");
                    } else if (mode >= 17 && mode <= 19) {
                        MOut.G(this).println("    Policy is enabled by user and NM Policy Control is Globally Enabled\n    and Domain control is also Enabled.");
                    }
                } else if ((stat.domainIdAndPolicyState & 0x10) == 0) {
                    MOut.G(this).println("    Policy is not enabled");
                }
            }
            if (mode >= 17 && mode <= 19) {
                MOut.G(this).println("Policy Operational state:");
                if ((stat.domainIdAndPolicyState & 0x20) == 32) {
                    MOut.G(this).println("    Policy is monitoring defined trigger and will start enforcing the ");
                    MOut.G(this).println("    power limit if defined trigger is exceeded");
                } else if ((stat.domainIdAndPolicyState & 0x20) == 0) {
                    MOut.G(this).println("    Policy is suspended");
                }
            }
            if (mode >= 1 && mode <= 8 || mode >= 17 && mode <= 19) {
                MOut.G(this).println("Measurements state:");
                if ((stat.domainIdAndPolicyState & 0x40) == 64) {
                    MOut.G(this).println("    Measurements in progress");
                } else if ((stat.domainIdAndPolicyState & 0x40) == 0) {
                    MOut.G(this).println("    Measurements are suspended");
                }
            }
            if (mode >= 17 && mode <= 19) {
                MOut.G(this).println("Policy activation state:");
                if ((stat.domainIdAndPolicyState & 0xFFFFFF80) == -128) {
                    MOut.G(this).println("    Policy is triggered and is actively limiting the defined power limit");
                } else if ((stat.domainIdAndPolicyState & 0xFFFFFF80) == 0) {
                    MOut.G(this).println("    Policy is not triggered");
                }
            }
            MOut.G(this).println("raw = " + ByteUtility.bytesToHex(stat.raw));
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
    }

    private String getUnit(int mode) {
        switch (mode) {
            case 1: 
            case 6: 
            case 17: {
                return " w";
            }
            case 2: 
            case 5: 
            case 18: {
                return " c";
            }
            case 3: 
            case 19: {
                return " %";
            }
            case 4: {
                return " 1/10th of CFM";
            }
        }
        return " ";
    }
}

