/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMADServerCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte authentication;
    private byte ssl;
    private byte[] port;
    private byte[] timeout;
    private byte[] userDomainName;
    private byte[] ip1;
    private byte[] ip2;
    private byte[] ip3;

    @Override
    public boolean preValidate() {
        block30: {
            String IPV4_REGEX;
            String usage;
            block29: {
                block28: {
                    int tempTimeout;
                    int tempPort;
                    usage = "Usage: ipmi oem x10cfg ad server <authentication> <SSL> <port> <time out> <user domain name> <domain controller server address1> <domain controller server address2> <domain controller server address3> \n\nFor authentication:\nOn  : 1\nOff : 0\nFor SSL:\nOn  : 1\nOff : 0\n* When SLL is on, port number should be 636 or 3269; Off, port number should be 389 or 3268";
                    if (this.parameters == null || this.parameters.length != 8) {
                        MOut.G(this).println(usage);
                        return false;
                    }
                    try {
                        this.authentication = Byte.parseByte(this.parameters[0]);
                    }
                    catch (NumberFormatException ex) {
                        MOut.G(this).println("authentication should be number");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    if (this.authentication < 0 || this.authentication > 1) {
                        MOut.G(this).println("authentication should be 0 or 1");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    try {
                        this.ssl = Byte.parseByte(this.parameters[1]);
                    }
                    catch (NumberFormatException ex) {
                        MOut.G(this).println("ssl should be number");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    if (this.ssl < 0 || this.ssl > 1) {
                        MOut.G(this).println("ssl should be 0 or 1");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    try {
                        tempPort = Integer.parseInt(this.parameters[2]);
                    }
                    catch (NumberFormatException ex) {
                        MOut.G(this).println("port should be number");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    if (this.ssl == 1) {
                        if (tempPort != 636 && tempPort != 3269) {
                            MOut.G(this).println("port should be 636 or 3269");
                            MOut.G(this).println(usage);
                            return false;
                        }
                    } else if (tempPort != 389 && tempPort != 3268) {
                        MOut.G(this).println("port should be 389 or 3268");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    this.port = new byte[2];
                    ByteUtility.intTo2Bytes(this.port, 0, tempPort);
                    try {
                        tempTimeout = Integer.parseInt(this.parameters[3]);
                        if (tempTimeout < 0 || tempTimeout > 65535) {
                            MOut.G(this).println("Time out is out of range");
                            MOut.G(this).println(usage);
                        }
                    }
                    catch (NumberFormatException ex) {
                        MOut.G(this).println("time out should be number");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    this.timeout = new byte[2];
                    ByteUtility.intTo2Bytes(this.timeout, 0, tempTimeout);
                    this.userDomainName = this.parameters[4].getBytes();
                    Pattern special = Pattern.compile("[,;&'\"<>\\\\=$|^?*~`()\\[\\]\\{\\}#%!]");
                    if (special.matcher(this.parameters[4]).matches()) {
                        MOut.G(this).println("Invalid domain name");
                        return false;
                    }
                    Pattern pattern = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,24}$");
                    if (!pattern.matcher(this.parameters[4]).matches()) {
                        MOut.G(this).println("Invalid domain name");
                        return false;
                    }
                    if (this.userDomainName.length > 63) {
                        MOut.G(this).println("user domain name should less then 63 characters");
                        MOut.G(this).println(usage);
                        return false;
                    }
                    IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
                    try {
                        if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[5]).matches()) {
                            throw new NumberFormatException();
                        }
                        this.ip1 = ByteUtility.ipToBytes(this.parameters[5]);
                    }
                    catch (NumberFormatException ex) {
                        if (StunnelUtility.isIPv6(this.parameters[5])) break block28;
                        MOut.G(this).println("domain controller server address1 should be ###.###.###.###, or a valid IPv6 address");
                        MOut.G(this).println(usage);
                        return false;
                    }
                }
                try {
                    if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[6]).matches()) {
                        throw new NumberFormatException();
                    }
                    this.ip2 = ByteUtility.ipToBytes(this.parameters[6]);
                }
                catch (NumberFormatException ex) {
                    if (StunnelUtility.isIPv6(this.parameters[6])) break block29;
                    MOut.G(this).println("domain controller server address2 should be ###.###.###.###, or a valid IPv6 address");
                    MOut.G(this).println(usage);
                    return false;
                }
            }
            try {
                if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[7]).matches()) {
                    throw new NumberFormatException();
                }
                this.ip3 = ByteUtility.ipToBytes(this.parameters[7]);
            }
            catch (NumberFormatException ex) {
                if (StunnelUtility.isIPv6(this.parameters[7])) break block30;
                MOut.G(this).println("domain controller server address3 should be ###.###.###.###, or a valid IPv6 address");
                MOut.G(this).println(usage);
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("AD command is not supported on this device, you may try redfish accountService ad command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            this.statusCode = 149;
            return;
        }
        if (this.checkIfSystemLockdown()) {
            this.statusCode = 149;
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte auth = ipmiOEMWebSettingCommand.getLdap((byte)0)[0];
        if (auth == 1) {
            MOut.G(this).println("LDAP has been enabled, please disable LDAP before enabling Active Directory");
            this.statusCode = 149;
            return;
        }
        byte auth2 = ipmiOEMWebSettingCommand.getRadius((byte)0)[0];
        if (auth2 == 1) {
            MOut.G(this).println("Radius has been enabled, please disable Radius before enabling Active Directory");
            this.statusCode = 149;
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(6);
        target.put(this.authentication);
        target.put(this.ssl);
        target.put(this.port);
        target.put(this.timeout);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)0, target.array())) {
            MOut.G(this).println("Set AD server parameters failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(this.userDomainName.length + 1);
        target.put(this.userDomainName);
        target.put((byte)0);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)1, target.array())) {
            this.statusCode = 149;
            return;
        }
        if (StunnelUtility.isIPv6(this.parameters[5]) || StunnelUtility.isIPv6(this.parameters[6]) || StunnelUtility.isIPv6(this.parameters[7])) {
            String bodyString;
            BasicAuthClient bc = new BasicAuthClient(this.config);
            String url = "https://" + this.config.getIp() + "/redfish/v1/Managers/1/" + "ActiveDirectory";
            int result = bc.send_https_patch(url, bodyString = "{\"DCSAddress1\": \"" + this.parameters[5] + "\",\"DCSAddress2\": \"" + this.parameters[6] + "\",\"DCSAddress3\": \"" + this.parameters[7] + "\",\"UserDomainName\": \"" + this.parameters[4] + "\" }");
            if ((result < 200 || result > 210) && result != 302) {
                MOut.G(this).println("Set AD server domain name via redfish failed");
                this.statusCode = 149;
                return;
            }
        } else {
            target = ByteBuffer.allocate(this.ip1.length + this.ip2.length + this.ip3.length);
            target.put(this.ip1);
            target.put(this.ip2);
            target.put(this.ip3);
            if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)2, target.array())) {
                MOut.G(this).println("Set AD server 3 ip failed");
                this.statusCode = 149;
                return;
            }
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

