/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class IPMIFRURestoreCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        File file = new File(this.parameters[0]);
        FileInputStream fileData = new FileInputStream(file);
        byte[] fruData = new byte[(int)file.length()];
        ((InputStream)fileData).read(fruData);
        FRUInfo fruInfo = FRUInfo.fromRaw(fruData);
        ipmiFRUCommand.unlockFRU();
        boolean result = ipmiFRUCommand.writeFRU(fruInfo.fru);
        ipmiFRUCommand.lockFRU();
        ((InputStream)fileData).close();
        if (result) {
            MOut.G(this).println("Restore FRU raw data successfully");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Restore FRU raw data failed");
            this.statusCode = 149;
        }
    }
}

