/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMIPCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!(IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || this.isConnectToCMM((cmmIndex = Byte.parseByte((String)this.preParameters.get(1))) - 1))) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String newIP = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(newIP)) {
                MOut.G(this).println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (newIP.equals("0.0.0.0")) {
                MOut.G(this).println("IP cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            String oldIP = ipmiLanCommand.getIP();
            boolean result = ipmiLanCommand.setIP(newIP);
            if (result) {
                MOut.G(this).println("old IP:" + oldIP);
                MOut.G(this).println("new IP:" + newIP);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(oldIP);
                MOut.G(this).println("Update IP failed");
                this.statusCode = 149;
            }
        } else {
            String ip = ipmiLanCommand.getIP();
            MOut.G(this).println(ip);
            this.statusCode = 0;
        }
    }
}

